/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.controller;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import umun.core.constants.ValidationException;
import umun.entity.model.EntityPref;
import umun.entity.service.EntityPrefService;
import umun.iam.model.User;
import umun.iam.service.TokenService;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"/api/v1/pref"})
public class EntityPrefController {
    @Autowired
    private TokenService tokenService;
    private static Map<String, EntityPrefService<?, ?, ?>> serviceMap = new HashMap();

    public static void addServiceReference(String entityName, EntityPrefService<?, ?, ?> service) {
        serviceMap.put(entityName, service);
    }

    @GetMapping(value={"/{entityName}/{entityId}"})
    public ResponseEntity<?> read(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId) {
        try {
            return ResponseEntity.ok(EntityPrefController.getServiceOrFail(entityName).read(entityId, this.tokenService.getToken(authHeader).getUser()));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/{entityName}/{entityId}/object"})
    public ResponseEntity<?> readEntity(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId) {
        try {
            return ResponseEntity.ok(EntityPrefController.getServiceOrFail(entityName).findOne(entityId, this.tokenService.getToken(authHeader).getUser()));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/template/{entityName}"})
    public ResponseEntity<?> template(@PathVariable(value="entityName") String entityName, @RequestParam Map<String, String> allRequestParams) {
        try {
            return ResponseEntity.ok(EntityPrefController.getServiceOrFail(entityName).getCreationTemplate(allRequestParams));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/{entityName}/{entityId}/category/"})
    public ResponseEntity<?> readAllPrefs(@RequestHeader(name="Authorization", required=false) String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId) {
        try {
            User requestingUser = null;
            if (authHeader != null && !authHeader.equals("")) {
                requestingUser = this.tokenService.getToken(authHeader).getUser();
            }
            return ResponseEntity.ok(EntityPrefController.getServiceOrFail(entityName).readAllPrefs(requestingUser, entityId));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/{entityName}/{entityId}/category/{categoryId}"})
    public ResponseEntity<?> read(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId, @PathVariable(value="categoryId") long categoryId) {
        try {
            return ResponseEntity.ok(EntityPrefController.getServiceOrFail(entityName).read(this.tokenService.getToken(authHeader).getUser(), categoryId, entityId));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/template/{entityName}/{key}"})
    public ResponseEntity<?> validate(@PathVariable(value="entityName") String entityName, @PathVariable(value="key") String key, @RequestBody(required=true) EntityPref value) {
        try {
            return ResponseEntity.ok((Object)EntityPrefController.getServiceOrFail(entityName).validate(key, value));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/{entityName}/{entityId}/{categoryId}/{key}"})
    public ResponseEntity<?> update(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId, @PathVariable(value="categoryId") long categoryId, @PathVariable(value="key") String key, @RequestBody(required=false) String value) {
        try {
            if (value == null) {
                value = "";
            }
            return ResponseEntity.ok(EntityPrefController.getServiceOrFail(entityName).update(entityId, categoryId, key, value, this.tokenService.getToken(authHeader).getUser()));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    public static EntityPrefService<?, ?, ?> getServiceOrFail(String entityName) throws ValidationException {
        if (!serviceMap.containsKey(entityName)) {
            throw new ValidationException("Entity name not found", HttpStatus.NOT_FOUND);
        }
        return serviceMap.get(entityName);
    }
}

