/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import umun.core.constants.ValidationException;
import umun.entity.model.impl.NamedEntity;
import umun.entity.service.impl.NamedEntityCRUDService;
import umun.entity.templates.controller.EntityController;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.service.TokenService;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"/api/v1/named/entity"})
public class NamedEntityController
extends EntityController<NamedEntity> {
    @Autowired
    private NamedEntityCRUDService crudService;
    @Autowired
    public TokenService tokenService;

    @GetMapping
    public ResponseEntity<?> read(@RequestParam(value="entityName") String entityName) {
        try {
            return ResponseEntity.ok(this.crudService.read(entityName));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @Override
    protected EntityCRUDService<NamedEntity> getCRUDService() {
        return this.crudService;
    }
}

