/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import umun.core.constants.ValidationException;
import umun.entity.model.EntityPref;
import umun.entity.model.TablePref;
import umun.entity.model.TablePrefValidationValue;
import umun.entity.service.TablePrefService;
import umun.iam.service.TokenService;

@RestController
@CrossOrigin(value={"*"})
@RequestMapping(value={"/api/v1/pref"})
public class TablePrefController {
    @Autowired
    private TokenService tokenService;
    private static Map<String, TablePrefService<?, ?, ?, ?>> serviceMap = new HashMap();

    public static void addServiceReference(String entityName, String tableName, TablePrefService<?, ?, ?, ?> service) {
        serviceMap.put(TablePrefController.key(entityName, tableName), service);
    }

    @GetMapping(value={"/{entityName}/{entityId}/table/{tableName}"})
    public ResponseEntity<?> read(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId, @PathVariable(value="tableName") String tableName, @RequestParam(value="page") int page, @RequestParam(name="searchTerm", required=false) String searchTerm) {
        try {
            return ResponseEntity.ok(TablePrefController.getServiceOrFail(entityName, tableName).read(tableName, entityId, page, searchTerm, this.tokenService.getToken(authHeader).getUser()));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @GetMapping(value={"/{entityName}/table/{tableName}/create"})
    public ResponseEntity<?> readForCreattion(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, String> allRequestParams) {
        try {
            return ResponseEntity.ok(TablePrefController.getServiceOrFail(entityName, tableName).readForCreation(tableName, this.tokenService.getToken(authHeader).getUser(), allRequestParams));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/template/{entityName}/table/{tableName}/{key}"})
    public ResponseEntity<?> validate(@PathVariable(value="entityName") String entityName, @PathVariable(value="key") String key, @PathVariable(value="tableName") String tableName, @RequestBody(required=true) EntityPref value) {
        try {
            return ResponseEntity.ok((Object)TablePrefController.getServiceOrFail(entityName, tableName).validate(key, value));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/template/{entityName}/table/{tableName}/{key}/validateAll"})
    public ResponseEntity<?> validateAll(@PathVariable(value="entityName") String entityName, @PathVariable(value="key") String key, @PathVariable(value="tableName") String tableName, @RequestBody(required=true) TablePrefValidationValue value) {
        try {
            return ResponseEntity.ok((Object)TablePrefController.getServiceOrFail(entityName, tableName).validateAll(key, value));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/{entityName}/{entityId}/{categoryId}/{key}/table/{tableName}"})
    public ResponseEntity<?> createTablePrefs(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId, @PathVariable(value="categoryId") long categoryId, @PathVariable(value="key") String key, @PathVariable(value="tableName") String tableName, @RequestBody List<TablePref<EntityPref>> doubleListOfTablePref) {
        try {
            return ResponseEntity.ok(TablePrefController.getServiceOrFail(entityName, tableName).update(entityId, categoryId, key, tableName, this.tokenService.getToken(authHeader).getUser(), tableName, -1L, doubleListOfTablePref));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/{entityName}/{entityId}/{categoryId}/{key}/table/{tableName}/{subEntityId}"})
    public ResponseEntity<?> update(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityName") String entityName, @PathVariable(value="entityId") long entityId, @PathVariable(value="categoryId") long categoryId, @PathVariable(value="key") String key, @PathVariable(value="tableName") String tableName, @PathVariable(value="subEntityId") long subEntityId, @RequestBody(required=false) String value) {
        try {
            if (value == null) {
                value = "";
            }
            return ResponseEntity.ok(TablePrefController.getServiceOrFail(entityName, tableName).update(entityId, categoryId, key, value, this.tokenService.getToken(authHeader).getUser(), tableName, subEntityId, null));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    private static String key(String entityName, String tableName) {
        return String.format("%s--|--%s", entityName, tableName);
    }

    public static TablePrefService<?, ?, ?, ?> getServiceOrFail(String entityName, String tableName) throws ValidationException {
        if (!serviceMap.containsKey(TablePrefController.key(entityName, tableName))) {
            throw new ValidationException("Entity or table name not found", HttpStatus.NOT_FOUND);
        }
        return serviceMap.get(TablePrefController.key(entityName, tableName));
    }
}

