/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import umun.entity.model.EntityPrefCategory;
import umun.entity.model.PrefDataType;
import umun.entity.model.impl.EntityPrefImpl;

@JsonDeserialize(as=EntityPrefImpl.class)
@MappedSuperclass
public abstract class EntityPref {
    @Transient
    private String displayName;
    @Lob
    private String value;
    private PrefDataType datatype;
    private String remoteHideKey;
    @Transient
    private Map<String, String> options;
    @Transient
    private String group;

    public EntityPref(String value, PrefDataType datatype, String remoteHideKey, String displayName) {
        this.value = value;
        this.datatype = datatype;
        this.remoteHideKey = remoteHideKey;
        this.displayName = displayName;
    }

    public EntityPref() {
    }

    public abstract String getKey();

    public abstract void setKey(String var1);

    public abstract Long getCategoryId();

    public abstract void setCategoryId(Long var1);

    public abstract EntityPrefCategory getCategory();

    public abstract void setCategory(EntityPrefCategory var1);

    public String getCategoryDisplayName() {
        return this.getCategory().getDisplayName();
    }

    public String getCategoryName() {
        return this.getCategory().getName();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PrefDataType getDatatype() {
        return this.datatype;
    }

    public void setDatatype(PrefDataType datatype) {
        this.datatype = datatype;
    }

    public String getRemoteHideKey() {
        return this.remoteHideKey;
    }

    public void setRemoteHideKey(String remoteHideKey) {
        this.remoteHideKey = remoteHideKey;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getGroup() {
        if (this.group == null) {
            return "General";
        }
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

