/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpStatus;
import umun.core.constants.ValidationException;
import umun.core.service.SystemPrefService;
import umun.entity.model.CategoryPref;
import umun.entity.model.EntityPref;
import umun.entity.model.EntityPrefCategory;
import umun.entity.model.EntityPrefId;
import umun.entity.model.PrefDataType;
import umun.entity.service.EntityPrefCategoryService;
import umun.entity.service.EntityPrefService;
import umun.entity.service.EntityPrefValidationInterface;
import umun.iam.model.Meta;

public abstract class EntityPrefCategoryInterface<ENTITY extends Meta, PREF extends EntityPref, ID extends EntityPrefId, MAPPED_ENTITY> {
    @Autowired
    private EntityPrefCategoryService categoryService;
    @Autowired
    protected EntityPrefService<ENTITY, PREF, ID> entityPrefService;
    @Autowired
    private SystemPrefService systemPrefService;
    protected EntityPrefCategory category;

    public abstract String getRemoteHideKey();

    protected abstract Boolean getRemoteHideDefault();

    public abstract PrefDataType getDataType();

    public abstract Map<String, String> getOptions();

    public abstract EntityPrefValidationInterface getCustomValidation();

    public abstract String getGroup();

    protected abstract String getCategoryName();

    protected abstract String getCategoryDisplayName();

    protected abstract String getEntityName();

    protected abstract PREF createNewPref(CategoryPref<ENTITY> var1, EntityPrefCategory var2, ENTITY var3);

    protected abstract List<MAPPED_ENTITY> getAllEntitiesToMap(ENTITY var1);

    protected abstract String getKey(MAPPED_ENTITY var1);

    protected abstract String getDisplayName(MAPPED_ENTITY var1);

    protected abstract String getNotFoundDefaultValue(ENTITY var1, String var2, MAPPED_ENTITY var3);

    @EventListener
    public void startUp(ContextRefreshedEvent event) {
        this.category = this.categoryService.readWithoutFail(this.getCategoryName(), this.getEntityName(), this.getRemoteHideKey(), this.getCategoryDisplayName());
        this.entityPrefService.addServiceReference(this.getCategoryName(), this);
        this.systemPrefService.getValue(this.getRemoteHideKey(), Boolean.toString(this.getRemoteHideDefault()));
    }

    public List<PREF> read(ENTITY entity) {
        EntityPrefCategory category = this.categoryService.readWithoutFail(this.getCategoryName(), this.getEntityName(), this.getRemoteHideKey(), this.getCategoryDisplayName());
        ArrayList<PREF> prefs = new ArrayList<PREF>();
        for (CategoryPref<ENTITY> pref : this.getCategoryPrefs(entity)) {
            prefs.add(this.createNewPref(pref, category, entity));
        }
        return prefs;
    }

    public PREF readWithoutFail(ENTITY entity, MAPPED_ENTITY mappedEntity) throws ValidationException {
        return this.entityPrefService.readWithoutFail(entity, this.category, this.getKey(mappedEntity), this.getNotFoundDefaultValue(entity, this.getKey(mappedEntity), mappedEntity));
    }

    public Object getMultiInputValue(ENTITY entity, MAPPED_ENTITY mapped_ENTITY, String optionKey, Object defaultValue) {
        try {
            PREF pref = this.entityPrefService.readWithoutFail(entity, this.category, this.getKey(mapped_ENTITY), this.getNotFoundDefaultValue(entity, this.getKey(mapped_ENTITY), mapped_ENTITY));
            if (!this.getOptions().containsKey(optionKey)) {
                throw new ValidationException(String.format("Option key %s not found", optionKey), HttpStatus.NOT_FOUND);
            }
            switch (this.getDataType()) {
                case MultiInput_Boolean: {
                    return new JSONObject(((EntityPref)pref).getValue()).optBoolean(optionKey);
                }
                case MultiInput_Double: {
                    return new JSONObject(((EntityPref)pref).getValue()).optDouble(optionKey);
                }
                case MultiInput_Long: {
                    return new JSONObject(((EntityPref)pref).getValue()).optLong(optionKey);
                }
                case MultiInput_String: {
                    return new JSONObject(((EntityPref)pref).getValue()).optString(optionKey);
                }
            }
            return defaultValue;
        }
        catch (JSONException | ValidationException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private List<CategoryPref<ENTITY>> getCategoryPrefs(ENTITY entity) {
        List<CategoryPref<ENTITY>> prefs = this.findByEntity(entity);
        ArrayList<CategoryPref<ENTITY>> allPrefs = new ArrayList<CategoryPref<ENTITY>>();
        for (MAPPED_ENTITY mappedEntity : this.getAllEntitiesToMap(entity)) {
            CategoryPref<ENTITY> tempPref = new CategoryPref<ENTITY>(entity, this.getKey(mappedEntity), this.getOverride(prefs, this.getKey(mappedEntity), entity, mappedEntity), this.getOptions(), this.getDataType(), this.getDisplayName(mappedEntity));
            allPrefs.add(tempPref);
        }
        return allPrefs;
    }

    private String getOverride(List<CategoryPref<ENTITY>> prefs, String key, ENTITY entity, MAPPED_ENTITY mapped_ENTITY) {
        for (CategoryPref<ENTITY> categoryPref : prefs) {
            if (!key.equals(categoryPref.getKey())) continue;
            return categoryPref.getValue();
        }
        return this.getNotFoundDefaultValue(entity, key, mapped_ENTITY);
    }

    private List<CategoryPref<ENTITY>> findByEntity(ENTITY entity) {
        List<PREF> prefs = this.entityPrefService.read(entity, this.categoryService.readWithoutFail(this.getCategoryName(), this.getEntityName(), this.getRemoteHideKey(), this.getCategoryDisplayName()));
        ArrayList<CategoryPref<ENTITY>> categoryPrefs = new ArrayList<CategoryPref<ENTITY>>();
        for (EntityPref pref : prefs) {
            categoryPrefs.add(new CategoryPref<ENTITY>(entity, pref.getKey(), pref.getValue(), this.getOptions(), this.getDataType(), pref.getDisplayName()));
        }
        return categoryPrefs;
    }
}

