/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.service;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import umun.core.constants.ValidationException;
import umun.core.util.DateUtil;
import umun.entity.model.EntityPrefCategory;
import umun.entity.repository.EntityPrefCategoryRepository;
import umun.iam.service.UserService;

@Service
public class EntityPrefCategoryService {
    @Autowired
    private EntityPrefCategoryRepository repository;
    @Autowired
    private UserService userService;

    public EntityPrefCategory findRootCategory(String entityName) {
        return this.readWithoutFail("root", entityName, "", "root");
    }

    public List<EntityPrefCategory> read(boolean isDeleted, String entityName) {
        return this.repository.findByDeletedAndEntityName(isDeleted, entityName);
    }

    public EntityPrefCategory readOrFail(long categoryId) throws ValidationException {
        EntityPrefCategory category = (EntityPrefCategory)((Object)this.repository.findOne(Long.valueOf(categoryId)));
        if (category == null) {
            throw new ValidationException("Category not found", HttpStatus.NOT_FOUND);
        }
        return category;
    }

    public EntityPrefCategory readWithoutFail(String name, String entityName, String remoteHideKey, String displayName) {
        EntityPrefCategory category = this.repository.findByNameAndAndEntityNameAndDeleted(name, entityName, false);
        if (category == null) {
            category = new EntityPrefCategory(name, entityName, remoteHideKey, displayName);
            category.setCreatedBy(this.userService.getSystemAdmin());
            category.setCreateTime(DateUtil.getCurrentTimeInIST());
            category = (EntityPrefCategory)((Object)this.repository.saveAndFlush((Object)category));
        } else {
            category.setDisplayName(displayName);
            category = (EntityPrefCategory)((Object)this.repository.saveAndFlush((Object)category));
        }
        return category;
    }
}

