/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpStatus;
import umun.core.constants.ValidationException;
import umun.core.service.SystemPrefService;
import umun.entity.controller.EntityPrefController;
import umun.entity.model.EntityPref;
import umun.entity.model.EntityPrefCategory;
import umun.entity.model.EntityPrefId;
import umun.entity.model.EntityPrefProp;
import umun.entity.model.EntityPrefValue;
import umun.entity.model.PrefDataType;
import umun.entity.model.impl.TemplatePref;
import umun.entity.repository.EntityPrefRepository;
import umun.entity.service.EntityPrefCategoryInterface;
import umun.entity.service.EntityPrefCategoryService;
import umun.entity.service.EntityPrefOptionsInterface;
import umun.entity.service.EntityPrefValidationInterface;
import umun.entity.templates.service.EntityCRUDService;
import umun.entity.util.EntityPrefValidationUtil;
import umun.iam.model.Meta;
import umun.iam.model.User;
import umun.log.service.SystemLogService;

public abstract class EntityPrefService<ENTITY extends Meta, PREF extends EntityPref, ID extends EntityPrefId> {
    public EntityPrefCategory rootCategory;
    @Autowired
    protected EntityPrefCategoryService categoryService;
    @Autowired
    protected SystemPrefService systemPrefService;
    @Autowired
    private SystemLogService systemLogService;

    protected abstract EntityPrefRepository<PREF, ID> getRepository();

    protected abstract Map<String, EntityPrefCategoryInterface<ENTITY, PREF, ID, ?>> getCategoryServicesMap();

    protected abstract Map<String, EntityPrefValue<ENTITY, PREF>> getRootKeys();

    protected abstract List<PREF> findByEntityAndCategoryOrderByKey(ENTITY var1, EntityPrefCategory var2);

    protected abstract PREF createMissingRootPref(ENTITY var1, EntityPrefCategory var2, String var3, EntityPrefValue<ENTITY, PREF> var4, Map<String, String> var5, String var6);

    protected abstract PREF createCategoryAsPref(ENTITY var1, EntityPrefCategory var2) throws ValidationException;

    protected abstract ID createEntityPrefId(ENTITY var1, EntityPrefCategory var2, String var3);

    protected abstract PREF createPref(ENTITY var1, EntityPrefCategory var2, String var3, String var4, String var5) throws ValidationException;

    protected abstract ENTITY findEntityOrFail(long var1, User var3) throws ValidationException;

    protected abstract String getEntityName();

    protected abstract EntityCRUDService<ENTITY> getCrudService();

    @EventListener
    public void startUp(ContextRefreshedEvent event) {
        this.rootCategory = this.categoryService.findRootCategory(this.getEntityName());
        EntityPrefController.addServiceReference(this.getEntityName(), this);
        this.systemPrefService.setValue("Entity Version", "101");
    }

    public void addRootKeys(String rootKey, String defaultValue, String remoteHideKey, PrefDataType dataType, EntityPrefOptionsInterface optionsInterface, String displayName, EntityPrefValidationInterface<ENTITY, PREF> entityPrefValidationInterface, String group, boolean defaultRemoteHide, EntityPrefProp<ENTITY, PREF> properties) {
        this.systemPrefService.getValue(remoteHideKey, String.valueOf(defaultRemoteHide));
        this.getRootKeys().put(rootKey, new EntityPrefValue<ENTITY, PREF>(defaultValue, remoteHideKey, dataType, optionsInterface, displayName, entityPrefValidationInterface, group, properties));
    }

    public void addServiceReference(String categoryName, EntityPrefCategoryInterface<ENTITY, PREF, ID, ?> instance) {
        this.getCategoryServicesMap().put(categoryName, instance);
    }

    public PREF createOrUpdate(ENTITY entity, EntityPrefCategory category, String key, String value, User requestedBy) throws ValidationException {
        PREF pref = this.readWithoutFail(entity, category, key, value);
        String oldValue = ((EntityPref)pref).getValue();
        this.validateCreateOrUpdate(entity, category, key, value, requestedBy, pref);
        pref = this.doPostCreationOperations(entity, category, pref, key, value, requestedBy);
        this.saveAndFlush(entity, category, pref, key, value, requestedBy, oldValue);
        return pref;
    }

    protected PREF saveAndFlush(ENTITY entity, EntityPrefCategory category, PREF pref, String key, String value, User requestedBy, String oldValue) {
        pref = (EntityPref)this.getRepository().saveAndFlush(pref);
        this.systemLogService.create(requestedBy, "Value for %s (%d %s) Changed in category [%s] & key [%s]. Old Value: %s. New Value: %s", new Object[]{category.getEntityName(), entity.getId(), entity.getName(), category.getDisplayName(), key, oldValue, ((EntityPref)pref).getValue()});
        return (PREF)pref;
    }

    protected void validateCreateOrUpdate(ENTITY entity, EntityPrefCategory category, String key, String value, User requestedBy, PREF pref) throws ValidationException {
    }

    protected PREF doPostCreationOperations(ENTITY entity, EntityPrefCategory category, PREF pref, String key, String value, User requestedBy) throws ValidationException {
        ((EntityPref)pref).setValue(value);
        ((EntityPref)pref).setOptions(this.getOptions(category, key, entity));
        EntityPrefValidationUtil.validate(pref);
        this.doCustomValidation(entity, pref);
        this.mapPrefToField(entity, pref, requestedBy);
        return pref;
    }

    public List<PREF> read(long entityId, User requestedBy) throws ValidationException {
        return this.read((ID)this.findEntityOrFail(entityId, requestedBy));
    }

    public List<PREF> read(User requestedBy, long categoryId, long entityId) throws ValidationException {
        EntityPrefCategory category = this.categoryService.readOrFail(categoryId);
        ENTITY entity = this.findEntityOrFail(entityId, requestedBy);
        if (this.getCategoryServicesMap().containsKey(category.getName()) && this.getCategoryServicesMap().get(category.getName()) != null) {
            try {
                return this.getCategoryServicesMap().get(category.getName()).read(entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.read(entity, category);
    }

    public List<PREF> read(ENTITY entity, EntityPrefCategory category) {
        return this.findByEntityAndCategoryOrderByKey(entity, category);
    }

    public Map<String, List<PREF>> readAllPrefs(User requestedBy, long entityId) throws ValidationException {
        ENTITY entity = this.findEntityOrFail(entityId, requestedBy);
        HashMap<String, List<PREF>> allPrefs = new HashMap<String, List<PREF>>();
        for (EntityPrefCategory category : this.categoryService.read(false, this.getEntityName())) {
            List<PREF> prefs;
            if (category.getName().equals("root")) {
                prefs = this.findByEntityAndCategoryOrderByKey(entity, category);
                prefs.addAll(this.getMissingRootPrefs(prefs, entity, category));
            } else {
                prefs = this.getCategoryServicesMap().get(category.getName()).read(entity);
            }
            allPrefs.put(category.getName(), prefs);
        }
        return allPrefs;
    }

    public List<PREF> read(ENTITY entity) {
        List<PREF> prefs = this.findByEntityAndCategoryOrderByKey(entity, this.rootCategory);
        prefs.addAll(this.getMissingRootPrefs(prefs, entity, this.rootCategory));
        prefs.addAll(this.getCategoriesAsPrefs(entity));
        prefs.sort((o1, o2) -> {
            if (o1.getDisplayName() != null && o2.getDisplayName() != null) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
            if (o1.getCategory() != null && o1.getCategory().getDisplayName() != null && o2.getCategory() != null && o2.getCategory().getDisplayName() != null) {
                return o2.getCategory().getDisplayName().compareTo(o1.getCategory().getDisplayName());
            }
            return 0;
        });
        prefs = this.removeHidden(prefs);
        return prefs;
    }

    public PREF readWithoutFail(ENTITY entity, EntityPrefCategory category, String key, String value) throws ValidationException {
        PREF pref = this.read(this.createEntityPrefId(entity, category, key));
        if (pref == null) {
            pref = this.createPref(entity, category, key, value, this.getRemoteHideKey(category, key));
        }
        return pref;
    }

    public PREF readOrFail(ENTITY entity, EntityPrefCategory category, String key) throws ValidationException {
        PREF pref = this.read(this.createEntityPrefId(entity, category, key));
        if (pref == null) {
            throw new ValidationException(String.format("Key %s not found", key), HttpStatus.NOT_FOUND);
        }
        return pref;
    }

    public List<TemplatePref> getCreationTemplate(Map<String, String> allRequestParams) {
        ArrayList<TemplatePref> prefs = new ArrayList<TemplatePref>();
        this.getRootKeys().forEach((key, value) -> {
            if (this.systemPrefService.getValue(value.remoteHideKey, "false").equals("true") && value.dataType != PrefDataType.Table) {
                TemplatePref templatePref = new TemplatePref(this.getEntityName(), (String)key, this.rootCategory.getId(), this.rootCategory, value.value, value.dataType, value.remoteHideKey, value.displayName);
                templatePref.setGroup(value.group);
                templatePref.setOptions(value.getOptions(null, allRequestParams));
                if (value.getAdditionaProperties() != null) {
                    templatePref.setRequired(value.getAdditionaProperties().isRequiredInCreateTemplate());
                    templatePref.setNumberOfOptionsAsList(value.getAdditionaProperties().getNumberOfOptionsAsList());
                }
                if (value.getAdditionaProperties() == null || !value.getAdditionaProperties().isHiddenInCreateTemplate()) {
                    prefs.add(templatePref);
                }
            }
        });
        return prefs;
    }

    public String validate(String key, EntityPref value) throws ValidationException {
        if (!this.getRootKeys().containsKey(key)) {
            throw new ValidationException("Key not found.", HttpStatus.NOT_FOUND);
        }
        EntityPrefValue<ENTITY, PREF> entityPrefValue = this.getRootKeys().get(key);
        if (entityPrefValue.entityPrefValidationInterface != null) {
            entityPrefValue.entityPrefValidationInterface.validate(null, value);
        }
        return "Valid";
    }

    public ENTITY findOne(long entityId, User requestedBy) throws ValidationException {
        return this.findEntityOrFail(entityId, requestedBy);
    }

    protected PREF read(ID entityPrefId) {
        return (PREF)((EntityPref)this.getRepository().findOne((Serializable)entityPrefId));
    }

    public PREF update(long entityId, long categoryId, String key, String value, User requestedBy) throws ValidationException {
        return this.createOrUpdate(this.findEntityOrFail(entityId, requestedBy), this.categoryService.readOrFail(categoryId), key, value, requestedBy);
    }

    protected String getRemoteHideKey(EntityPrefCategory category, String key) throws ValidationException {
        if (category.getName().equalsIgnoreCase("root")) {
            if (!this.getRootKeys().containsKey(key)) {
                throw new ValidationException("Remote hide key not found in root " + key, HttpStatus.NOT_FOUND);
            }
            return this.getRootKeys().get((Object)key).remoteHideKey;
        }
        if (!this.getCategoryServicesMap().containsKey(category.getName())) {
            throw new ValidationException("Remote hide key not found in category " + key, HttpStatus.NOT_FOUND);
        }
        return this.getCategoryServicesMap().get(category.getName()).getRemoteHideKey();
    }

    protected PrefDataType getDataType(EntityPrefCategory category, String key) throws ValidationException {
        if (category.getName().equalsIgnoreCase("root")) {
            if (!this.getRootKeys().containsKey(key)) {
                throw new ValidationException("Data type not found in root " + key, HttpStatus.NOT_FOUND);
            }
            return this.getRootKeys().get((Object)key).dataType;
        }
        if (!this.getCategoryServicesMap().containsKey(category.getName())) {
            throw new ValidationException("Data type key not found in category " + key, HttpStatus.NOT_FOUND);
        }
        return this.getCategoryServicesMap().get(category.getName()).getDataType();
    }

    protected Map<String, String> getOptions(EntityPrefCategory category, String key, ENTITY entity) throws ValidationException {
        if (category.getName().equalsIgnoreCase("root")) {
            if (!this.getRootKeys().containsKey(key)) {
                throw new ValidationException("Data type not found in root " + key, HttpStatus.NOT_FOUND);
            }
            return this.getRootKeys().get(key).getOptions(entity);
        }
        if (!this.getCategoryServicesMap().containsKey(category.getName())) {
            throw new ValidationException("Data type key not found in category " + key, HttpStatus.NOT_FOUND);
        }
        return this.getCategoryServicesMap().get(category.getName()).getOptions();
    }

    protected String getGroup(EntityPrefCategory category, String key) throws ValidationException {
        if (category.getName().equalsIgnoreCase("root")) {
            if (!this.getRootKeys().containsKey(key)) {
                throw new ValidationException("Group not found in root " + key, HttpStatus.NOT_FOUND);
            }
            return this.getRootKeys().get((Object)key).group;
        }
        if (!this.getCategoryServicesMap().containsKey(category.getName())) {
            throw new ValidationException("Group not found in category " + key, HttpStatus.NOT_FOUND);
        }
        return this.getCategoryServicesMap().get(category.getName()).getGroup();
    }

    protected String getDisplayname(String key) {
        if (!this.getRootKeys().containsKey(key)) {
            return key;
        }
        return this.getRootKeys().get((Object)key).displayName;
    }

    private void doCustomValidation(ENTITY entity, PREF pref) throws ValidationException {
        if (((EntityPref)pref).getCategoryName().equals("root")) {
            if (!this.getRootKeys().containsKey(((EntityPref)pref).getKey())) {
                throw new ValidationException("Custom Validation not found in root " + ((EntityPref)pref).getKey(), HttpStatus.NOT_FOUND);
            }
            if (this.getRootKeys().get((Object)((EntityPref)pref).getKey()).entityPrefValidationInterface != null) {
                this.getRootKeys().get((Object)((EntityPref)pref).getKey()).entityPrefValidationInterface.validate(entity, (EntityPref)pref);
            }
        } else {
            if (!this.getCategoryServicesMap().containsKey(((EntityPref)pref).getCategoryName())) {
                throw new ValidationException("Custom Validation key not found in category " + ((EntityPref)pref).getKey(), HttpStatus.NOT_FOUND);
            }
            if (this.getCategoryServicesMap().get(((EntityPref)pref).getCategoryName()).getCustomValidation() != null) {
                this.getCategoryServicesMap().get(((EntityPref)pref).getCategoryName()).getCustomValidation().validate(entity, (EntityPref)pref);
            }
        }
    }

    private void mapPrefToField(ENTITY entity, PREF pref, User modifiedBy) {
        EntityPrefValue<ENTITY, PREF> prefValue;
        if (((EntityPref)pref).getCategoryName().equals("root") && (prefValue = this.getRootKeys().get(((EntityPref)pref).getKey())) != null && prefValue.getAdditionaProperties() != null && prefValue.getAdditionaProperties().getMappedField() != null) {
            if (this.getCrudService() == null) {
                System.err.println("getCrudService() not overridden in EntityPrefService " + entity.getName());
                return;
            }
            prefValue.getAdditionaProperties().getMappedField().map(entity, pref);
        }
    }

    protected List<PREF> removeHidden(List<PREF> prefs) {
        ArrayList<EntityPref> visiblePrefs = new ArrayList<EntityPref>();
        for (EntityPref _pref : prefs) {
            if (_pref.getRemoteHideKey() == null || _pref.getRemoteHideKey().equals("") || !Boolean.parseBoolean(this.systemPrefService.getValue(_pref.getRemoteHideKey(), "true"))) continue;
            visiblePrefs.add(_pref);
        }
        return visiblePrefs;
    }

    private List<? extends PREF> getMissingRootPrefs(List<PREF> prefs, ENTITY entity, EntityPrefCategory rootCategory) {
        ArrayList<EntityPref> missingPrefs = new ArrayList<EntityPref>();
        EntityPref missingRootPref = null;
        boolean found = false;
        for (Map.Entry<String, EntityPrefValue<ENTITY, PREF>> entry : this.getRootKeys().entrySet()) {
            found = false;
            for (EntityPref pref : prefs) {
                if (!pref.getKey().equalsIgnoreCase(entry.getKey())) continue;
                found = true;
                this.doPostFoundOperations(pref, entry.getValue(), entity);
            }
            if (!found & !this.isDoNotAddIfMissing(entry.getKey(), entity)) {
                missingRootPref = (EntityPref)this.createMissingRootPref(entity, rootCategory, entry.getKey(), entry.getValue(), entry.getValue().getOptions(entity), entry.getValue().group);
                if (entry.getValue().additionaProperties != null && entry.getValue().additionaProperties.getFieldPrefMapping() != null) {
                    missingRootPref.setValue(entry.getValue().additionaProperties.getFieldPrefMapping().getValue(entity, missingRootPref));
                }
                missingPrefs.add(missingRootPref);
            }
            found = false;
        }
        return missingPrefs;
    }

    protected PREF doPostFoundOperations(PREF pref, EntityPrefValue<ENTITY, PREF> value, ENTITY entity) {
        ((EntityPref)pref).setOptions(value.getOptions(entity));
        ((EntityPref)pref).setGroup(value.group);
        ((EntityPref)pref).setDisplayName(value.displayName);
        return pref;
    }

    protected boolean isDoNotAddIfMissing(String key, ENTITY entity) {
        return false;
    }

    private List<? extends PREF> getCategoriesAsPrefs(ENTITY entity) {
        ArrayList prefs = new ArrayList();
        this.categoryService.read(false, this.getEntityName()).forEach(category -> {
            if (!category.getName().equals("root")) {
                try {
                    prefs.add(this.createCategoryAsPref(entity, (EntityPrefCategory)((Object)category)));
                }
                catch (ValidationException e) {
                    System.err.println("Error in creating category as pref " + category.getName());
                    e.printStackTrace();
                }
            }
        });
        return prefs;
    }
}

