/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.http.HttpStatus;
import umun.core.constants.ValidationException;
import umun.entity.controller.TablePrefController;
import umun.entity.model.EntityPref;
import umun.entity.model.EntityPrefCategory;
import umun.entity.model.EntityPrefProp;
import umun.entity.model.EntityPrefValue;
import umun.entity.model.PrefDataType;
import umun.entity.model.TableEntityPref;
import umun.entity.model.TableEntityPrefId;
import umun.entity.model.TablePref;
import umun.entity.model.TablePrefSlotItem;
import umun.entity.model.TablePrefValidationValue;
import umun.entity.service.EntityPrefOptionsInterface;
import umun.entity.service.EntityPrefOverrideService;
import umun.entity.service.EntityPrefValidationInterface;
import umun.entity.util.EntityPrefValidationUtil;
import umun.iam.model.Meta;
import umun.iam.model.User;

public abstract class TablePrefService<ENTITY extends Meta, SUB_ENTITY extends Meta, PREF extends TableEntityPref, ID extends TableEntityPrefId>
extends EntityPrefOverrideService<ENTITY, PREF, ID> {
    public abstract String getTableName();

    protected abstract Slice<SUB_ENTITY> readSubEntities(ENTITY var1, int var2, String var3);

    protected abstract PREF createMissingRootPref(ENTITY var1, EntityPrefCategory var2, String var3, EntityPrefValue<ENTITY, PREF> var4, Map<String, String> var5, String var6, SUB_ENTITY var7);

    protected abstract SUB_ENTITY findSubEntityOrFail(long var1, User var3) throws ValidationException;

    protected abstract PREF createPref(ENTITY var1, EntityPrefCategory var2, String var3, String var4, String var5, SUB_ENTITY var6) throws ValidationException;

    protected abstract List<PREF> readSavedPrefs(ENTITY var1, Slice<SUB_ENTITY> var2, EntityPrefCategory var3);

    protected abstract ID createEntityPrefId(ENTITY var1, EntityPrefCategory var2, String var3, SUB_ENTITY var4);

    protected abstract void createSubEntities(ENTITY var1, String var2, List<TablePref<EntityPref>> var3, User var4);

    @Override
    protected abstract Map<String, EntityPrefValue<ENTITY, PREF>> getRootKeys();

    @Override
    public void startUp(ContextRefreshedEvent event) {
        this.rootCategory = this.categoryService.findRootCategory(this.getEntityName());
        TablePrefController.addServiceReference(this.getEntityName(), this.getTableName(), this);
    }

    @Override
    public void addRootKeys(String rootKey, String defaultValue, String remoteHideKey, PrefDataType dataType, EntityPrefOptionsInterface optionsInterface, String displayName, EntityPrefValidationInterface<ENTITY, PREF> entityPrefValidationInterface, String group, boolean defaultRemoteHide, EntityPrefProp<ENTITY, PREF> properties) {
        this.systemPrefService.getValue(remoteHideKey, String.valueOf(defaultRemoteHide));
        this.getRootKeys().put(rootKey, new EntityPrefValue<ENTITY, PREF>(defaultValue, remoteHideKey, dataType, optionsInterface, displayName, entityPrefValidationInterface, group, properties, this.getTableName()));
    }

    public PREF createOrUpdate(ENTITY entity, EntityPrefCategory category, String key, String value, User requestedBy, SUB_ENTITY subEntity) throws ValidationException {
        Object pref = this.readWithoutFail(entity, category, key, value, subEntity);
        String oldValue = ((EntityPref)pref).getValue();
        pref = (TableEntityPref)this.doPostCreationOperations(entity, category, pref, key, value, requestedBy);
        this.mapSubEntityPrefToField(subEntity, pref, requestedBy);
        this.saveAndFlush(entity, category, pref, key, value, requestedBy, oldValue);
        return pref;
    }

    public Slice<TablePref<PREF>> read(String tableName, long entityId, int page, String searchTerm, User user) throws ValidationException {
        Object entity = this.findEntityOrFail(entityId, user);
        Slice<SUB_ENTITY> subEntities = this.readSubEntities(entity, page, searchTerm);
        List<PREF> savedPrefs = this.readSavedPrefs(entity, subEntities, this.rootCategory);
        HashMap savedPrefsMap = new HashMap();
        savedPrefs.forEach(pref -> savedPrefsMap.put(this.createKeyForSubEntityMap(pref.getKey(), pref.getSubEntityId()), pref));
        return this.mergeMissingPrefs(entity, subEntities, page, savedPrefsMap);
    }

    public PREF readWithoutFail(ENTITY entity, EntityPrefCategory category, String key, String value, SUB_ENTITY subEntity) throws ValidationException {
        TableEntityPref pref = (TableEntityPref)this.read(this.createEntityPrefId(entity, category, key, subEntity));
        if (pref == null) {
            pref = this.createPref(entity, category, key, value, this.getRemoteHideKey(category, key), subEntity);
        }
        return (PREF)pref;
    }

    public PREF update(long entityId, long categoryId, String key, String value, User requestedBy, String tableName, long subEntityId, List<TablePref<EntityPref>> doubleListOfTablePref) throws ValidationException {
        Object entity = this.findEntityOrFail(entityId, requestedBy);
        if (subEntityId < 0L) {
            this.createSubEntities(entity, tableName, doubleListOfTablePref, requestedBy);
        }
        return this.createOrUpdate(entity, this.categoryService.readOrFail(categoryId), key, value, requestedBy, this.findSubEntityOrFail(subEntityId, requestedBy));
    }

    private void mapSubEntityPrefToField(SUB_ENTITY entity, PREF pref, User modifiedBy) {
        EntityPrefValue<ENTITY, PREF> prefValue;
        if (((EntityPref)pref).getCategoryName().equals("root") && (prefValue = this.getRootKeys().get(((EntityPref)pref).getKey())) != null && prefValue.getAdditionaProperties() != null && prefValue.getAdditionaProperties().getSubEntityMappedField() != null) {
            if (this.getCrudService() == null) {
                System.err.println("getCrudService() not overridden in EntityPrefService " + entity.getName());
                return;
            }
            prefValue.getAdditionaProperties().getSubEntityMappedField().map(entity, pref);
        }
    }

    private Slice<TablePref<PREF>> mergeMissingPrefs(ENTITY entity, Slice<SUB_ENTITY> subEntities, int page, Map<String, PREF> savedPrefsMap) {
        ArrayList missingPrefs = new ArrayList();
        subEntities.forEach(sub -> {
            ArrayList prefs = new ArrayList();
            this.getRootKeys().forEach((key, value) -> {
                if (savedPrefsMap.containsKey(this.createKeyForSubEntityMap((String)key, sub.getId()))) {
                    prefs.add(this.doPostFoundOperations((EntityPref)savedPrefsMap.get(this.createKeyForSubEntityMap((String)key, sub.getId())), value, entity));
                } else {
                    prefs.add(this.createMissingRootPref(entity, this.rootCategory, (String)key, (EntityPrefValue<ENTITY, PREF>)value, value.getOptions(entity), value.group, (SUB_ENTITY)sub));
                }
            });
            missingPrefs.add(new TablePref((Meta)sub, this.removeHidden(prefs), this.getSlotItems(sub)));
        });
        return new SliceImpl(missingPrefs, (Pageable)new PageRequest(page, subEntities.getSize()), subEntities.hasNext());
    }

    private String createKeyForSubEntityMap(String key, long subEntityId) {
        return String.format("%d::::%s", subEntityId, key);
    }

    public Slice<TablePref<EntityPref>> readForCreation(String tableName, User user, Map<String, String> allRequestParams) {
        throw new UnsupportedOperationException("Do not call this method: readForCreation - Override in sub class");
    }

    protected TablePrefSlotItem[] getSlotItems(SUB_ENTITY sub) {
        return null;
    }

    @Override
    public String validate(String key, EntityPref pref) throws ValidationException {
        EntityPrefValidationUtil.validate(pref);
        System.out.println(pref.getKey());
        return super.validate(key, pref);
    }

    public String validateAll(String key, TablePrefValidationValue value) throws ValidationException {
        double totalCredits = 0.0;
        double totalDebits = 0.0;
        for (TablePref<EntityPref> tablePref : value.tablePrefs) {
            for (EntityPref pref : tablePref.prefs) {
                if (pref.getKey().equals("--jt-transaction-credits")) {
                    totalCredits += Double.parseDouble(pref.getValue());
                }
                if (!pref.getKey().equals("--jt-transaction-debits")) continue;
                totalDebits += Double.parseDouble(pref.getValue());
            }
        }
        if (totalCredits != totalDebits) {
            throw new ValidationException("Total Credits != Total Debits", HttpStatus.NOT_ACCEPTABLE);
        }
        value.tablePrefs.forEach(p -> p.prefs.forEach(pref -> {
            System.out.println(pref.getKey());
            System.out.println(pref.getValue());
            System.out.println("TODO: validation");
        }));
        return "Valid";
    }
}

