/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.templates.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import umun.core.constants.ValidationException;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.model.Meta;
import umun.iam.service.TokenService;

public abstract class EntityController<ENTITY extends Meta> {
    @Autowired
    public TokenService tokenService;

    protected abstract EntityCRUDService<ENTITY> getCRUDService();

    @PostMapping
    public ResponseEntity<?> create(@RequestHeader(value="Authorization") String authHeader, @RequestBody ENTITY entity) {
        try {
            return ResponseEntity.ok(this.getCRUDService().create(entity, this.tokenService.getAdminToken(authHeader).getUser()));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/{entityId}"})
    public ResponseEntity<?> update(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityId") long entityId, @RequestBody ENTITY entity) {
        try {
            return ResponseEntity.ok(this.getCRUDService().update(entityId, entity, this.tokenService.getAdminToken(authHeader).getUser()));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @DeleteMapping(value={"/{entityId}"})
    public ResponseEntity<?> delete(@RequestHeader(value="Authorization") String authHeader, @PathVariable(value="entityId") long entityId) {
        try {
            return ResponseEntity.ok(this.getCRUDService().delete(entityId, this.tokenService.getAdminToken(authHeader).getUser()));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }
}

