/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.templates.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import umun.core.constants.ValidationException;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.model.Meta;
import umun.iam.model.User;
import umun.iam.service.UserService;
import umun.iam.service.UserServiceBasic;

public abstract class EntityControllerV2<ENTITY extends Meta> {
    @Autowired
    public UserService userService;

    protected abstract EntityCRUDService<ENTITY> getCRUDService();

    @PostMapping
    public ResponseEntity<?> create(Authentication authentication, @RequestBody ENTITY entity) {
        try {
            return ResponseEntity.ok(this.getCRUDService().create(entity, (User)UserServiceBasic.getUser((Authentication)authentication)));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @PutMapping(value={"/{entityId}"})
    public ResponseEntity<?> update(Authentication authentication, @PathVariable(value="entityId") long entityId, @RequestBody ENTITY entity) {
        try {
            return ResponseEntity.ok(this.getCRUDService().update(entityId, entity, (User)UserServiceBasic.getUser((Authentication)authentication)));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @DeleteMapping(value={"/{entityId}"})
    public ResponseEntity<?> delete(Authentication authentication, @PathVariable(value="entityId") long entityId) {
        try {
            return ResponseEntity.ok(this.getCRUDService().delete(entityId, (User)UserServiceBasic.getUser((Authentication)authentication)));
        }
        catch (ValidationException e) {
            return ResponseEntity.status((HttpStatus)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }
}

