/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.templates.service;

import java.util.List;
import java.util.Set;
import org.springframework.http.HttpStatus;
import umun.core.constants.ValidationException;
import umun.core.util.DateUtil;
import umun.entity.model.EntityCreateOption;
import umun.entity.model.impl.NamedEntity;
import umun.entity.templates.repository.EntityCRUDRepository;
import umun.entity.templates.service.EntityFilterService;
import umun.entity.templates.service.EntityService;
import umun.iam.model.Meta;
import umun.iam.model.User;

public abstract class EntityCRUDService<ENTITY extends Meta> {
    protected abstract EntityService<ENTITY, ?, ?> getEntityService();

    protected abstract EntityCRUDRepository<ENTITY> getRepository();

    protected abstract String getEntityName();

    protected abstract void validateCreate(ENTITY var1, User var2) throws ValidationException;

    protected abstract void validateUpdate(ENTITY var1, ENTITY var2, User var3) throws ValidationException;

    protected abstract void validateDelete(ENTITY var1, User var2) throws ValidationException;

    protected abstract ENTITY setValuesOnUpdate(ENTITY var1, ENTITY var2, User var3) throws ValidationException;

    protected abstract ENTITY setVariablesOnCreate(ENTITY var1) throws ValidationException;

    protected abstract EntityFilterService<ENTITY> getFilterService();

    public ENTITY create(ENTITY entity, User createdBy) throws ValidationException {
        if (entity == null) {
            throw new ValidationException("Provide " + this.getEntityName(), HttpStatus.METHOD_NOT_ALLOWED);
        }
        this.validateCreate(entity, createdBy);
        if (entity.getId() != null && this.getRepository().findOne(entity.getId()) != null) {
            throw new ValidationException(this.getEntityName() + " ID already exists", HttpStatus.METHOD_NOT_ALLOWED);
        }
        entity.setCreateTime(DateUtil.getCurrentTimeInIST());
        entity.setCreatedBy(createdBy);
        entity = (Meta)this.getRepository().saveAndFlush(this.setVariablesOnCreate((Meta)this.getRepository().saveAndFlush(entity)));
        this.afterCreate(entity);
        return entity;
    }

    public List<ENTITY> read() throws ValidationException {
        return this.addPrefs(this.getRepository().findByDeletedOrderByNameDesc(false));
    }

    public List<ENTITY> read(boolean allowDeleted) {
        if (allowDeleted) {
            return this.getRepository().findAll();
        }
        return this.getRepository().findByDeletedOrderByNameDesc(false);
    }

    public List<ENTITY> read(NamedEntity filter) throws ValidationException {
        if (this.getFilterService() == null) {
            return this.read();
        }
        return this.addPrefs(this.getFilterService().read(filter));
    }

    public List<ENTITY> read(Set<Long> ids) throws ValidationException {
        return this.addPrefs(this.getRepository().findByDeletedAndIdInOrderByIdDesc(false, ids));
    }

    public ENTITY readOrFail(Long entityId, User requestedBy) throws ValidationException {
        Meta entity = (Meta)this.getRepository().findOne(entityId);
        if (entity == null) {
            throw new ValidationException(String.format("%s not found", this.getEntityName()), HttpStatus.NOT_FOUND);
        }
        return (ENTITY)entity;
    }

    public ENTITY update(long entityId, ENTITY entity, User modifiedBy) throws ValidationException {
        ENTITY savedEntity = this.readOrFail(entityId, modifiedBy);
        this.validateUpdate(savedEntity, entity, modifiedBy);
        savedEntity = this.setValuesOnUpdate(savedEntity, entity, modifiedBy);
        savedEntity.setName(entity.getName());
        savedEntity.setModificationTime(DateUtil.getCurrentTimeInIST());
        savedEntity.setModifiedBy(modifiedBy);
        return (ENTITY)((Meta)this.getRepository().saveAndFlush(savedEntity));
    }

    public ENTITY delete(long entityId, User modifiedBy) throws ValidationException {
        ENTITY savedEntity = this.readOrFail(entityId, modifiedBy);
        this.validateDelete(savedEntity, modifiedBy);
        savedEntity.setDeleted(true);
        savedEntity.setModificationTime(DateUtil.getCurrentTimeInIST());
        savedEntity.setModifiedBy(modifiedBy);
        return (ENTITY)((Meta)this.getRepository().saveAndFlush(savedEntity));
    }

    public List<ENTITY> addPrefs(List<ENTITY> entites) throws ValidationException {
        return this.getEntityService().addPrefs(entites);
    }

    protected void afterCreate(ENTITY entity) {
    }

    public List<EntityCreateOption> getCreateOptions() throws ValidationException {
        return null;
    }
}

