/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.templates.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import umun.core.constants.ValidationException;
import umun.entity.model.EntityPref;
import umun.entity.model.EntityPrefId;
import umun.entity.model.EntityPrefProp;
import umun.entity.model.PrefDataType;
import umun.entity.service.EntityPrefOptionsInterface;
import umun.entity.service.EntityPrefService;
import umun.entity.service.EntityPrefValidationInterface;
import umun.iam.model.Meta;

public abstract class EntityService<ENTITY extends Meta, PREF extends EntityPref, ID extends EntityPrefId> {
    protected abstract ENTITY addPref(ENTITY var1) throws ValidationException;

    protected abstract void addRootsPref();

    protected abstract void onStartUp();

    protected abstract EntityPrefService<ENTITY, PREF, ID> getPrefService();

    @EventListener
    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.onStartUp();
        this.addRootsPref();
    }

    public List<ENTITY> addPrefs(List<ENTITY> entities) throws ValidationException {
        if (entities == null) {
            System.err.println("EntityService: Null entites list sent to addPrefs");
            return new ArrayList();
        }
        for (Meta entity : entities) {
            Meta meta = this.addPref(entity);
        }
        return entities;
    }

    public void addRootKeys(String rootKey, String defaultValue, String remoteHideKey, PrefDataType dataType, EntityPrefOptionsInterface optionsInterface, String displayName, EntityPrefValidationInterface<ENTITY, PREF> entityPrefValidationInterface, String group, boolean defaultRemoteHide, EntityPrefProp properties) {
        this.getPrefService().addRootKeys(rootKey, defaultValue, remoteHideKey, dataType, optionsInterface, displayName, entityPrefValidationInterface, group, defaultRemoteHide, properties);
    }
}

