/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.templates.service;

import java.util.Set;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import umun.core.constants.ValidationException;
import umun.entity.model.impl.NamedEntity;
import umun.entity.templates.service.EntityCRUDService;
import umun.iam.model.Meta;

public abstract class PaginatedEntityCRUDService<ENTITY extends Meta>
extends EntityCRUDService<ENTITY> {
    public static final int PAGE_SIZE = 40;

    public Slice<ENTITY> read(int page) {
        return this.addPrefs(this.getRepository().findByDeletedOrderByIdDesc(false, (Pageable)new PageRequest(page, 40)));
    }

    public Slice<ENTITY> read(NamedEntity filter, int page) throws ValidationException {
        return this.addPrefs(this.getFilterService().read(filter, page));
    }

    public Slice<ENTITY> read(Set<Long> ids, int page) throws ValidationException {
        return this.addPrefs(this.getRepository().findByDeletedAndIdInOrderByIdDesc(false, ids, (Pageable)new PageRequest(page, 40)));
    }

    @Override
    protected Slice<ENTITY> addPrefs(Slice<ENTITY> slice) {
        if (slice != null && slice.hasContent()) {
            try {
                this.getEntityService().addPrefs(slice.getContent());
            }
            catch (ValidationException e) {
                System.err.println("Error in adding prefs");
                e.printStackTrace();
            }
        }
        return slice;
    }
}

