/*
 * Decompiled with CFR 0.152.
 */
package umun.entity.util;

import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import umun.core.constants.ValidationException;
import umun.entity.model.EntityPref;

public class EntityPrefValidationUtil {
    public static void validate(EntityPref pref) throws ValidationException {
        switch (pref.getDatatype()) {
            case String: {
                EntityPrefValidationUtil.validateString(pref.getValue());
                break;
            }
            case Long: {
                EntityPrefValidationUtil.validateLong(pref.getValue());
                break;
            }
            case Double: {
                EntityPrefValidationUtil.validateDouble(pref.getValue());
                break;
            }
            case Boolean: {
                EntityPrefValidationUtil.validateBoolean(pref.getValue());
                break;
            }
            case Select: {
                EntityPrefValidationUtil.validateSelect(pref.getValue(), pref.getOptions());
                break;
            }
            case MultiSelect: {
                EntityPrefValidationUtil.validateMultiSelect(pref.getValue(), pref.getOptions());
                break;
            }
            case Long_Positive: {
                EntityPrefValidationUtil.validateLongPositive(pref.getValue());
                break;
            }
            case Long_Negative: {
                EntityPrefValidationUtil.validateLongNegative(pref.getValue());
                break;
            }
            case Double_Positive: {
                EntityPrefValidationUtil.validateDoublePositive(pref.getValue());
                break;
            }
            case Double_Negative: {
                EntityPrefValidationUtil.validateDoubleNegative(pref.getValue());
                break;
            }
            case MultiInput_String: {
                EntityPrefValidationUtil.validateMultiInputString(pref.getValue(), pref.getOptions());
                break;
            }
            case MultiInput_Long: {
                EntityPrefValidationUtil.validateMultiInputLong(pref.getValue(), pref.getOptions());
                break;
            }
            case MultiInput_Double: {
                EntityPrefValidationUtil.validateMultiInputDouble(pref.getValue(), pref.getOptions());
                break;
            }
            case MultiInput_Boolean: {
                EntityPrefValidationUtil.validateMultiInputBoolean(pref.getValue(), pref.getOptions());
                break;
            }
            case HH_MM: {
                EntityPrefValidationUtil.validateHHMM(pref.getValue());
                break;
            }
            case MultiInput_HH_MM: {
                EntityPrefValidationUtil.validateMultiHHMM(pref.getValue(), pref.getOptions());
                break;
            }
            case YYYY_MM_DD: {
                EntityPrefValidationUtil.validateYYYY_MM_DD(pref.getValue());
                break;
            }
        }
    }

    private static void validateYYYY_MM_DD(String value) throws ValidationException {
        if (value == null || !Pattern.compile("^((?:(?:1[6-9]|2[0-9])\\d{2})(-)(?:(?:(?:0[13578]|1[02])(-)31)|((0[1,3-9]|1[0-2])(-)(29|30))))$|^(?:(?:(?:(?:1[6-9]|[2-9]\\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00)))(-)02(-)29)$|^(?:(?:1[6-9]|2[0-9])\\d{2})(-)(?:(?:0[1-9])|(?:1[0-2]))(-)(?:0[1-9]|1\\d|2[0-8])$").matcher(value).matches()) {
            throw new ValidationException("Enter a valid date in format yyyy-MM-dd 2001-12-21", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static void validateMultiHHMM(String value, Map<String, String> options) throws ValidationException {
        EntityPrefValidationUtil.validateMultiInput(value, options, (JSONObject2, key) -> EntityPrefValidationUtil.validateHHMM(JSONObject2.getString(key)), "  a valid time in 24 hour format HH:MM like 09:00, 23:30 ..");
    }

    private static void validateHHMM(String value) throws ValidationException {
        if (value == null || !Pattern.compile("([01]?[0-9]|2[0-3]):[0-5][0-9]").matcher(value).matches()) {
            throw new ValidationException("Enter a valid time in 24 hour format HH:MM like 09:00, 23:30 ..", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static void validateMultiInputBoolean(String value, Map<String, String> options) throws ValidationException {
        EntityPrefValidationUtil.validateMultiInput(value, options, (JSONObject2, key) -> JSONObject2.getBoolean(key), " either 'true' or 'false'");
    }

    private static void validateMultiInputDouble(String value, Map<String, String> options) throws ValidationException {
        EntityPrefValidationUtil.validateMultiInput(value, options, (JSONObject2, key) -> JSONObject2.getDouble(key), " a decimal number like 1.0, 10.50, 100.20 ..");
    }

    private static void validateMultiInputLong(String value, Map<String, String> options) throws ValidationException {
        EntityPrefValidationUtil.validateMultiInput(value, options, (JSONObject2, key) -> JSONObject2.getLong(key), " a whole number like 1, 2, 3...");
    }

    private static void validateMultiInputString(String value, Map<String, String> options) throws ValidationException {
        EntityPrefValidationUtil.validateMultiInput(value, options, (JSONObject2, key) -> JSONObject2.getString(key), " a valid string of characters");
    }

    private static void validateDoubleNegative(String value) throws ValidationException {
        if (EntityPrefValidationUtil.validateDouble(value) > 0.0) {
            throw new ValidationException("Enter a value smaller than 0.", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static void validateDoublePositive(String value) throws ValidationException {
        if (EntityPrefValidationUtil.validateDouble(value) < 0.0) {
            throw new ValidationException("Enter a value greater than 0.", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static void validateLongNegative(String value) throws ValidationException {
        if (EntityPrefValidationUtil.validateLong(value) > 0L) {
            throw new ValidationException("Enter a value smaller than 0.", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static void validateLongPositive(String value) throws ValidationException {
        if (EntityPrefValidationUtil.validateLong(value) < 0L) {
            throw new ValidationException("Enter a value greater than 0.", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static void validateMultiSelect(String value, Map<String, String> options) throws ValidationException {
        throw new ValidationException("No validation found.", HttpStatus.NOT_FOUND);
    }

    private static void validateSelect(String value, Map<String, String> options) throws ValidationException {
        if (!options.containsKey(value)) {
            throw new ValidationException(String.format("Select a value from the provided %d options.", options.size()), HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static boolean validateBoolean(String value) throws ValidationException {
        try {
            EntityPrefValidationUtil.validateEmpty(value);
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Enter a valid value 'true' or 'false'", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static double validateDouble(String value) throws ValidationException {
        try {
            EntityPrefValidationUtil.validateEmpty(value);
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Enter a valid decimal number like 0, 1.1, 2.5 ..", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static long validateLong(String value) throws ValidationException {
        try {
            EntityPrefValidationUtil.validateEmpty(value);
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Enter a valid whole number like ..-2, -1, 0, 1, 2..", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static void validateEmpty(String value) {
        if (value == null || value.equals("")) {
            throw new NumberFormatException();
        }
    }

    private static void validateString(String value) throws ValidationException {
        if (value == null) {
            throw new ValidationException("Value cannot be null or empty", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validateMultiInput(String value, Map<String, String> options, MultiInputValidationInt multiInputValidationInt, String message) throws ValidationException {
        try {
            JSONObject ob = new JSONObject(value);
            for (String k : options.keySet()) {
                if (!ob.has(k)) {
                    throw new ValidationException("Enter value of " + options.get(k) + " key " + k, HttpStatus.NOT_ACCEPTABLE);
                }
                try {
                    multiInputValidationInt.validateInididualOption(ob, k);
                }
                catch (JSONException | ValidationException e) {
                    throw new ValidationException(String.format("Value of '%s' should be %s", options.get(k), message), HttpStatus.NOT_ACCEPTABLE);
                    return;
                }
            }
        }
        catch (JSONException e) {
            throw new ValidationException("Not a valid json. Contact developer.", HttpStatus.NOT_ACCEPTABLE);
        }
    }

    private static interface MultiInputValidationInt {
        public void validateInididualOption(JSONObject var1, String var2) throws JSONException, ValidationException;
    }
}

