/*
 * Decompiled with CFR 0.152.
 */
package in.uncod.android.bypass;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import in.uncod.android.bypass.Document;
import in.uncod.android.bypass.Element;

public class Bypass {
    private static final float[] HEADER_SIZES;

    public CharSequence markdownToSpannable(String markdown) {
        Document document = this.processMarkdown(markdown);
        CharSequence[] spans = new CharSequence[document.getElementCount()];
        for (int i = 0; i < document.getElementCount(); ++i) {
            spans[i] = this.recurseElement(document.getElement(i));
        }
        return TextUtils.concat((CharSequence[])spans);
    }

    private native Document processMarkdown(String var1);

    private CharSequence recurseElement(Element element) {
        CharSequence[] spans = new CharSequence[element.size()];
        for (int i = 0; i < element.size(); ++i) {
            spans[i] = this.recurseElement(element.children[i]);
        }
        CharSequence concat = TextUtils.concat((CharSequence[])spans);
        SpannableStringBuilder builder = new SpannableStringBuilder();
        String text = element.getText();
        if (element.size() == 0 && element.getParent().getType() != Element.Type.BLOCK_CODE) {
            text = text.replace('\n', ' ');
        }
        if (element.getParent() != null && element.getParent().getType() == Element.Type.LIST_ITEM && element.getType() == Element.Type.LIST) {
            builder.append((CharSequence)"\n");
        }
        if (element.getType() == Element.Type.LIST_ITEM) {
            builder.append((CharSequence)"\u2022");
        }
        builder.append((CharSequence)text);
        builder.append(concat);
        if (element.getType() != Element.Type.LIST || element.getParent() == null) {
            if (element.getType() == Element.Type.LIST_ITEM) {
                if (element.size() <= 0 || !element.children[element.size() - 1].isBlockElement()) {
                    builder.append((CharSequence)"\n");
                }
            } else if (element.isBlockElement()) {
                builder.append((CharSequence)"\n\n");
            }
        }
        if (element.getType() == Element.Type.HEADER) {
            String levelStr = element.getAttribute("level");
            int level = Integer.parseInt(levelStr);
            builder.setSpan((Object)new RelativeSizeSpan(HEADER_SIZES[level]), 0, builder.length(), 33);
            builder.setSpan((Object)new StyleSpan(1), 0, builder.length(), 33);
        } else if (element.getType() == Element.Type.LIST_ITEM && element.getParent().getParent() != null) {
            LeadingMarginSpan.Standard span = new LeadingMarginSpan.Standard(20);
            builder.setSpan((Object)span, 0, builder.length(), 33);
        } else if (element.getType() == Element.Type.EMPHASIS) {
            StyleSpan italicSpan = new StyleSpan(2);
            builder.setSpan((Object)italicSpan, 0, builder.length(), 33);
        } else if (element.getType() == Element.Type.DOUBLE_EMPHASIS) {
            StyleSpan boldSpan = new StyleSpan(1);
            builder.setSpan((Object)boldSpan, 0, builder.length(), 33);
        } else if (element.getType() == Element.Type.TRIPLE_EMPHASIS) {
            StyleSpan bolditalicSpan = new StyleSpan(3);
            builder.setSpan((Object)bolditalicSpan, 0, builder.length(), 33);
        } else if (element.getType() == Element.Type.CODE_SPAN) {
            TypefaceSpan monoSpan = new TypefaceSpan("monospace");
            builder.setSpan((Object)monoSpan, 0, builder.length(), 33);
        } else if (element.getType() == Element.Type.LINK) {
            URLSpan urlSpan = new URLSpan(element.getAttribute("link"));
            builder.setSpan((Object)urlSpan, 0, builder.length(), 33);
        } else if (element.getType() == Element.Type.BLOCK_QUOTE) {
            QuoteSpan quoteSpan = new QuoteSpan();
            builder.setSpan((Object)quoteSpan, 0, builder.length(), 33);
            StyleSpan italicSpan = new StyleSpan(2);
            builder.setSpan((Object)italicSpan, 0, builder.length(), 33);
        }
        return builder;
    }

    static {
        System.loadLibrary("bypass");
        HEADER_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    }
}

