/*
 * Decompiled with CFR 0.152.
 */
package in.uncod.andrpod.bypass.bypass_test.test;

import android.test.InstrumentationTestCase;
import android.text.Spannable;
import android.text.SpannedString;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import in.uncod.android.bypass.Bypass;

public class BasicTests
extends InstrumentationTestCase {
    Bypass bypass;

    protected void setUp() throws Exception {
        super.setUp();
        this.bypass = new Bypass();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEmptyString() {
        this.bypass.markdownToSpannable("");
    }

    public void testHeaderString() {
        Spannable spannable = (Spannable)this.bypass.markdownToSpannable("Header!!\n--------");
        StyleSpan[] spans = (StyleSpan[])spannable.getSpans(0, spannable.length(), StyleSpan.class);
        BasicTests.assertEquals((int)1, (int)spans.length);
        RelativeSizeSpan[] sizeSpan = (RelativeSizeSpan[])spannable.getSpans(0, spannable.length(), RelativeSizeSpan.class);
        BasicTests.assertEquals((int)1, (int)sizeSpan.length);
        BasicTests.assertEquals((char)'\n', (char)spannable.charAt(spannable.length() - 1));
    }

    public void testBoldString() {
        Spannable spannable = (Spannable)this.bypass.markdownToSpannable("One **Two** Three");
        StyleSpan[] spans = (StyleSpan[])spannable.getSpans(0, spannable.length(), StyleSpan.class);
        BasicTests.assertEquals((int)1, (int)spans.length);
        BasicTests.assertEquals((int)1, (int)spans[0].getStyle());
        BasicTests.assertEquals((int)4, (int)spannable.getSpanStart((Object)spans[0]));
        BasicTests.assertEquals((int)7, (int)spannable.getSpanEnd((Object)spans[0]));
    }

    public void testLinkString() {
        Spannable spannable = (Spannable)this.bypass.markdownToSpannable("[Link](https://github.com/Uncodin/bypass)");
        URLSpan[] spans = (URLSpan[])spannable.getSpans(0, spannable.length(), URLSpan.class);
        BasicTests.assertEquals((int)1, (int)spans.length);
        BasicTests.assertTrue((boolean)spannable.toString().contains("Link"));
        BasicTests.assertEquals((String)"https://github.com/Uncodin/bypass", (String)spans[0].getURL());
    }

    public void testHeaderOrder() {
        SpannedString spannable = (SpannedString)this.bypass.markdownToSpannable("Header!!\n--------\nText goes here or something\n*One* **Two** ***Three***\n");
        RelativeSizeSpan[] sizeSpan = (RelativeSizeSpan[])spannable.getSpans(0, spannable.length(), RelativeSizeSpan.class);
        BasicTests.assertEquals((int)1, (int)sizeSpan.length);
        BasicTests.assertEquals((int)0, (int)spannable.getSpanStart((Object)sizeSpan[0]));
    }

    public void testCodeSpan() {
        Spannable spannable = (Spannable)this.bypass.markdownToSpannable("`code`");
        TypefaceSpan[] spans = (TypefaceSpan[])spannable.getSpans(0, spannable.length(), TypefaceSpan.class);
        BasicTests.assertEquals((int)1, (int)spans.length);
        BasicTests.assertEquals((int)0, (int)spannable.getSpanStart((Object)spans[0]));
    }
}

