/*
 * Decompiled with CFR 0.152.
 */
package in.uncod.android.bypass;

import java.util.HashMap;
import java.util.Map;

public class Element {
    String text;
    Map<String, String> attributes = new HashMap<String, String>();
    Element[] children;
    Type type;
    Element parent;
    int nestLevel = 0;

    public Element(String text, int type) {
        this.text = text;
        this.type = Type.fromInteger(type);
    }

    public void setParent(Element element) {
        this.parent = element;
    }

    public void setChildren(Element[] children) {
        this.children = children;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Element getParent() {
        return this.parent;
    }

    public String getText() {
        return this.text;
    }

    public int size() {
        if (this.children != null) {
            return this.children.length;
        }
        return 0;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isBlockElement() {
        return (this.type.value & 0x100) == 0;
    }

    public boolean isSpanElement() {
        return (this.type.value & 0x100) == 256;
    }

    public static enum Type {
        BLOCK_CODE(0),
        BLOCK_QUOTE(1),
        BLOCK_HTML(2),
        HEADER(3),
        HRULE(4),
        LIST(5),
        LIST_ITEM(6),
        PARAGRAPH(7),
        TABLE(8),
        TABLE_CELL(9),
        TABLE_ROW(10),
        AUTOLINK(267),
        CODE_SPAN(268),
        DOUBLE_EMPHASIS(269),
        EMPHASIS(270),
        IMAGE(271),
        LINEBREAK(272),
        LINK(273),
        RAW_HTML_TAG(274),
        TRIPLE_EMPHASIS(275),
        TEXT(276);

        private final int value;
        private static final Type[] TypeValues;

        private Type(int value) {
            this.value = value;
        }

        public static Type fromInteger(int x) {
            for (Type type : TypeValues) {
                if (type.value != x) continue;
                return type;
            }
            return null;
        }

        static {
            TypeValues = Type.values();
        }
    }
}

