/*
 * Decompiled with CFR 0.152.
 */
package in.virit;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import in.virit.HumidityGauge;
import in.virit.TemperatureGauge;

public class EnvironmentMonitor
extends HorizontalLayout {
    private TemperatureGauge temperatureGauge;
    private HumidityGauge humidityGauge;

    public EnvironmentMonitor() {
        this(20.0, 50.0);
    }

    public EnvironmentMonitor(double initialTemperature, double initialHumidity) {
        this.setSizeFull();
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.AROUND);
        VerticalLayout tempSection = this.createTemperatureSection(initialTemperature);
        VerticalLayout humiditySection = this.createHumiditySection(initialHumidity);
        this.add(new Component[]{tempSection, humiditySection});
    }

    private VerticalLayout createTemperatureSection(double initialTemperature) {
        VerticalLayout tempSection = new VerticalLayout();
        tempSection.setAlignItems(FlexComponent.Alignment.CENTER);
        tempSection.setSpacing(false);
        H3 tempTitle = new H3("\ud83c\udf21\ufe0f Temperature");
        tempTitle.getStyle().setMargin("0 0 1rem 0");
        this.temperatureGauge = new TemperatureGauge(initialTemperature);
        tempSection.add(new Component[]{tempTitle, this.temperatureGauge});
        return tempSection;
    }

    private VerticalLayout createHumiditySection(double initialHumidity) {
        VerticalLayout humiditySection = new VerticalLayout();
        humiditySection.setAlignItems(FlexComponent.Alignment.CENTER);
        humiditySection.setSpacing(false);
        H3 humidityTitle = new H3("\ud83d\udca7 Humidity");
        humidityTitle.getStyle().setMargin("0 0 1rem 0");
        this.humidityGauge = new HumidityGauge(initialHumidity);
        humiditySection.add(new Component[]{humidityTitle, this.humidityGauge});
        return humiditySection;
    }

    public void setTemperature(double temperature) {
        this.temperatureGauge.setTemperature(temperature);
    }

    public void setHumidity(double humidity) {
        this.humidityGauge.setHumidity(humidity);
    }

    public void setEnvironmentValues(double temperature, double humidity) {
        this.setTemperature(temperature);
        this.setHumidity(humidity);
    }

    public TemperatureGauge getTemperatureGauge() {
        return this.temperatureGauge;
    }

    public HumidityGauge getHumidityGauge() {
        return this.humidityGauge;
    }

    public void setTemperatureUnit(TemperatureGauge.TemperatureUnit unit) {
        this.temperatureGauge.setTemperatureUnit(unit);
    }

    public void setTemperatureRange(double minTemp, double maxTemp) {
        this.temperatureGauge.setTemperatureRange(minTemp, maxTemp);
    }
}

