/*
 * Decompiled with CFR 0.152.
 */
package in.virit;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.react.ReactAdapterComponent;
import in.virit.color.Color;

@NpmPackage(value="react-gauge-component", version="1.2.64")
@JsModule(value="./viritin/react-gauge.tsx")
@Tag(value="react-gauge")
public class Gauge
extends ReactAdapterComponent {
    public Gauge() {
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.setValue(0.0);
        this.setMinValue(0.0);
        this.setMaxValue(100.0);
        this.getStyle().setBackground("rgb(40, 44, 52)");
        this.getStyle().setBorderRadius("2em");
    }

    public Gauge(double value) {
        this.initializeDefaults();
        this.setValue(value);
    }

    public void setValue(double value) {
        this.setState("value", value);
    }

    public void setMinValue(double minValue) {
        this.setState("minValue", minValue);
    }

    public void setMaxValue(double maxValue) {
        this.setState("maxValue", maxValue);
    }

    public void setType(GaugeType type) {
        this.setState("type", type.getValue());
    }

    public void setArcWidth(int width) {
        GaugeArc currentArc = this.getCurrentArc();
        currentArc.setWidth(width);
        this.setState("arc", currentArc);
    }

    public void setArc(GaugeArc arc) {
        this.setState("arc", arc != null ? arc : new GaugeArc());
    }

    public void setPointer(GaugePointer pointer) {
        this.setState("pointer", pointer != null ? pointer : new GaugePointer());
    }

    public void setLabels(GaugeLabels labels) {
        this.setState("labels", labels != null ? labels : new GaugeLabels());
    }

    private GaugeArc getCurrentArc() {
        return new GaugeArc();
    }

    public static enum GaugeType {
        SEMICIRCLE("semicircle"),
        RADIAL("radial");

        private final String value;

        private GaugeType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class GaugeArc {
        private Integer width;
        private Double padding;
        private String[] colorArray;
        private GaugeSubArc[] subArcs;

        public GaugeArc setWidth(int width) {
            this.width = width;
            return this;
        }

        public GaugeArc setPadding(double padding) {
            this.padding = padding;
            return this;
        }

        public GaugeArc setColorArray(Color ... colors) {
            this.colorArray = new String[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                this.colorArray[i] = colors[i] != null ? colors[i].toString() : "#000000";
            }
            return this;
        }

        public GaugeArc setSubArcs(GaugeSubArc ... subArcs) {
            this.subArcs = subArcs;
            return this;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Double getPadding() {
            return this.padding;
        }

        public String[] getColorArray() {
            return this.colorArray;
        }

        public GaugeSubArc[] getSubArcs() {
            return this.subArcs;
        }
    }

    public static class GaugePointer {
        private String type;
        private String color;
        private Double length;
        private Integer width;
        private Boolean elastic;
        private Integer animationDelay;

        public GaugePointer setType(PointerType type) {
            this.type = type.getValue();
            return this;
        }

        public GaugePointer setColor(Color color) {
            this.color = color != null ? color.toString() : null;
            return this;
        }

        public GaugePointer setLength(double length) {
            this.length = length;
            return this;
        }

        public GaugePointer setWidth(int width) {
            this.width = width;
            return this;
        }

        public GaugePointer setElastic(boolean elastic) {
            this.elastic = elastic;
            return this;
        }

        public GaugePointer setAnimationDelay(int delay) {
            this.animationDelay = delay;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public String getColor() {
            return this.color;
        }

        public Double getLength() {
            return this.length;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Boolean getElastic() {
            return this.elastic;
        }

        public Integer getAnimationDelay() {
            return this.animationDelay;
        }
    }

    public static class GaugeLabels {
        private GaugeValueLabel valueLabel;
        private GaugeTickLabels tickLabels;

        public GaugeLabels setValueLabel(GaugeValueLabel valueLabel) {
            this.valueLabel = valueLabel;
            return this;
        }

        public GaugeLabels setTickLabels(GaugeTickLabels tickLabels) {
            this.tickLabels = tickLabels;
            return this;
        }

        public GaugeValueLabel getValueLabel() {
            return this.valueLabel;
        }

        public GaugeTickLabels getTickLabels() {
            return this.tickLabels;
        }
    }

    public static enum TickLabelType {
        INNER("inner"),
        OUTER("outer");

        private final String value;

        private TickLabelType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PointerType {
        ARROW("arrow"),
        BLOB("blob");

        private final String value;

        private PointerType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class GaugeLabelStyle {
        private String fontSize;
        private String fill;
        private String textShadow;

        public GaugeLabelStyle setFontSize(String fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public GaugeLabelStyle setFill(String fill) {
            this.fill = fill;
            return this;
        }

        public GaugeLabelStyle setTextShadow(String textShadow) {
            this.textShadow = textShadow;
            return this;
        }

        public String getFontSize() {
            return this.fontSize;
        }

        public String getFill() {
            return this.fill;
        }

        public String getTextShadow() {
            return this.textShadow;
        }
    }

    public static class GaugeTickLabels {
        private String type;
        private Double[] ticks;
        private String formatTextValue;

        public GaugeTickLabels setType(TickLabelType type) {
            this.type = type.getValue();
            return this;
        }

        public GaugeTickLabels setTicks(Double ... ticks) {
            this.ticks = ticks;
            return this;
        }

        public GaugeTickLabels setFormatTextValue(String format) {
            this.formatTextValue = format;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Double[] getTicks() {
            return this.ticks;
        }

        public String getFormatTextValue() {
            return this.formatTextValue;
        }
    }

    public static class GaugeValueLabel {
        private Boolean hide;
        private String formatTextValue;
        private GaugeLabelStyle style;

        public GaugeValueLabel setHide(boolean hide) {
            this.hide = hide;
            return this;
        }

        public GaugeValueLabel setFormatTextValue(String format) {
            this.formatTextValue = format;
            return this;
        }

        public GaugeValueLabel setStyle(GaugeLabelStyle style) {
            this.style = style;
            return this;
        }

        public Boolean getHide() {
            return this.hide;
        }

        public String getFormatTextValue() {
            return this.formatTextValue;
        }

        public GaugeLabelStyle getStyle() {
            return this.style;
        }
    }

    public static class GaugeSubArc {
        private Double limit;
        private String color;
        private Boolean showTick;
        private String tooltip;

        public GaugeSubArc(double limit, Color color) {
            this.limit = limit;
            this.color = color != null ? color.toString() : "#000000";
        }

        public GaugeSubArc setShowTick(boolean showTick) {
            this.showTick = showTick;
            return this;
        }

        public GaugeSubArc setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Double getLimit() {
            return this.limit;
        }

        public String getColor() {
            return this.color;
        }

        public Boolean getShowTick() {
            return this.showTick;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }
}

