/*
 * Decompiled with CFR 0.152.
 */
package in.virit;

import in.virit.Gauge;
import in.virit.color.Color;
import in.virit.color.NamedColor;

public class HumidityGauge
extends Gauge {
    public HumidityGauge() {
        this(50.0);
    }

    public HumidityGauge(double humidity) {
        this.setupHumidityDefaults();
        this.setHumidity(humidity);
    }

    private void setupHumidityDefaults() {
        this.setState("gaugeType", "humidity");
        this.setArc(new Gauge.GaugeArc().setSubArcs(new Gauge.GaugeSubArc(30.0, (Color)NamedColor.RED).setTooltip("Dry"), new Gauge.GaugeSubArc(50.0, (Color)NamedColor.YELLOW).setTooltip("Comfortable"), new Gauge.GaugeSubArc(70.0, (Color)NamedColor.GREEN).setTooltip("Optimal"), new Gauge.GaugeSubArc(100.0, (Color)NamedColor.LIGHTBLUE).setTooltip("Humid")));
        this.setPointer(new Gauge.GaugePointer().setType(Gauge.PointerType.BLOB).setElastic(true).setColor((Color)NamedColor.BLUE));
    }

    public void setHumidity(double humidity) {
        this.setValue(humidity);
    }

    public HumidityLevel getHumidityLevel(double humidity) {
        if (humidity < 20.0) {
            return HumidityLevel.VERY_DRY;
        }
        if (humidity < 30.0) {
            return HumidityLevel.DRY;
        }
        if (humidity < 40.0) {
            return HumidityLevel.LOW;
        }
        if (humidity < 50.0) {
            return HumidityLevel.COMFORTABLE;
        }
        if (humidity < 65.0) {
            return HumidityLevel.OPTIMAL;
        }
        if (humidity < 75.0) {
            return HumidityLevel.GOOD;
        }
        if (humidity < 85.0) {
            return HumidityLevel.HIGH;
        }
        return HumidityLevel.VERY_HUMID;
    }

    public String getHumidityRecommendation(double humidity) {
        HumidityLevel level = this.getHumidityLevel(humidity);
        return switch (level.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> "Consider using a humidifier to add moisture to the air";
            case 2 -> "Indoor plants can help increase humidity naturally";
            case 3, 4, 5 -> "Perfect humidity range for comfort and health";
            case 6 -> "Consider improving ventilation to reduce moisture";
            case 7 -> "Use a dehumidifier to prevent mold growth and improve air quality";
        };
    }

    public static enum HumidityLevel {
        VERY_DRY("Very Dry", "\ud83c\udfdc\ufe0f"),
        DRY("Dry", "\ud83d\ude24"),
        LOW("Low Humidity", "\ud83d\ude10"),
        COMFORTABLE("Comfortable", "\ud83d\ude0a"),
        OPTIMAL("Optimal", "\ud83c\udf1f"),
        GOOD("Good", "\ud83d\udc4d"),
        HIGH("High Humidity", "\ud83d\ude13"),
        VERY_HUMID("Very Humid", "\ud83d\udca7");

        private final String description;
        private final String emoji;

        private HumidityLevel(String description, String emoji) {
            this.description = description;
            this.emoji = emoji;
        }

        public String getDescription() {
            return this.description;
        }

        public String getEmoji() {
            return this.emoji;
        }

        public String getDisplayText() {
            return this.description + " " + this.emoji;
        }
    }
}

