/*
 * Decompiled with CFR 0.152.
 */
package in.virit;

import in.virit.Gauge;
import in.virit.color.Color;
import in.virit.color.NamedColor;

public class TemperatureGauge
extends Gauge {
    public TemperatureGauge() {
        this(0.0);
    }

    public TemperatureGauge(double temperature) {
        this.setupTemperatureDefaults();
        this.setTemperature(temperature);
    }

    private void setupTemperatureDefaults() {
        this.setMinValue(-40.0);
        this.setMaxValue(50.0);
        this.setState("gaugeType", "temperature");
        this.setArc(new Gauge.GaugeArc().setSubArcs(new Gauge.GaugeSubArc(-20.0, (Color)NamedColor.GREEN).setTooltip("Cold"), new Gauge.GaugeSubArc(0.0, (Color)NamedColor.YELLOW).setTooltip("Cool"), new Gauge.GaugeSubArc(20.0, (Color)NamedColor.ORANGE).setTooltip("Warm"), new Gauge.GaugeSubArc(50.0, (Color)NamedColor.RED).setTooltip("Hot")));
    }

    public void setTemperature(double temperature) {
        this.setValue(temperature);
    }

    public void setTemperatureRange(double minTemp, double maxTemp) {
        this.setMinValue(minTemp);
        this.setMaxValue(maxTemp);
    }

    public void setTemperatureUnit(TemperatureUnit unit) {
        String unitSymbol = unit == TemperatureUnit.FAHRENHEIT ? "fahrenheit" : "celsius";
        this.setState("temperatureUnit", unitSymbol);
    }

    public static enum TemperatureUnit {
        CELSIUS,
        FAHRENHEIT;

    }
}

