/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.vaadin.firitin.components.button.DefaultButton;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.orderedlayout.VHorizontalLayout;
import org.vaadin.firitin.components.orderedlayout.VVerticalLayout;
import org.vaadin.firitin.components.textfield.VIntegerField;

public class MultiDateTimeField
extends Composite<VerticalLayout>
implements HasValue<HasValue.ValueChangeEvent<List<LocalDateTime>>, List<LocalDateTime>>,
HasSize {
    private List<LocalDateTime> value;
    CustomDateTimePicker next = new CustomDateTimePicker();
    Select<RepeatMode> repeatMode = new Select();
    VIntegerField repeatTimes = new VIntegerField();
    Span repeatTimesText = new Span("times");
    VerticalLayout existingValues = (VerticalLayout)((VVerticalLayout)new VVerticalLayout().withMargin(false)).withPadding(false).withSpacing(false);

    public MultiDateTimeField() {
        this.value = new ArrayList<LocalDateTime>();
        this.next.setLabel("Add new date:");
        VHorizontalLayout newRowForm = new VHorizontalLayout(new Component[]{this.next}).withDefaultVerticalComponentAlignment(FlexComponent.Alignment.BASELINE);
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).add(new Component[]{this.existingValues, newRowForm});
        this.next.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.addNewEntry());
        this.repeatMode.setItems((Object[])RepeatMode.values());
        this.repeatMode.setValue((Object)RepeatMode.weekly);
        this.repeatTimes.setMin(1);
        this.repeatTimes.setMax(52);
        this.repeatTimes.setValue(1);
        this.repeatTimes.setWidth("3em");
    }

    private void addNewEntry() {
        LocalDateTime newValue = (LocalDateTime)this.next.getValue();
        if (newValue == null) {
            return;
        }
        this.value.add(newValue);
        this.addRow(newValue);
        this.next.clear();
        this.fireValueChange();
    }

    private void addRow(LocalDateTime newValue) {
        VHorizontalLayout row = new VHorizontalLayout();
        CustomDateTimePicker dateTimePicker = new CustomDateTimePicker();
        dateTimePicker.setValue(newValue);
        dateTimePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            LocalDateTime oldValue = (LocalDateTime)event.getOldValue();
            this.value.set(this.value.indexOf(oldValue), (LocalDateTime)event.getValue());
            this.fireValueChange();
        });
        VButton deleteButton = new VButton(VaadinIcon.TRASH.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> {
            this.value.remove(dateTimePicker.getValue());
            this.existingValues.remove(new Component[]{row});
            this.fireValueChange();
        });
        VButton r = (VButton)new VButton(VaadinIcon.RECYCLE.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> {
            Dialog dialog = new Dialog();
            dialog.setHeaderTitle("Repeat the date...");
            dialog.add(new Component[]{new VHorizontalLayout(new Component[]{this.repeatTimes, this.repeatTimesText, this.repeatMode}).withAlignItems(FlexComponent.Alignment.CENTER)});
            DefaultButton doRepeat = new DefaultButton("Repeat", () -> {
                LocalDateTime cur = (LocalDateTime)dateTimePicker.getValue();
                for (int i = 0; i < (Integer)this.repeatTimes.getValue(); ++i) {
                    cur = cur.plusDays(this.repeatMode.getValue() == RepeatMode.daily ? 1L : 7L);
                    this.value.add(cur);
                    this.addRow(cur);
                }
                dialog.close();
            });
            VButton cancelButton = new VButton("Cancel", () -> dialog.close());
            dialog.getFooter().add(new Component[]{cancelButton, doRepeat});
            dialog.open();
            this.repeatTimes.selectAll();
            this.repeatTimes.focus();
        }).withTooltip("Repeat this time daily/weekly/monthly...");
        row.add(new Component[]{dateTimePicker, r, deleteButton});
        this.existingValues.add(new Component[]{row});
    }

    private void fireValueChange() {
        this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true));
    }

    public void setValue(List<LocalDateTime> value) {
        this.value = value;
        this.existingValues.removeAll();
        value.forEach(this::addRow);
    }

    public List<LocalDateTime> getValue() {
        return this.value;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<List<LocalDateTime>>> listener) {
        ComponentEventListener & Serializable componentListener = (ComponentEventListener & Serializable)event -> {
            AbstractField.ComponentValueChangeEvent valueChangeEvent = (AbstractField.ComponentValueChangeEvent)event;
            listener.valueChanged((HasValue.ValueChangeEvent)valueChangeEvent);
        };
        return this.addListener(AbstractField.ComponentValueChangeEvent.class, componentListener);
    }

    public void setReadOnly(boolean readOnly) {
        ((VerticalLayout)this.getContent()).setEnabled(false);
    }

    public boolean isReadOnly() {
        return ((VerticalLayout)this.getContent()).isEnabled();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    public class CustomDateTimePicker
    extends CustomField<LocalDateTime> {
        private DatePicker dp = new DatePicker();
        private TimePicker tp = new TimePicker();
        private Checkbox wholeDay = new Checkbox("All day");

        protected LocalDateTime generateModelValue() {
            LocalDate localDate = (LocalDate)this.dp.getValue();
            LocalTime localTime = (LocalTime)this.tp.getValue();
            if (localDate == null) {
                return null;
            }
            if (((Boolean)this.wholeDay.getValue()).booleanValue() || localTime == null) {
                localTime = LocalTime.of(0, 0, 0, 0);
            }
            return LocalDateTime.of(localDate, localTime);
        }

        protected void setPresentationValue(LocalDateTime localDateTime) {
            if (localDateTime == null) {
                this.dp.setValue(null);
                this.tp.setValue(null);
            } else {
                this.dp.setValue(localDateTime.toLocalDate());
                this.tp.setValue(localDateTime.toLocalTime());
            }
            boolean atMidnight = localDateTime == null || localDateTime.getHour() == 0 && localDateTime.getMinute() == 0;
            this.wholeDay.setValue((Object)atMidnight);
        }

        public void clear() {
            this.dp.setValue(null);
        }

        public CustomDateTimePicker() {
            this.dp.setWidth("140px");
            this.tp.setWidth("100px");
            this.wholeDay.setValue((Object)true);
            this.tp.setEnabled(false);
            this.wholeDay.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                this.tp.setEnabled((Boolean)this.wholeDay.getValue() == false);
                if (((Boolean)this.wholeDay.getValue()).booleanValue()) {
                    this.tp.setValue(null);
                } else if (this.tp.getValue() == null) {
                    this.tp.setValue(LocalTime.now().withMinute(0).withSecond(0));
                }
            });
            this.dp.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                if (e.isFromClient()) {
                    this.updateValue();
                }
            });
            this.tp.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                if (e.isFromClient()) {
                    this.updateValue();
                }
            });
            this.add(new Component[]{((VHorizontalLayout)((VHorizontalLayout)new VHorizontalLayout(new Component[]{this.dp, this.tp, this.wholeDay}).withMargin(false)).withPadding(false)).alignAll(FlexComponent.Alignment.CENTER)});
        }

        private void fireValueChange() {
            this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true));
        }
    }

    private static enum RepeatMode {
        daily,
        weekly;

    }
}

