/*
 * Decompiled with CFR 0.152.
 */
package in.virit.vwscdn.client;

import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServletService;
import com.vaadin.shared.Version;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import in.virit.vwscdn.annotations.WidgetSet;
import in.virit.vwscdn.annotations.WidgetSetType;
import in.virit.vwscdn.client.Connection;
import in.virit.vwscdn.client.SessionInitListener;
import in.virit.vwscdn.client.WidgetSetConfiguration;
import in.virit.vwscdn.client.WidgetSetRequest;
import in.virit.vwscdn.client.WidgetSetResponse;

@WidgetSet(value=WidgetSetType.DEFAULT)
public class DefaultWidgetSet
implements WidgetSetConfiguration {
    private WidgetSetRequest wsRequest = new WidgetSetRequest();

    @Override
    public DefaultWidgetSet eager(Class<? extends Component> componentClass) {
        this.wsRequest.eager(componentClass);
        return this;
    }

    @Override
    public DefaultWidgetSet addon(String groupId, String artifactId, String version) {
        this.wsRequest.addon(groupId, artifactId, version);
        return this;
    }

    @Override
    public void init() {
        this.init((String)null);
    }

    @Override
    public void init(String serviceUrl) {
        Connection vwscdn = new Connection(VaadinServletService.getCurrent(), serviceUrl);
        this.useRemoteWidgetset(VaadinServletService.getCurrent(), this.wsRequest, vwscdn);
    }

    public void initWithResponse(WidgetSetResponse ws) {
        VaadinServletService.getCurrent().addSessionInitListener((com.vaadin.server.SessionInitListener)new SessionInitListener(ws));
    }

    @Override
    public void init(UI ui) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private WidgetSetResponse useRemoteWidgetset(VaadinService service, WidgetSetRequest info, Connection connection) {
        if (service == null) {
            throw new IllegalArgumentException("VaadinService cannot be null when initializing remote widgetset.");
        }
        info.setVaadinVersion(Version.getFullVersion());
        WidgetSetResponse ws = connection.queryRemoteWidgetSet(info, false);
        service.addSessionInitListener((com.vaadin.server.SessionInitListener)new SessionInitListener(ws));
        return ws;
    }
}

