/*
 * Decompiled with CFR 0.152.
 */
package in.virit.vwscdn.client;

import com.vaadin.server.VaadinService;
import in.virit.vwscdn.client.WidgetSetRequest;
import in.virit.vwscdn.client.WidgetSetResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.digest.DigestUtils;

public class Connection {
    public static final String COMPILE_SERVICE_URL = "http://cdn.virit.in";
    public static final String COMPILE_SERVICE_URL_LOCAL = "http://localhost:8080/vwscdn";
    public static final String PARAM_VWSCDN_LOCAL = "vwscdn.local";
    public static final String QUERY_PARAM_ASYNC_COMPILE = "compile.async";
    private Client client;
    private WebTarget target;
    private String serviceName;
    private String serviceVersion;
    private String buildTime;
    private final WebTarget downloadTarget;

    public static String getDefaultServiceUrl() {
        return System.getProperty(PARAM_VWSCDN_LOCAL) != null ? COMPILE_SERVICE_URL_LOCAL : COMPILE_SERVICE_URL;
    }

    public Connection() {
        this(null, Connection.getDefaultServiceUrl());
    }

    public Connection(VaadinService service) {
        this(service, Connection.getDefaultServiceUrl());
    }

    public Connection(VaadinService service, String vwscdnUrl) {
        vwscdnUrl = vwscdnUrl == null ? Connection.getDefaultServiceUrl() : vwscdnUrl;
        this.client = ClientBuilder.newClient();
        vwscdnUrl = vwscdnUrl.endsWith("/") ? vwscdnUrl : vwscdnUrl + "/";
        this.target = this.client.target(vwscdnUrl + "api/compiler/compile");
        this.downloadTarget = this.client.target(vwscdnUrl + "api/compiler/download");
        try {
            Properties props = new Properties();
            props.load(Connection.class.getResourceAsStream("/service.properties"));
            this.serviceName = props.getProperty("service.name");
            this.serviceVersion = props.getProperty("service.version");
            this.buildTime = props.getProperty("build.time");
        }
        catch (Exception ex) {
            Logger.getLogger(Connection.class.getName()).log(Level.SEVERE, "Failed to load /service.properties", ex);
        }
    }

    public WidgetSetResponse queryRemoteWidgetSet(WidgetSetRequest request, boolean asynchronous) {
        try {
            return (WidgetSetResponse)this.target.queryParam(QUERY_PARAM_ASYNC_COMPILE, new Object[]{asynchronous}).request(new String[]{"application/json"}).header("User-Agent", (Object)this.getUA()).post(Entity.json((Object)request), WidgetSetResponse.class);
        }
        catch (Exception ex) {
            Logger.getLogger(Connection.class.getName()).log(Level.SEVERE, "Failed to connect service " + this.target.getUri() + "", ex);
            return null;
        }
    }

    private String getUA() {
        return this.serviceName + "-" + this.serviceVersion + " (" + System.getProperty("os.name") + "/" + System.getProperty("os.arch") + "/" + System.getProperty("os.version") + "; " + System.getProperty("java.runtime.name") + "/" + System.getProperty("java.version") + "; " + DigestUtils.md5Hex((String)System.getProperty("user.name")) + ")";
    }

    public String downloadRemoteWidgetSet(WidgetSetRequest wsReq, File targetDirectory) throws FileNotFoundException, IOException {
        Response response = this.downloadTarget.request(new String[]{"application/x-zip"}).header("User-Agent", (Object)this.getUA()).post(Entity.json((Object)wsReq));
        String wsName = response.getHeaderString("wsId");
        System.out.println("Name header " + wsName);
        System.out.println("target " + targetDirectory);
        targetDirectory = new File(targetDirectory, wsName);
        InputStream inputstream = (InputStream)response.readEntity(InputStream.class);
        ZipInputStream zipInputStream = new ZipInputStream(inputstream);
        ZipEntry ze = null;
        while ((ze = zipInputStream.getNextEntry()) != null) {
            File outfile = new File(targetDirectory, ze.getName());
            outfile.getParentFile().mkdirs();
            outfile.createNewFile();
            FileOutputStream fout = new FileOutputStream(outfile);
            int c = zipInputStream.read();
            while (c != -1) {
                fout.write(c);
                c = zipInputStream.read();
            }
            zipInputStream.closeEntry();
            fout.close();
        }
        zipInputStream.close();
        return wsName;
    }
}

