/*
 * Decompiled with CFR 0.152.
 */
package in.virit.vwscdn.client;

import com.vaadin.ui.Component;
import in.virit.vwscdn.client.AddonInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class WidgetSetRequest {
    public static final String COMPILE_STYLE_OBFUSCATED = "OBF";
    public static final String COMPILE_STYLE_PRETTY = "PRETTY";
    public static final String COMPILE_STYLE_DETAILED = "DETAILED";
    String vaadinVersion;
    List<String> eager;
    List<AddonInfo> addons;
    String compileStyle = "OBF";

    public String getVaadinVersion() {
        return this.vaadinVersion;
    }

    public void setVaadinVersion(String vaadinVersion) {
        this.vaadinVersion = vaadinVersion;
    }

    public List<String> getEager() {
        return this.eager;
    }

    private void setEager(List<String> eager) {
        this.eager = eager;
    }

    public List<AddonInfo> getAddons() {
        return this.addons;
    }

    private void setAddons(List<AddonInfo> addons) {
        this.addons = addons;
    }

    public String getCompileStyle() {
        return this.compileStyle;
    }

    public void setCompileStyle(String compileStyle) {
        this.compileStyle = compileStyle;
    }

    public static WidgetSetRequest create(String style, String vaadinVersion, AddonInfo ... addonInfos) {
        WidgetSetRequest info = new WidgetSetRequest();
        info.setVaadinVersion(vaadinVersion);
        info.setCompileStyle(style);
        info.setAddons(Arrays.asList(addonInfos));
        return info;
    }

    public static WidgetSetRequest create(String vaadinVersion, AddonInfo ... addonInfos) {
        return WidgetSetRequest.create(COMPILE_STYLE_OBFUSCATED, vaadinVersion, addonInfos);
    }

    public WidgetSetRequest eager(Class<? extends Component> componentClass) {
        return this.eager(componentClass.getCanonicalName());
    }

    public WidgetSetRequest eager(String componentFqn) {
        if (this.eager == null) {
            this.eager = new ArrayList<String>();
        }
        this.eager.add(componentFqn);
        return this;
    }

    public WidgetSetRequest addon(AddonInfo addonInfo) {
        if (this.addons == null) {
            this.addons = new ArrayList<AddonInfo>();
        }
        this.addons.add(addonInfo);
        return this;
    }

    public WidgetSetRequest addon(String groupId, String artifactId, String version) {
        return this.addon(new AddonInfo(groupId, artifactId, version));
    }

    public WidgetSetRequest vaadin(String vaadinVersion) {
        this.setVaadinVersion(vaadinVersion);
        return this;
    }

    public WidgetSetRequest style(String compileStyle) {
        this.setCompileStyle(compileStyle);
        return this;
    }

    public String toString() {
        return "WidgetSetRequest{style=" + this.compileStyle + ", vaadinVersion=" + this.vaadinVersion + ", eager=" + this.eager + ", addons=" + this.addons + '}';
    }

    public String toWidgetsetString() {
        TreeSet<String> eagerNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.eager != null) {
            eagerNames.addAll(this.eager);
        }
        TreeSet<String> addonNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.addons != null) {
            for (AddonInfo ci : this.addons) {
                addonNames.add(ci.toFullMavenId());
            }
        }
        return "{style=" + this.compileStyle + ", vaadinVersion=" + this.vaadinVersion + ", eager=" + eagerNames + ", addons=" + addonNames + '}';
    }
}

