/*
 * Decompiled with CFR 0.152.
 */
package in.virit.vwscdn;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.protocol.file.FileURLConnection;

public class ClassPathExplorer {
    private static final String VAADIN_ADDON_VERSION_ATTRIBUTE = "Vaadin-Package-Version";
    private static final FileFilter DIRECTORIES_ONLY = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.exists() && f.isDirectory();
        }
    };
    private static final boolean debug = true;

    private ClassPathExplorer() {
    }

    public static Map<String, URL> getAvailableWidgetSets(Map<String, URL> classpathLocations) {
        return ClassPathExplorer.getAvailableWidgetSetsAndStylesheets(classpathLocations).getWidgetsets();
    }

    public static LocationInfo getAvailableWidgetSetsAndStylesheets(Map<String, URL> classpathLocations) {
        long start = System.currentTimeMillis();
        HashMap<String, URL> widgetsets = new HashMap<String, URL>();
        HashMap<String, URL> themes = new HashMap<String, URL>();
        Set<String> keySet = classpathLocations.keySet();
        for (String location : keySet) {
            ClassPathExplorer.searchForWidgetSetsAndAddonStyles(location, classpathLocations, widgetsets, themes);
        }
        long end = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append("Widgetsets found from classpath:\n");
        for (String ws : widgetsets.keySet()) {
            sb.append("\t");
            sb.append(ws);
            sb.append(" in ");
            sb.append(widgetsets.get(ws));
            sb.append("\n");
        }
        ClassPathExplorer.log(sb.toString());
        ClassPathExplorer.log("Search took " + (end - start) + "ms");
        return new LocationInfo(widgetsets, themes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void searchForWidgetSetsAndAddonStyles(String locationString, Map<String, URL> inClasspathLocations, Map<String, URL> widgetsets, Map<String, URL> addonStyles) {
        URL location = inClasspathLocations.get(locationString);
        File directory = new File(location.getFile());
        if (directory.exists() && directory.isDirectory() && !directory.isHidden()) {
            String[] files = directory.list();
            if (files == null) return;
            for (String file : files) {
                if (!file.endsWith(".gwt.xml")) continue;
                String classname = file.substring(0, file.length() - 8);
                String packageName = locationString.substring(locationString.lastIndexOf("/") + 1);
                classname = packageName + "." + classname;
                if (!ClassPathExplorer.isWidgetset(classname) || widgetsets.containsKey(classname)) continue;
                String packagePath = packageName.replaceAll("\\.", "/");
                String basePath = location.getFile().replaceAll("/" + packagePath + "$", "");
                try {
                    URL url = new URL(location.getProtocol(), location.getHost(), location.getPort(), basePath);
                    widgetsets.put(classname, url);
                }
                catch (MalformedURLException e) {
                    ClassPathExplorer.error("Error locating the widgetset " + classname, e);
                }
            }
            return;
        } else {
            try {
                int i;
                JarFile jarFile;
                URLConnection openConnection = location.openConnection();
                if (!(openConnection instanceof JarURLConnection) && !(openConnection instanceof FileURLConnection)) return;
                if (openConnection instanceof JarURLConnection) {
                    JarURLConnection conn = (JarURLConnection)openConnection;
                    jarFile = conn.getJarFile();
                } else {
                    jarFile = new JarFile(location.getFile());
                }
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return;
                }
                String value = manifest.getMainAttributes().getValue("Vaadin-Widgetsets");
                if (value != null) {
                    String[] widgetsetNames = value.split(",");
                    for (i = 0; i < widgetsetNames.length; ++i) {
                        String widgetsetname = widgetsetNames[i].trim();
                        if (widgetsetname.equals("")) continue;
                        widgetsets.put(widgetsetname, location);
                    }
                }
                if ((value = manifest.getMainAttributes().getValue("Vaadin-Stylesheets")) == null) return;
                String[] stylesheets = value.split(",");
                for (i = 0; i < stylesheets.length; ++i) {
                    String stylesheet = stylesheets[i].trim();
                    if (stylesheet.equals("")) continue;
                    addonStyles.put(stylesheet, location);
                }
                return;
            }
            catch (IOException e) {
                ClassPathExplorer.log("Error parsing jar file: " + location);
            }
        }
    }

    private static List<String> getRawClasspathEntries() {
        String[] split;
        ArrayList<String> locations = new ArrayList<String>();
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        if (classpath.startsWith("\"")) {
            classpath = classpath.substring(1);
        }
        if (classpath.endsWith("\"")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        ClassPathExplorer.debug("Classpath: " + classpath);
        for (String classpathEntry : split = classpath.split(pathSep)) {
            if (!ClassPathExplorer.acceptClassPathEntry(classpathEntry)) continue;
            locations.add(classpathEntry);
        }
        return locations;
    }

    private static Map<String, URL> getClasspathLocations(List<String> classpathEntries) {
        long start = System.currentTimeMillis();
        LinkedHashMap<String, URL> locations = new LinkedHashMap<String, URL>();
        for (String classpathEntry : classpathEntries) {
            File file = new File(classpathEntry);
            ClassPathExplorer.include(null, file, locations);
            System.err.println("INCLUDE: " + classpathEntry);
        }
        long end = System.currentTimeMillis();
        ClassPathExplorer.debug("getClassPathLocations took " + (end - start) + "ms");
        return locations;
    }

    private static boolean acceptClassPathEntry(String classpathEntry) {
        if (!classpathEntry.endsWith(".jar")) {
            return true;
        }
        if (classpathEntry.contains("vaadin-") || classpathEntry.contains(".vaadin.")) {
            return true;
        }
        try {
            URL url = new URL("file:" + new File(classpathEntry).getCanonicalPath());
            url = new URL("jar:" + url.toExternalForm() + "!/");
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            ClassPathExplorer.debug(url.toString());
            JarFile jarFile = conn.getJarFile();
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                Attributes mainAttributes = manifest.getMainAttributes();
                if (mainAttributes.getValue("Vaadin-Widgetsets") != null) {
                    return true;
                }
                if (mainAttributes.getValue("Vaadin-Stylesheets") != null) {
                    return true;
                }
            }
        }
        catch (MalformedURLException e) {
            ClassPathExplorer.error("Failed to inspect JAR file", e);
        }
        catch (IOException e) {
            ClassPathExplorer.error("Failed to inspect JAR file", e);
        }
        return false;
    }

    private static void include(String name, File file, Map<String, URL> locations) {
        File[] dirs;
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            ClassPathExplorer.includeJar(file, locations);
            return;
        }
        if (file.isHidden() || file.getPath().contains(File.separator + ".")) {
            return;
        }
        name = name == null ? "" : name + ".";
        for (File dir : dirs = file.listFiles(DIRECTORIES_ONLY)) {
            try {
                if (!dir.isHidden() && !dir.getPath().contains(File.separator + ".")) {
                    String key = dir.getCanonicalPath() + "/" + name + dir.getName();
                    locations.put(key, new URL("file://" + dir.getCanonicalPath()));
                }
            }
            catch (Exception ioe) {
                return;
            }
            ClassPathExplorer.include(name + dir.getName(), dir, locations);
        }
    }

    private static void includeJar(File file, Map<String, URL> locations) {
        try {
            URL url = new URL("file:" + file.getCanonicalPath());
            url = new URL("jar:" + url.toExternalForm() + "!/");
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            JarFile jarFile = conn.getJarFile();
            if (jarFile != null) {
                locations.put(url.toString(), url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static URL getDefaultSourceDirectory(List<String> classpathEntries) {
        ClassPathExplorer.debug("classpathLocations values:");
        for (String location : classpathEntries) {
            ClassPathExplorer.debug(location);
        }
        for (String entry : classpathEntries) {
            File directory = new File(entry);
            if (!directory.exists() || directory.isHidden() || !directory.isDirectory()) continue;
            try {
                return new URL("file://" + directory.getCanonicalPath());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private static void error(String message, Exception e) {
        System.err.println(message);
        e.printStackTrace();
    }

    private static void debug(String message) {
        System.out.println(message);
    }

    static boolean isWidgetset(String gwtModuleName) {
        return gwtModuleName.toLowerCase().contains("widgetset");
    }

    public static class LocationInfo {
        private final Map<String, URL> widgetsets;
        private final Map<String, URL> addonStyles;

        public LocationInfo(Map<String, URL> widgetsets, Map<String, URL> themes) {
            this.widgetsets = widgetsets;
            this.addonStyles = themes;
        }

        public Map<String, URL> getWidgetsets() {
            return this.widgetsets;
        }

        public Map<String, URL> getAddonStyles() {
            return this.addonStyles;
        }
    }
}

