/*
 * Decompiled with CFR 0.152.
 */
package in.virit.vwscdn;

import in.virit.vwscdn.ClassPathExplorer;
import in.virit.vwscdn.client.AddonInfo;
import in.virit.vwscdn.client.Connection;
import in.virit.vwscdn.client.PublishState;
import in.virit.vwscdn.client.WidgetSetRequest;
import in.virit.vwscdn.client.WidgetSetResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresOnline=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class VWSCDNMojo
extends AbstractMojo {
    @Parameter(property="project", defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="vwscdn.async", defaultValue="true", readonly=true)
    private boolean asyncCompile;
    @Parameter(property="vwscdn.download", defaultValue="false", readonly=true)
    private boolean download;
    @Parameter(property="vwscdn.compile.style", defaultValue="OBF", readonly=true)
    private String compileStyle;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/vwscdn")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/vwscdn-widgetset")
    private File lastWidgetset;
    @Parameter(property="downloadedDirectory", defaultValue="${project.build.directory}/${project.build.finalName}/VAADIN/widgetsets")
    private File downloadedDirectory;

    public void execute() throws MojoExecutionException {
        try {
            this.project.addCompileSourceRoot("target/generated-sources/vwscdn");
            String packageName = "in.virit";
            String className = "WidgetSet";
            String vaadinVersion = null;
            File packageDirectory = new File(this.outputDirectory, packageName.replace(".", "/"));
            packageDirectory.mkdirs();
            List cp = this.project.getCompileClasspathElements();
            HashMap<String, URL> urls = new HashMap<String, URL>();
            for (Object object : cp) {
                String path = (String)object;
                urls.put(path, new File(path).toURI().toURL());
            }
            Map<String, URL> availableWidgetSets = ClassPathExplorer.getAvailableWidgetSets(urls);
            Set artifacts = this.project.getArtifacts();
            for (Object artifact : artifacts) {
                if (!artifact.getArtifactId().equals("vaadin-server")) continue;
                vaadinVersion = artifact.getVersion();
                break;
            }
            HashSet<Artifact> uniqueArtifacts = new HashSet<Artifact>();
            for (String string : availableWidgetSets.keySet()) {
                URL url = availableWidgetSets.get(string);
                for (Artifact a : artifacts) {
                    String u = url.toExternalForm();
                    if (!u.contains(a.getArtifactId()) || !u.contains(a.getBaseVersion()) || u.contains("vaadin-client")) continue;
                    uniqueArtifacts.add(a);
                }
            }
            WidgetSetRequest wsReq = new WidgetSetRequest();
            for (Artifact a : uniqueArtifacts) {
                wsReq.addon(a.getGroupId(), a.getArtifactId(), a.getBaseVersion());
            }
            System.out.println((wsReq.getAddons() != null ? wsReq.getAddons().size() : 0) + " addons widget set found.");
            wsReq.setCompileStyle(this.compileStyle);
            wsReq.setVaadinVersion(vaadinVersion);
            if (this.lastWidgetset.exists() && FileUtils.readFileToString((File)this.lastWidgetset).equals(wsReq.toWidgetsetString())) {
                System.out.println("No changes in widgetset: " + wsReq.toWidgetsetString());
                return;
            }
            FileUtils.writeStringToFile((File)this.lastWidgetset, (String)wsReq.toWidgetsetString());
            File file = new File(packageDirectory, className + ".java");
            if (this.download) {
                this.serveLocally(wsReq, vaadinVersion, file);
            } else {
                this.serveFromCDN(wsReq, vaadinVersion, file);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VWSCDNMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (DependencyResolutionRequiredException ex) {
            Logger.getLogger(VWSCDNMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void serveLocally(WidgetSetRequest wsReq, String vaadinVersion, File outputFile) throws IOException, MojoExecutionException {
        String wsName = null;
        Object wsUrl = null;
        Connection conn = new Connection();
        wsName = conn.downloadRemoteWidgetSet(wsReq, this.downloadedDirectory);
        String listener = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/weblistener.tmpl"));
        listener = listener.replace("__wsUrl", "local");
        listener = listener.replace("__wsName", wsName);
        listener = listener.replace("__wsReady", "true");
        StringBuilder sb = new StringBuilder();
        if (wsReq.getAddons() != null) {
            for (AddonInfo a : wsReq.getAddons()) {
                String aid = a.getArtifactId();
                String gid = a.getGroupId();
                String v = a.getVersion();
                sb.append(" * ");
                sb.append(aid);
                sb.append(":");
                sb.append(gid);
                sb.append(":");
                sb.append(v);
                sb.append("\n");
            }
        }
        listener = listener.replace("__vaadin", " * " + vaadinVersion);
        listener = listener.replace("__style", " * " + this.compileStyle);
        listener = listener.replace("__addons", sb.toString());
        FileUtils.writeStringToFile((File)outputFile, (String)listener);
        System.out.println("Widgetset config created to " + outputFile.getAbsolutePath() + ".");
    }

    protected void serveFromCDN(WidgetSetRequest wsReq, String vaadinVersion, File outputFile) throws IOException, MojoExecutionException {
        String wsName = null;
        String wsUrl = null;
        Connection conn = new Connection();
        WidgetSetResponse wsRes = conn.queryRemoteWidgetSet(wsReq, this.asyncCompile);
        if (wsRes == null || wsRes.getStatus() != PublishState.AVAILABLE && wsRes.getStatus() != PublishState.COMPILED && wsRes.getStatus() != PublishState.COMPILING) {
            throw new MojoExecutionException("Remote widgetset compilation failed: " + (wsRes != null ? wsRes.getStatus() : " (no response)"));
        }
        wsName = wsRes.getWidgetSetName();
        wsUrl = wsRes.getWidgetSetUrl();
        String listener = IOUtil.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/weblistener.tmpl"));
        listener = listener.replace("__wsUrl", wsUrl);
        listener = listener.replace("__wsName", wsName);
        listener = listener.replace("__wsReady", wsRes.getStatus() == PublishState.AVAILABLE ? "true" : "false");
        StringBuilder sb = new StringBuilder();
        if (wsReq.getAddons() != null) {
            for (AddonInfo a : wsReq.getAddons()) {
                String aid = a.getArtifactId();
                String gid = a.getGroupId();
                String v = a.getVersion();
                sb.append(" * ");
                sb.append(aid);
                sb.append(":");
                sb.append(gid);
                sb.append(":");
                sb.append(v);
                sb.append("\n");
            }
        }
        listener = listener.replace("__vaadin", " * " + vaadinVersion);
        listener = listener.replace("__style", " * " + this.compileStyle);
        listener = listener.replace("__addons", sb.toString());
        FileUtils.writeStringToFile((File)outputFile, (String)listener);
        if (wsName != null && wsUrl != null) {
            System.out.println("Widgetset config created to " + outputFile.getAbsolutePath() + ". Public URL: " + wsUrl);
        } else {
            System.out.println("Widget set created to " + outputFile.getAbsolutePath() + ".");
        }
    }
}

