package com.vrs.android.fyreon.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;

import com.squareup.picasso.Picasso;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.UserDetail;
import com.vrs.android.fyreon.widgets.VRSRobotoTextView;

import java.util.ArrayList;
import java.util.List;

/**
 * Package Name : com.vrs.android.fyreon.adapters
 * Created by vrsuser on 21/4/15.
 * Time : 12:11 PM
 * Project : fyreon-library-android
 * Modified : 21 12 11
 */
public class CommentUserDetailListAdapter extends ArrayAdapter<UserDetail> {

    static final String LOG_TAG = CommentUserDetailListAdapter.class.getSimpleName();

    Context mContext;
    LayoutInflater mInflater = null;
    List<UserDetail> dataList = new ArrayList<UserDetail>();

    public CommentUserDetailListAdapter(Context context, int resource, List<UserDetail> objects) {
        super(context, resource, objects);
        this.mContext = context;
        this.dataList = objects;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = new ViewHolder();
        View layoutView = convertView;

        mInflater = (LayoutInflater) mContext
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        layoutView = mInflater.inflate(R.layout.list_user_detail_cell, null, false);
        holder.ivProfileIcon = (ImageView) layoutView.findViewById(R.id.iv_profile_icon);
        holder.txtName = (VRSRobotoTextView) layoutView.findViewById(R.id.txt_user_name);


        UserDetail detail = dataList.get(position);

        holder.txtName.setText(detail.getUserName());
        Picasso.with(mContext).load(detail.getIconUrl()).placeholder(R.drawable.default_user_icon).error(R.drawable.default_user_icon).into(holder.ivProfileIcon);

        return layoutView;
    }

    private class ViewHolder {
        public VRSRobotoTextView txtName;
        public ImageView ivProfileIcon;
    }
}
