package com.vrs.android.fyreon.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.vrs.android.fyreon.database.DatabaseCipherHelper;
import com.vrs.android.fyreon.model.CrashData;
import com.vrs.android.fyreon.utils.AppConstants;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SendData extends BroadcastReceiver {
    DatabaseCipherHelper dbhelper;
    SQLiteDatabase db;
    int rowId;
    int response;
    ArrayList<CrashData> crashData;
    Cursor c;
    String data;
    ArrayList<String> dataId = new ArrayList<String>();

    @Override
    public void onReceive(Context arg0, Intent arg1) {
        Log.d("Message", "Receive Broadcast");
        PackageManager pm = arg0.getPackageManager();
        try {
            data = (String) pm.getApplicationLabel(pm.getApplicationInfo(arg0
                            .getApplicationContext().getPackageName(),
                    PackageManager.GET_META_DATA));
        } catch (NameNotFoundException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }
        dbhelper = new DatabaseCipherHelper(arg0, data + "_INFO.db");
        if (AppConstants.isNetworkAvailable(arg0)) {
            Log.d("message", "networkavailable");

            if (AppConstants.getData(arg0, arg0.getApplicationContext()
                    .getPackageName())) {

                Log.d("Message", "Network Available in BroadcastReceiver");
                db = dbhelper.getReadableDatabase();
                crashData = new ArrayList<CrashData>();
                crashData = getAllData();
                // Log.d("CrashData", ""+crashData.size());

                for (int i = 0; i < crashData.size(); i++) {
                    final CrashData data = crashData.get(i);
                    sendDataAndRemove(data);

                }

            }
        }

    }

    public void sendDataAndRemove(final CrashData data) {
        final Handler handler = new Handler() {

            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (response > 0) {

                    for (int i = 0; i < dataId.size(); i++) {
                        Log.d("Message", "" + dataId.get(i));
                        dbhelper.deleteRecord(Integer.parseInt(dataId.get(i)));
                    }

                }
            }
        };
        final Thread thread = new Thread() {

            @Override
            public void run() {
                // TODO Auto-generated method stub
                super.run();
                try {
                    Log.d("Message", "in the try");
                    HttpClient httpclient = new DefaultHttpClient();
                    HttpPost httpPost = new HttpPost(
                            "http://vrsweb.in/ws/add.php");
                    List<NameValuePair> nameValuePair = new ArrayList<NameValuePair>(
                            12);
                    rowId = data.getRowId();

                    nameValuePair.add(new BasicNameValuePair("strace", ""
                            + data.getStrace()));
                    nameValuePair.add(new BasicNameValuePair("brand", data
                            .getBrand()));
                    nameValuePair.add(new BasicNameValuePair("device", data
                            .getDevice()));
                    nameValuePair.add(new BasicNameValuePair("model",
                            data.model));
                    nameValuePair.add(new BasicNameValuePair("manufacturer",
                            data.manufacturer));
                    nameValuePair.add(new BasicNameValuePair("api", data.api));
                    nameValuePair.add(new BasicNameValuePair("memory", data
                            .getMemory()));
                    nameValuePair.add(new BasicNameValuePair("cpu", ""
                            + data.getCpu()));
                    nameValuePair.add(new BasicNameValuePair("package", data
                            .getPackageName()));
                    nameValuePair.add(new BasicNameValuePair("appname",
                            data.appName));
                    nameValuePair.add(new BasicNameValuePair("userkey", ""
                            + data.userKey));
                    nameValuePair.add(new BasicNameValuePair("type", "1"));
                    httpPost.setEntity(new UrlEncodedFormEntity(nameValuePair));
                    HttpResponse httpResponse = httpclient.execute(httpPost);
                    InputStream input = httpResponse.getEntity().getContent();
                    BufferedReader br = new BufferedReader(
                            new InputStreamReader(input, "iso-8859-1"), 8);
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    while (true) {
                        line = br.readLine();
                        if (line == null || line.length() == 0) {
                            break;
                        }
                        sb.append(line);
                    }
                    br.close();
                    input.close();
                    Log.d("Response ", "Response" + sb.toString());
                    response = Integer.parseInt(sb.toString());
                    if (response > 0) {
                        dataId.add("" + data.getRowId());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    handler.sendEmptyMessage(0);

                }
            }

        };
        thread.start();
    }

    private Cursor getData() {
        Cursor mCur = null;

        if (db != null) {
            db = dbhelper.getWritableDatabase();
            // dbhelper.insertCrashData("Hello", "Android", "generic",
            // "generic",
            // "generic", "14", "10", "10", "com.vrs.manual", "manual",
            // "1234-5678-9876", "Android", "1234");

            Log.d("Database", "" + db.isOpen());
            Log.d("message", "db not null");

            String selectQuery = null;
            selectQuery = "select * from CrashData;";
            mCur = db.rawQuery(selectQuery, null);
            Log.d("Cursor Count", "" + mCur.getCount());

            // mCur = db.query("CrashData", null, null, null,
            // null, null, null);
            return mCur;
        }
        return mCur;
    }

    public ArrayList<CrashData> getAllData() {

        c = getData();
        // Log.d("Cursor Count", ""+c.getCount());

        if (c.moveToFirst()) {
            do {
                CrashData data = new CrashData();
                data.setApi((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_ANDROID_API_VERSION))));
                Log.d("API",
                        ""
                                + c.getString(c
                                .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_USER_KEY)));
                data.setAppName((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_APP_NAME))));
                data.setBrand((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_BRAND))));
                data.setCpu((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_CPU_USAGE))));
                data.setDevice((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_DEVICE))));
                data.setManufacturer((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_DEVICE_MANUFACTURE))));
                data.setMemory((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_TOTAL_MEMORY))));
                data.setModel((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_MODAL))));
                data.setPackageName((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_PACKAGE_NAME))));
                data.setStrace((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_STACK_TRACE))));
                data.setUserKey((c.getString(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_USER_KEY))));
                data.setRowId(c.getInt(c
                        .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_ID)));

                Log.d("Row id",
                        " id "
                                + c.getLong(c
                                .getColumnIndex(DatabaseCipherHelper.CRASH_REPORT_ID)));
                crashData.add(data);
            } while (c.moveToNext());
        }
        c.close();
        return crashData;
    }

}
