/**---------------------------------------------------------------------------------
 File Name : DatabaseResult.java
 Version Information : Version 1.1
 Date of Creation : 25/2/15
 Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/
package com.vrs.android.fyreon.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.vrs.android.fyreon.model.ResultModel;

import java.util.ArrayList;
import java.util.List;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : DatabaseResult
 * Description : Database table helper class which allow to do CRUD operation.
 * Date of Creation : 25/2/15
 * Extends : SQLiteOpenHelper
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 * @see com.vrs.android.fyreon.database.DatabaseResult
 */

public class DatabaseResult {

    // private member declaration.
    private SQLiteDatabase mDatabase;
    private DatabaseCipherHelper mDbHelper;
    private String[] mAllColumns = {
            DatabaseCipherHelper.COLUMN_ID,
            DatabaseCipherHelper.COLUMN_SCREEN_NAME,
            DatabaseCipherHelper.COLUMN_PACKAGE_NAME,
            DatabaseCipherHelper.COLUMN_APP_KEY
    };

    public DatabaseResult(Context context) {
        mDbHelper = new DatabaseCipherHelper(context);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : open
     * Description : open database connection in writing mode.
     * Date of Creation : 25/02/15
     *
     * @throws java.sql.SQLException -------------------------------------------------------------------------------------
     *                               Update Log:
     *                               Date:		By:		Details:
     *                               <p/>
     *                               25/2/15    Rajan       Create full class
     *                               24/3/15    Bhadresh    Refactor code as per coding standard.
     *                               -----------------------------------------------------------------------------------
     */
    public void open() throws SQLException {
        // Add code to print out the key hash
        mDatabase = mDbHelper.getWritableDatabase();
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : close
     * Description : Close database connection.
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public void close() {
        mDbHelper.close();
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : addResult
     * Description : Insert data in table
     * Date of Creation : 25/02/15
     *
     * @param resultModel
     * @return ResultModel
     * @see com.vrs.android.fyreon.model.ResultModel
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public boolean addResult(@NonNull ResultModel resultModel) {
        Cursor cursorScreenCount = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                mAllColumns, DatabaseCipherHelper.COLUMN_SCREEN_NAME + "=?", new String[]{resultModel.mScreenName}, null, null, null, null);
        if (cursorScreenCount.getCount() > 0) {
            cursorScreenCount.close();
            return false;
        } else {
            cursorScreenCount.close();
            ContentValues values = new ContentValues();
            values.put(DatabaseCipherHelper.COLUMN_SCREEN_NAME, resultModel.mScreenName);
            values.put(DatabaseCipherHelper.COLUMN_PACKAGE_NAME, resultModel.mPackageName);
            values.put(DatabaseCipherHelper.COLUMN_APP_KEY, resultModel.mAppKey);
            final long insertId = mDatabase.insert(DatabaseCipherHelper.TABLE_TARGET, null, values);
            Log.d("Database", "Inserted Id : " + insertId);
            /*Cursor cursor = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                    mAllColumns, DatabaseCipherHelper.COLUMN_ID + " = "
                            + insertId, null, null, null, null);
            cursor.moveToFirst();
            cursor.close();*/
            return true;
        }


    }


    public void testSelect(@Nullable String where, @Nullable String[] args) {
        long recordCount = DatabaseUtils.queryNumEntries(mDatabase, DatabaseCipherHelper.TABLE_TARGET);
        for (long i = recordCount; i > 0; i--) {
            Cursor cursor = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                    mAllColumns, where, args, null, null, null, null);
            cursor.close();
        }
        for (long i = recordCount; i > 0; i--) {
            Cursor cursor = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                    mAllColumns, where, args, null, null, DatabaseCipherHelper.COLUMN_SCREEN_NAME, null);
            cursor.close();
        }
        for (long i = recordCount; i > 0; i--) {
            Cursor cursor = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                    mAllColumns, where, args, null, null, DatabaseCipherHelper.COLUMN_PACKAGE_NAME, null);
            cursor.close();
        }
        for (long i = recordCount; i > 0; i--) {
            Cursor cursor = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                    mAllColumns, where, args, null, null, DatabaseCipherHelper.COLUMN_APP_KEY, null);
            cursor.close();
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : deleteFirstRecord
     * Description : Delete first row from table
     * Date of Creation : 25/02/15
     *
     * @return boolean
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public boolean deleteFirstRecord() {
        List<ResultModel> results = getResults(null, null, "1");
        for (ResultModel resultModel : results) {
            mDatabase.delete(DatabaseCipherHelper.TABLE_TARGET, DatabaseCipherHelper.COLUMN_ID + "=?", new String[]{"" + resultModel.mID});
        }
        return results.size() > 0;
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : deleteAll
     * Description : Remove all record from database table
     * Date of Creation : 25/02/15
     *
     * @see com.vrs.android.fyreon.model.ResultModel
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public void deleteAll() {
        mDatabase.delete(DatabaseCipherHelper.TABLE_TARGET, null, null);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : addResult
     * Description : Insert data in table
     * Date of Creation : 25/02/15
     *
     * @param where
     * @param args
     * @param limit
     * @return List
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public List<ResultModel> getResults(@Nullable String where, @Nullable String[] args, String limit) {
        List<ResultModel> databaseSelectedResults = new ArrayList<>();
       /* Cursor cursor = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                mAllColumns, where, args, null, null, null, limit);*/
        Cursor cursor = mDatabase.query(DatabaseCipherHelper.TABLE_TARGET,
                mAllColumns, DatabaseCipherHelper.COLUMN_SCREEN_NAME + "=?", args, null, null, null, limit);
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            ResultModel resultModel = cursorToResult(cursor);
            databaseSelectedResults.add(resultModel);
            cursor.moveToNext();
        }
        cursor.close();
        return databaseSelectedResults;
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : cursorToResult
     * Description : Convert cursor object into ResultModel type
     * Date of Creation : 25/02/15
     *
     * @param cursor
     * @return ResultModel
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private ResultModel cursorToResult(Cursor cursor) {
        ResultModel resultModel = new ResultModel();
        resultModel.mID = cursor.getLong(0);
        resultModel.mScreenName = cursor.getString(1);
        resultModel.mPackageName = cursor.getString(2);
        resultModel.mAppKey = cursor.getString(3);
        return resultModel;
    }


}
