package com.vrs.android.fyreon.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Response;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.ui.AppDetailActivity;
import com.vrs.android.fyreon.utils.AppConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by vrsuser on 17/4/15.
 */
public class UserAppsFragment extends Fragment {
    private static final String LOG_TAG = UserCommentsFragment.class.getSimpleName();
    ListView lstAppsList;
    CustomListAdapter adapter;
    List<CommentListModel> list = new ArrayList<CommentListModel>();
    SharedPreferences mSharedPreferences;
    Drawable icon = null;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_user_apps, container, false);
        lstAppsList = (ListView) rootView.findViewById(R.id.fragment_user_apps_listview);
        lstAppsList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
                Intent startIntent = new Intent(getActivity(), AppDetailActivity.class);
                startIntent.putExtra("application_id", list.get(position).getComment_id());
                startIntent.putExtra(AppConstants.COMMENT_CREATED, list.get(position).getTime());
                startIntent.putExtra(AppConstants.COMMENT_APP_NAME, list.get(position).getApp_name());
                getActivity().startActivity(startIntent);
            }
        });
        mSharedPreferences = getActivity().getSharedPreferences(AppConstants.PREF_NAME, 0);
        String socialId = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "");
        String socialTypes = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, "");

        loadUserComments(socialId, socialTypes);
        String pkg = getActivity().getApplicationContext().getPackageName();

        try {
            icon = getActivity().getPackageManager().getApplicationIcon(pkg);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        // adapter = new CustomListAdapter(getActivity(),list);
        // lstCommentList.setAdapter(adapter);
        return rootView;

    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : loadUserComments
     * Description : Load user comments list from server
     * Date of Creation : 15/04/15
     *
     * @param socialId
     * @param socialTypes -------------------------------------------------------------------------------------
     *                    Update Log:
     *                    Date:		By:		Details:
     *                    15/04/15    Bhadresh       Created full Method
     *                    -----------------------------------------------------------------------------------
     */
    private void loadUserComments(String socialId, String socialTypes) {
        list.clear();
        Log.d(LOG_TAG, "Social ID :" + socialId);
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("social_id", socialId);
        jsonParams.addProperty("social_type", socialTypes);
        Ion.with(getActivity())
                .load(AppConstants.URL_GET_USER_APPS)
                .setJsonObjectBody(jsonParams)
                .asString()
                .withResponse()
                .setCallback(new FutureCallback<Response<String>>() {
                    @Override
                    public void onCompleted(Exception e, Response<String> result) {

                        if (e == null) {
                            Log.d(LOG_TAG, "Result Code : " + result.getHeaders().code() + "");
                            Log.d(LOG_TAG, "Result String : " + result.getResult());
                            if (result != null) {
                                String responseCode = String.valueOf(result.getHeaders().code());
                                if (responseCode.equals(AppConstants.STATUS_CODE_SUCCESS)) {
                                    Log.d(LOG_TAG, "Success : " + result.getResult());
                                    JsonParser parser = new JsonParser();
                                    JsonElement commentsElement = parser.parse(result.getResult());
                                    JsonArray commentsArray = commentsElement.getAsJsonArray();
                                    //String imageUrl =;
                                    for (int i = 0; i < commentsArray.size(); i++) {
                                        JsonObject commentObject = commentsArray.get(i).getAsJsonObject();
                                        Log.d(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                                        String createdTime = commentObject.get("connected_on").getAsString();
                                        String appName = commentObject.get("application_name").getAsString();
                                        String applicationId = commentObject.get("application_id").getAsString();
                                        CommentListModel listItem = new CommentListModel(applicationId, "", "", "", "", createdTime, "", "", "", "", null, appName, null, "");
                                        list.add(listItem);
                                    }
                                    if (list.size() > 0) {
                                        adapter = new CustomListAdapter(getActivity(), list);
                                        lstAppsList.setAdapter(adapter);
                                    }
                                } else if (responseCode.equals(AppConstants.STATUS_CODE_FAILURE)) {
                                    Log.d(LOG_TAG, "Failure : " + result.getResult());
                                }
                            }
                        } else {
                            Log.d(LOG_TAG, "Exception : " + e.getMessage());
                        }
                    }
                });
    }

    /**
     * ----------------------------------------------------------------------------------
     * Class Name : CustomListAdapter
     * Description : List adapter for user comments
     * Date of Creation : 15/04/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * 15/04/15    Bhadresh       Created full Method
     * -----------------------------------------------------------------------------------
     */
    public class CustomListAdapter extends BaseAdapter {

        private Bitmap userImage;
        private Activity activity;
        private LayoutInflater inflater;
        private List<CommentListModel> listItems;

        public CustomListAdapter(Activity activity, List<CommentListModel> movieItems) {
            this.activity = activity;
            this.listItems = movieItems;
        }

        @Override
        public int getCount() {
            return listItems.size();
        }

        @Override
        public Object getItem(int location) {
            return listItems.get(location);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            if (inflater == null)
                inflater = (LayoutInflater) activity
                        .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            if (convertView == null)
                convertView = inflater.inflate(R.layout.list_item_activity_user_profile, null);

            TextView name = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_name);
            // TextView comments = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_comments);
            TextView time = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_comments);
            //  TextView appName = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_appname);
            ImageView image = (ImageView) convertView.findViewById(R.id.list_item_activity_user_profile_img_profile);
            if (icon != null)
                image.setImageDrawable(icon);
            //  Picasso.with(getActivity()).load(listItems.get(position).getIcons()).error(R.drawable.default_user_icon).placeholder(R.drawable.default_user_icon).into(image);
            //image.setImageUrl(m.getThumbnailUrl(), imageLoader);

            // title
            name.setText(listItems.get(position).getApp_name());
            // comments.setText(listItems.get(position).getComment());
            // appName.setText(listItems.get(position).getApp_name());
            Log.d(LOG_TAG, "Time Stemp : " + listItems.get(position).getTime());
            time.setText(AppConstants.getTimeTwitter(Long.parseLong(listItems.get(position).getTime())));
            return convertView;
        }
    }
}
