package com.vrs.android.fyreon.handlers;

import android.app.ActivityManager;
import android.app.ActivityManager.MemoryInfo;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.TrafficStats;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

import com.vrs.android.fyreon.database.DatabaseCipherHelper;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.CpuInfo;
import com.vrs.android.fyreon.utils.MemoryUtils;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.Thread.UncaughtExceptionHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ExceptionHandler implements
        UncaughtExceptionHandler {
    public static final String TIME_IN_STATE_PATH = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state";
    public static final String CURRENT_CPU_USAGE = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";
    private final Context myContext;
    private final String LINE_SEPARATOR = "\n";
    ArrayList<Long> frequency;
    ArrayList<Long> duration;
    String current_Cpu_Freq;
    long totalstate = 0;
    ApplicationInfo ai = null;
    String data = null;
    int response;
    int rowId;
    sendDataAsyn sendAsync;
    DatabaseCipherHelper db;
    StringWriter stackTrace;
    UncaughtExceptionHandler defaultUEH;
    Runtime runtime;
    int mb;
    private CpuInfo cpuinfo;

    public ExceptionHandler(Context con) {
        myContext = con;
        defaultUEH = Thread.getDefaultUncaughtExceptionHandler();

    }

    @SuppressWarnings("deprecation")
    public void uncaughtException(Thread thread, Throwable exception) {
        SimpleDateFormat formatter1 = new SimpleDateFormat(
                "yyyy_MM_dd_HH_mm_ss");
        Date now1 = new Date();
        String date = formatter1.format(now1);
        stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        StringBuilder errorReport = new StringBuilder();
        errorReport.append("************ CAUSE OF ERROR ************\n\n");
        errorReport.append(stackTrace.toString());

        errorReport.append("\n************ DEVICE INFORMATION ***********\n");
        errorReport.append("Brand: ");
        errorReport.append(Build.BRAND);
        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Device: ");
        errorReport.append(Build.DEVICE);
        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Model: ");
        errorReport.append(Build.MODEL);
        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Manufacturer : ");
        errorReport.append(Build.MANUFACTURER);
        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Android API Version : ");
        errorReport.append(Build.VERSION.SDK);
        try {
            ApplicationInfo ai = myContext.getPackageManager()
                    .getApplicationInfo(myContext.getPackageName(),
                            PackageManager.GET_META_DATA);

            errorReport.append(LINE_SEPARATOR);
            errorReport.append("User API KEY : ");
            errorReport.append(ai.metaData.get("APIKEY"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        MemoryInfo mi = new MemoryInfo();
        ActivityManager activityManager = (ActivityManager) myContext
                .getSystemService(Context.ACTIVITY_SERVICE);
        activityManager.getMemoryInfo(mi);

        int id = android.os.Process.myPid();
        String uid = "" + android.os.Process.myUid();

        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Process Id : ");
        errorReport.append("" + id);
        int[] pids = new int[1];
        pids[0] = id;
        android.os.Debug.MemoryInfo[] MI = activityManager
                .getProcessMemoryInfo(pids);

        mb = 1024 * 1024;
        runtime = Runtime.getRuntime();
        Log.d("used Memory", ""
                + (runtime.totalMemory() - runtime.freeMemory()) / mb);

        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Total Memory : ");
        errorReport
                .append(((runtime.totalMemory() - runtime.freeMemory()) / mb)
                        + "MB");

        Log.d("Total Receive Bytes",
                "" + TrafficStats.getUidRxBytes(Integer.parseInt(uid)));
        Log.d("Total Transfer Bytes",
                "" + TrafficStats.getUidTxBytes(Integer.parseInt(uid)));

        errorReport.append(LINE_SEPARATOR);
        errorReport.append("CPU Usage : ");
        errorReport.append("" + getCpuInfo());

        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Package Name : ");
        errorReport.append(myContext.getApplicationContext().getPackageName());

        PackageManager pm = myContext.getPackageManager();
        try {
            data = (String) pm.getApplicationLabel(pm.getApplicationInfo(
                    myContext.getApplicationContext().getPackageName(),
                    PackageManager.GET_META_DATA));
        } catch (NameNotFoundException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }

        if (AppConstants.isNetworkAvailable(myContext)) {
            Log.d("Message", "network available");
            AppConstants.dataBaseName = data + "_INFO.db";
            db = new DatabaseCipherHelper(myContext, data + "_INFO.db");
            db.getWritableDatabase();
            try {
                ai = myContext.getPackageManager().getApplicationInfo(
                        myContext.getPackageName(),
                        PackageManager.GET_META_DATA);
            } catch (NameNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            db.insertCrashData(stackTrace.toString(), Build.BRAND,
                    Build.DEVICE, Build.MODEL, Build.MANUFACTURER,
                    Build.VERSION.SDK,
                    ((runtime.totalMemory() - runtime.freeMemory()) / mb)
                            + "MB", "" + getCpuInfo(), myContext
                            .getApplicationContext().getPackageName(), data, ""
                            + ai.metaData.get("APIKEY"), "Android", date);

            sendAsync = new sendDataAsyn();
            sendAsync.execute("Data");

        } else {
            if (AppConstants.isCreateDatabase == true) {
                Log.d("Message", "in the else");
                AppConstants.dataBaseName = data + "_INFO.db";
                db = new DatabaseCipherHelper(myContext, data + "_INFO.db");
                db.getWritableDatabase();
                ApplicationInfo ai = null;
                try {
                    ai = myContext.getPackageManager().getApplicationInfo(
                            myContext.getPackageName(),
                            PackageManager.GET_META_DATA);
                } catch (NameNotFoundException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                db.insertCrashData(stackTrace.toString(), Build.BRAND,
                        Build.DEVICE, Build.MODEL, Build.MANUFACTURER,
                        Build.VERSION.SDK,
                        ((runtime.totalMemory() - runtime.freeMemory()) / mb)
                                + "MB", getCpuInfo(), myContext
                                .getApplicationContext().getPackageName(),
                        data, "" + ai.metaData.get("APIKEY"), "Android", date);

            }
        }
        errorReport.append(LINE_SEPARATOR);
        errorReport.append("Application Name : ");
        errorReport.append("" + data);

        Log.d("PID Memory size",
                "" + MemoryUtils.getPidMemorySize(id, myContext));

        Log.d("Cpu Info", "" + CpuInfo.getCpuName());

        Log.d("UID", "" + uid);

        /**
         * For Creating FIle
         */
        // SimpleDateFormat formatter = new
        // SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        // Date now = new Date();
        // String fileName = formatter.format(now);
        // File folder = new File(Environment.getExternalStorageDirectory()
        // + "/CrashReport" + "/Log");
        // boolean success = true;
        // if (!folder.exists()) {
        // Log.d("CrashReport", "in create directory");
        // success = folder.mkdirs();
        // }
        //
        // File file = new File(folder, fileName + "_log.txt");
        // Log.d("File Name", "" + file.getAbsolutePath());
        // try {
        // BufferedWriter buf = new BufferedWriter(new FileWriter(file, true));
        // buf.append(fileName + ":" + errorReport.toString());
        // buf.newLine();
        // buf.close();
        // } catch (IOException e) {
        // e.printStackTrace();
        // }

        defaultUEH.uncaughtException(thread, exception);
        // sendErrorMail("Data");
        System.exit(0);
    }

    private float readUsage() {
        try {
            RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();

            String[] toks = load.split(" ");

            long idle1 = Long.parseLong(toks[4]);
            long cpu1 = Long.parseLong(toks[2]) + Long.parseLong(toks[3])
                    + Long.parseLong(toks[5]) + Long.parseLong(toks[6])
                    + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);

            try {
                Thread.sleep(360);
            } catch (Exception e) {
            }

            reader.seek(0);
            load = reader.readLine();
            reader.close();

            toks = load.split(" ");

            long idle2 = Long.parseLong(toks[4]);
            long cpu2 = Long.parseLong(toks[2]) + Long.parseLong(toks[3])
                    + Long.parseLong(toks[5]) + Long.parseLong(toks[6])
                    + Long.parseLong(toks[7]) + Long.parseLong(toks[8]);

            return (float) (cpu2 - cpu1) / ((cpu2 + idle2) - (cpu1 + idle1));

        } catch (IOException ex) {
            ex.printStackTrace();
        }

        return 0;
    }

    private String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("abi: ").append(Build.CPU_ABI).append("\n");
        if (new File("/proc/cpuinfo").exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(new File(
                        "/proc/cpuinfo")));
                String aLine;
                while ((aLine = br.readLine()) != null) {
                    sb.append(aLine + "\n");
                }
                if (br != null) {
                    br.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public String getCpuInfo() {
        String aBuffer = "";
        String aDataRow = "";
        frequency = new ArrayList<Long>();
        duration = new ArrayList<Long>();
        try {
            InputStream is = new FileInputStream(TIME_IN_STATE_PATH);
            InputStreamReader ir = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(ir);
            while ((aDataRow = br.readLine()) != null) {
                aBuffer += aDataRow + "\n";
                String[] nums = aDataRow.split(" ");
                frequency.add(Long.parseLong(nums[0]));
                duration.add(Long.parseLong(nums[1]));

            }
            is.close();
            Log.d("Data", " Data " + aBuffer);
            for (int i = 0; i < duration.size(); i++) {
                totalstate += duration.get(i);
            }
            for (int i = 0; i < frequency.size(); i++) {
                float per = (float) duration.get(i) * 100 / totalstate;
                String sPer = (int) per + "%";
                Log.d("Frequency", "" + (frequency.get(i) / 1000) + " Mhz"
                        + " " + sPer);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        String aBuffer1 = "";
        String aDataRow1 = "";
        try {
            InputStream is = new FileInputStream(CURRENT_CPU_USAGE);
            InputStreamReader ir = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(ir);
            while ((aDataRow1 = br.readLine()) != null) {
                aBuffer1 += aDataRow1 + "\n";

            }
            is.close();
            // Log.d("Current", "" + aBuffer1);
            String data = aBuffer1;
            Long cpu = Long.parseLong(data.trim());

            Log.d("Current", +(cpu / 1000) + " Mhz");
            for (int i = 0; i < frequency.size(); i++) {
                long current = (cpu / 1000);
                Log.d("Current", "" + current);
                if ((frequency.get(i) / 1000) == current) {
                    float per = (float) duration.get(i) * 100 / totalstate;
                    String sPer = (int) per + "%";
                    String current_frequency = "Current Frequency "
                            + (frequency.get(i) / 1000) + " Mhz" + " And CPU "
                            + sPer;

                    Log.d("Frequency", "Current Frequency "
                            + (frequency.get(i) / 1000) + " Mhz" + " And CPU "
                            + sPer);
                    return current_frequency;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "no data";
    }

    public void sendErrorMail(final String errorContent) {
        final AlertDialog.Builder builder = new AlertDialog.Builder(myContext);
        new Thread() {
            @Override
            public void run() {
                Looper.prepare();
                builder.setTitle("Sorry...!");
                builder.create();
                builder.setNegativeButton("Cancel",
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog,
                                                int which) {
                                System.exit(0);
                            }
                        });
                builder.setPositiveButton("Report",
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog,
                                                int which) {
                                // Intent sendIntent = new Intent(
                                // Intent.ACTION_SEND);
                                // String subject = "Your App crashed! Fix it!";
                                // StringBuilder body = new
                                // StringBuilder("Yoddle");
                                // body.append('\n').append('\n');
                                // body.append(errorContent).append('\n')
                                // .append('\n');
                                // // sendIntent.setType("text/plain");
                                // sendIntent.setType("message/rfc822");
                                // sendIntent.putExtra(Intent.EXTRA_EMAIL,
                                // new String[] { "coderzheaven@gmail.com" });
                                // sendIntent.putExtra(Intent.EXTRA_TEXT,
                                // body.toString());
                                // sendIntent.putExtra(Intent.EXTRA_SUBJECT,
                                // subject);
                                // sendIntent.setType("message/rfc822");
                                // context1.startActivity(sendIntent);
                                System.exit(0);
                            }
                        });
                builder.setMessage("Oops,Your application has crashed");
                builder.show();
                Looper.loop();
            }
        }.start();
    }

    private class sendDataAsyn extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... params) {
            // TODO Auto-generated method stub
            String responseMessage = null;
            try {
                Log.d("Message", "in the try");
                HttpClient httpclient = new DefaultHttpClient();
                HttpPost httpPost = new HttpPost("http://vrsweb.in/ws/add.php");
                List<NameValuePair> nameValuePair = new ArrayList<NameValuePair>(
                        12);
                nameValuePair.add(new BasicNameValuePair("strace", ""
                        + stackTrace.toString()));
                nameValuePair.add(new BasicNameValuePair("brand", Build.BRAND));
                nameValuePair
                        .add(new BasicNameValuePair("device", Build.DEVICE));
                nameValuePair.add(new BasicNameValuePair("model", Build.MODEL));
                nameValuePair.add(new BasicNameValuePair("manufacturer",
                        Build.MANUFACTURER));
                nameValuePair.add(new BasicNameValuePair("api",
                        Build.VERSION.SDK));
                nameValuePair.add(new BasicNameValuePair("memory", ((runtime
                        .totalMemory() - runtime.freeMemory()) / mb) + "MB"));
                nameValuePair.add(new BasicNameValuePair("cpu", ""
                        + getCpuInfo()));
                nameValuePair.add(new BasicNameValuePair("package", myContext
                        .getApplicationContext().getPackageName()));
                nameValuePair.add(new BasicNameValuePair("appname", data));
                nameValuePair.add(new BasicNameValuePair("userkey", ""
                        + ai.metaData.get("APIKEY")));
                nameValuePair.add(new BasicNameValuePair("type", "1"));

                httpPost.setEntity(new UrlEncodedFormEntity(nameValuePair));
                HttpResponse httpResponse = httpclient.execute(httpPost);
                InputStream input = httpResponse.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(
                        input, "iso-8859-1"), 8);
                String line = null;
                StringBuilder sb = new StringBuilder();
                while (true) {
                    line = br.readLine();
                    if (line == null || line.length() == 0) {
                        break;
                    }
                    sb.append(line);
                }
                br.close();
                input.close();
                Log.d("Response ", "Response " + sb.toString());
                responseMessage = sb.toString();
                response = Integer.parseInt(sb.toString());
                if (response > 0) {
                    db.deleteData();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            Log.d("Return", "Response Message " + responseMessage);
            return responseMessage;
        }

        @Override
        protected void onPostExecute(String result) {
            // TODO Auto-generated method stub
            super.onPostExecute(result);
            Log.d("Result", "" + result);
            Log.d("message", "in post execute");
            // if(Integer.parseInt(result)>0)
            // {
            // db.deleteData();
            // }
        }

    }

    public class MyHandler extends Handler {

        @Override
        public void handleMessage(Message msg) {
            // TODO Auto-generated method stub
            super.handleMessage(msg);
            Log.d("Resoponse", "Data Removed Successfully");
        }

    }
}