package com.vrs.android.fyreon.ui;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Response;
import com.squareup.picasso.Picasso;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.widgets.CircularImageView;
import com.vrs.android.fyreon.widgets.VRSRobotoTextView;

import java.util.ArrayList;
import java.util.List;

public class AppDetailActivity extends ActionBarActivity {
    private static final String LOG_TAG = UserProfileActivity.class.getSimpleName();

    SharedPreferences mSharedPreferences;
    TextView txtApplicationName;
    CircularImageView imgApplicationIcon;
    VRSRobotoTextView txtLikesCount;
    VRSRobotoTextView txtCommentsCount;
    Drawable icon = null;
    Toolbar mToolBar;
    ListView lstAppCommentList;
    CustomListAdapter adapter;
    List<CommentListModel> list = new ArrayList<CommentListModel>();
    String appId = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_app_detail);
        mToolBar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(mToolBar);
        initViews();
        txtApplicationName.setText(getIntent().getStringExtra(AppConstants.COMMENT_APP_NAME));
        String pkg = getApplicationContext().getPackageName();

        try {
            icon = getPackageManager().getApplicationIcon(pkg);
            imgApplicationIcon.setImageDrawable(icon);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        try {
            getAppDetail();
        } catch (PackageManager.NameNotFoundException e) {
            Log.d(LOG_TAG, "Exception : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void initViews() {
        mSharedPreferences = getSharedPreferences(AppConstants.PREF_NAME, 0);
        txtApplicationName = (TextView) findViewById(R.id.activity_app_detail_txt_appname);
        imgApplicationIcon = (CircularImageView) findViewById(R.id.activity_app_detail_img_app_icon);
        txtLikesCount = (VRSRobotoTextView) findViewById(R.id.activity_app_detail_txt_likes_count);
        txtCommentsCount = (VRSRobotoTextView) findViewById(R.id.activity_app_detail_txt_comments_count);
        lstAppCommentList = (ListView) findViewById(R.id.activity_app_detail_listview);
        appId = getIntent().getStringExtra("application_id");
        getSupportActionBar().setTitle(getIntent().getStringExtra(AppConstants.COMMENT_APP_NAME));
        getSupportActionBar().setHomeButtonEnabled(true);

    }

    public boolean onOptionsItemSelected(MenuItem item) { // Handle item selection
        int i = item.getItemId();
        if (i == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    private void getAppDetail() throws PackageManager.NameNotFoundException {
        ApplicationInfo ai = getPackageManager().getApplicationInfo(getPackageName(), PackageManager.GET_META_DATA);
        Bundle bundle = ai.metaData;
        String myApiKey = bundle.getString("com.vrs.android.fyreon.FyreonWidget.API_KEY");


        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("application_id", appId);
        Log.e(LOG_TAG, "Request Json : " + jsonParams.toString());
        Ion.with(this)
                .load(AppConstants.URL_GET_APP_DETAIL)
                .setJsonObjectBody(jsonParams)
                .asString()
                .withResponse()
                .setCallback(new FutureCallback<Response<String>>() {
                    @Override
                    public void onCompleted(Exception e, Response<String> result) {
                        if (e == null) {
                            Log.d(LOG_TAG, "Result Code : " + result.getHeaders().code() + "");
                            Log.d(LOG_TAG, "Result String : " + result.getResult());
                            if (result != null) {
                                String responseCode = String.valueOf(result.getHeaders().code());
                                if (responseCode.equals(AppConstants.STATUS_CODE_SUCCESS)) {
                                    Log.d(LOG_TAG, "Success : " + result.getResult());
                                    JsonParser parser = new JsonParser();
                                    JsonElement commentsElement = parser.parse(result.getResult());
                                    JsonObject mainObject = commentsElement.getAsJsonObject();
                                    String commentCount = mainObject.get("comments_count").getAsString();
                                    String likeCount = mainObject.get("likes_count").getAsString();
                                    txtCommentsCount.setText(commentCount);
                                    txtLikesCount.setText(likeCount);
                                    JsonArray commentsArray = mainObject.get("comments").getAsJsonArray();
                                    //String imageUrl =;
                                    for (int i = 0; i < commentsArray.size(); i++) {
                                        JsonObject commentObject = commentsArray.get(i).getAsJsonObject();
                                        Log.d(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                                        String createdTime = commentObject.get("comment_time").getAsString();
                                        String content = commentObject.get("content").getAsString();
                                        String userName = commentObject.get("user_name").getAsString();
                                        String userImage = commentObject.get("user_image").getAsString();
                                        CommentListModel listItem = new CommentListModel("", "", "", "", userName, createdTime, content, userImage, "", "", null, "", null, "");
                                        list.add(listItem);
                                    }
                                    if (list.size() > 0) {
                                        adapter = new CustomListAdapter(AppDetailActivity.this, list);
                                        lstAppCommentList.setAdapter(adapter);
                                    }
                                } else if (responseCode.equals(AppConstants.STATUS_CODE_FAILURE)) {
                                    Log.d(LOG_TAG, "Failure : " + result.getResult());
                                }
                            }
                        } else {
                            Log.d(LOG_TAG, "Exception : " + e.getMessage());
                        }
                    }
                });
    }

    /**
     * ----------------------------------------------------------------------------------
     * Class Name : CustomListAdapter
     * Description : List adapter for user comments
     * Date of Creation : 15/04/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * 15/04/15    Bhadresh       Created full Method
     * -----------------------------------------------------------------------------------
     */
    public class CustomListAdapter extends BaseAdapter {

        private Bitmap userImage;
        private Activity activity;
        private LayoutInflater inflater;
        private List<CommentListModel> listItems;

        public CustomListAdapter(Activity activity, List<CommentListModel> movieItems) {
            this.activity = activity;
            this.listItems = movieItems;
        }

        @Override
        public int getCount() {
            return listItems.size();
        }

        @Override
        public Object getItem(int location) {
            return listItems.get(location);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            if (inflater == null)
                inflater = (LayoutInflater) activity
                        .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            if (convertView == null)
                convertView = inflater.inflate(R.layout.list_item_activity_user_profile, null);

            TextView name = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_name);
            TextView comments = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_comments);
            TextView time = (TextView) convertView.findViewById(R.id.list_item_activity_user_profile_txt_time);
            ImageView image = (ImageView) convertView.findViewById(R.id.list_item_activity_user_profile_img_profile);
            Picasso.with(getApplicationContext()).load(listItems.get(position).getIcons()).error(R.drawable.default_user_icon).placeholder(R.drawable.default_user_icon).into(image);
            //image.setImageUrl(m.getThumbnailUrl(), imageLoader);

            // title
            name.setText(listItems.get(position).getName());
            comments.setText(listItems.get(position).getComment());
            Log.d(LOG_TAG, "Time Stemp : " + listItems.get(position).getTime());
            time.setText(AppConstants.getTimeTwitter(Long.parseLong(listItems.get(position).getTime())));
            return convertView;
        }
    }

}
