package com.vrs.android.fyreon.ui;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.widget.ListView;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Response;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.CommentUserDetailListAdapter;
import com.vrs.android.fyreon.handlers.ExceptionHandler;
import com.vrs.android.fyreon.model.UserDetail;
import com.vrs.android.fyreon.utils.AppConstants;

import java.util.ArrayList;

/**
 * Package Name : com.vrs.android.fyreon.ui
 * Created by vrsuser on 21/4/15.
 * Time : 11:52 AM
 * Project : fyreon-library-android
 * Modified : 21 11 52
 */
public class CommentUserDetails extends ActionBarActivity {

    private static final String LOG_TAG = CommentUserDetails.class.getSimpleName();
    private static SharedPreferences mSharedPreferences;
    boolean isFavorite;
    private Toolbar mToolbar;
    private ListView lvUserList;
    private CommentUserDetailListAdapter mAdapter;
    private ArrayList<UserDetail> mUserDetail;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_user_details_comments);

        mToolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(mToolbar);
    }

    @Override
    protected void onResume() {
        super.onResume();
        mSharedPreferences = getApplicationContext().getSharedPreferences(AppConstants.PREF_NAME, 0);
        Ion.getDefault(getApplicationContext()).configure().setLogging(LOG_TAG, Log.INFO);
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(
                getApplicationContext()));
        AppConstants.isCreateDatabase = true;
        AppConstants.setData(getApplicationContext(), true, this.getApplicationContext().getPackageName());


        initView();
        setupView();
    }

    private void initView() {
        lvUserList = (ListView) findViewById(R.id.activity_lv_detail_list);
        mUserDetail = new ArrayList<UserDetail>();
    }

    private void setupView() {
        isFavorite = getIntent().getBooleanExtra("favorite", true);
        if (isFavorite)
            getSupportActionBar().setTitle("Favorited By");
        else
            getSupportActionBar().setTitle("Comments By");

        getSupportActionBar().setHomeButtonEnabled(true);
        addComment();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        int i = item.getItemId();
        if (i == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    private void addComment() {
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("comment_id", getIntent().getStringExtra("comment_id"));
        Log.d(LOG_TAG, "Add Comment json Body : " + jsonParams.toString());
        String URL;
        if (isFavorite)
            URL = AppConstants.URL_GET_LIKED_COMMENT_DETAIL;
        else
            URL = AppConstants.URL_GET_REPLIED_COMMENT_DETAIL;
        Ion.with(this)
                .load(URL)
                .setJsonObjectBody(jsonParams)
                .asString()
                .withResponse()
                .setCallback(new FutureCallback<Response<String>>() {
                    @Override
                    public void onCompleted(Exception e, com.koushikdutta.ion.Response<String> response) {
                        if (e == null) {
                            Log.d(LOG_TAG, "Add Comment Response : " + response.getResult());
                            Log.d(LOG_TAG, "Add Comment Response Code : " + response.getHeaders().code());
                            String responseCode = String.valueOf(response.getHeaders().code());
                            if (responseCode.equals(AppConstants.STATUS_CODE_SUCCESS)) {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(response.getResult());
                                JsonArray result = commentsElement.getAsJsonArray();
                                mUserDetail.clear();
                                for (int i = 0; i < result.size(); i++) {
                                    JsonObject commentObject = result.get(i).getAsJsonObject();
                                    String icon = commentObject.get("user_image").getAsString();
                                    String name = commentObject.get("user_name").getAsString();

                                    UserDetail model = new UserDetail(icon, name);
                                    mUserDetail.add(model);
                                }
                            } else if (responseCode.equals(AppConstants.STATUS_CODE_FAILURE)) {
                            }
                            mAdapter = new CommentUserDetailListAdapter(getApplicationContext(), R.layout.list_user_detail_cell, mUserDetail);
                            lvUserList.setAdapter(mAdapter);
                        }
                    }
                });

    }

}
