package com.vrs.android.fyreon.ui;
/**---------------------------------------------------------------------------------
 File Name : UserProfileActivity.java
 Version Information : Version 1.1
 Date of Creation : 02/04/15
 Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.webkit.CookieSyncManager;
import android.widget.LinearLayout;
import android.widget.TabHost;
import android.widget.TextView;
import android.widget.Toast;

import com.facebook.Session;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.Response;
import com.squareup.picasso.Picasso;
import com.vrs.android.fyreon.FyreonWidget;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.ProfilePagerAdapter;
import com.vrs.android.fyreon.adapters.ProfileTabFactory;
import com.vrs.android.fyreon.fragments.UserAppsFragment;
import com.vrs.android.fyreon.fragments.UserCommentsFragment;
import com.vrs.android.fyreon.fragments.UserLikesFragment;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.widgets.CircularImageView;
import com.vrs.android.fyreon.widgets.VRSRobotoTextView;

import java.util.ArrayList;
import java.util.List;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : UserProfileActivity
 * Description : This is user profile activity.
 * Date of Creation : 02/04/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         02/04/15   Bhadresh      Create full class
 *         08/04/15   Bhadresh      Redesign screen and add likes and commets tab
 *         -----------------------------------------------------------------------------------
 */
public class UserProfileActivity extends ActionBarActivity implements TabHost.OnTabChangeListener, ViewPager.OnPageChangeListener {
    private static final String LOG_TAG = UserProfileActivity.class.getSimpleName();
    SharedPreferences mSharedPreferences;
    TextView txtUserProfileName;
    TextView txtUserEmail;
    TextView txtUserBirthDate;
    CircularImageView imgUserProfileImage;
    VRSRobotoTextView txtAppsCount;
    VRSRobotoTextView txtCommentsCount;
    VRSRobotoTextView txtLikesCount;
    ViewPager viewPager;
    ProfilePagerAdapter mAdapter;
    LinearLayout llTop;
    private TabHost mTabHost;
    private Toolbar mToolBar;
    private FyreonWidget mFyreonWidgetListener;

    // Method to add a TabHost
    private static void AddTab(UserProfileActivity activity, TabHost tabHost, TabHost.TabSpec tabSpec) {
        tabSpec.setContent(new ProfileTabFactory(activity));
        tabHost.addTab(tabSpec);
    }

    public static void callFacebookLogout(Context context) {
        Session session = Session.getActiveSession();
        if (session != null) {

            if (!session.isClosed()) {
                session.closeAndClearTokenInformation();
                //clear your preferences if saved
            }
        } else {

            session = new Session(context);
            Session.setActiveSession(session);
            session.closeAndClearTokenInformation();
            //clear your preferences if saved

        }

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.user_profile_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) { // Handle item selection
        int i = item.getItemId();
        if (i == R.id.logout) {
            Log.d(LOG_TAG, "Logout Button Click");
            logout();
            return true;
        } else if (i == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
       /* FadingActionBarHelper helper = new FadingActionBarHelper()
                .actionBarBackground(R.drawable.abc_ab_share_pack_holo_dark)
                .headerLayout(R.layout.header)
                .contentLayout(R.layout.activity_user_profile);
        setContentView(helper.createView(this));
        helper.initActionBar(this);*/

        setContentView(R.layout.activity_user_profile);
        mToolBar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(mToolBar);

        initViews();
        txtUserProfileName.setText(mSharedPreferences.getString(AppConstants.PREF_USER_NAME, ""));
        Picasso.with(UserProfileActivity.this).load(mSharedPreferences.getString(AppConstants.PREF_USER_PROFILE_IMAGE, "")).into(imgUserProfileImage);
        String socialId = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "");
        String socialTypes = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, "");
        getUserProfile(socialId, socialTypes);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : logout
     * Description : In this method implement logout functionality.
     * Date of Creation : 2/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Bhadresh      Create full method
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.koushikdutta.ion.Ion
     */
    private void logout() {
        SharedPreferences.Editor e = mSharedPreferences.edit();
        e.putBoolean(AppConstants.PREF_IS_LOGIN, false);
        e.commit();
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false)) {
            callFacebookLogout(this);
        }
        if (mSharedPreferences.getBoolean(AppConstants.IS_TWITTER_INTEGRATED, false)) {
            CookieSyncManager.createInstance(this);
            android.webkit.CookieManager cookieManager = android.webkit.CookieManager.getInstance();
            cookieManager.removeSessionCookie();
        }
        if (mFyreonWidgetListener != null) {
            mFyreonWidgetListener.onLogoutSuccess();
        }
        finish();
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : initViews
     * Description : Initialize UI components
     * Date of Creation : 15/04/15
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 15/04/15    Bhadresh       Created full Method
     * <p/>
     * -----------------------------------------------------------------------------------
     */
    private void initViews() {
        llTop = (LinearLayout) findViewById(R.id.activity_user_profile_ll_top);
        txtUserProfileName = (TextView) findViewById(R.id.activity_user_profile_txt_username);
        imgUserProfileImage = (CircularImageView) findViewById(R.id.activity_user_profile_img_profile_image);
        txtUserEmail = (VRSRobotoTextView) findViewById(R.id.activity_user_profile_txt_email);
        txtAppsCount = (VRSRobotoTextView) findViewById(R.id.activity_user_profile_txt_apps_count);
        txtCommentsCount = (VRSRobotoTextView) findViewById(R.id.activity_user_profile_txt_comments_count);
        txtLikesCount = (VRSRobotoTextView) findViewById(R.id.activity_user_profile_txt_likes_count);
        mSharedPreferences = getSharedPreferences(AppConstants.PREF_NAME, 0);
        mFyreonWidgetListener = new FyreonWidget(UserProfileActivity.this);
        viewPager = (ViewPager) findViewById(R.id.activity_user_profile_pager);
        viewPager.setOnPageChangeListener(this);
        initialiseTabHost();
        List<Fragment> fragments = getFragments();
        mAdapter = new ProfilePagerAdapter(getSupportFragmentManager(), fragments);
        viewPager.setAdapter(mAdapter);
        getSupportActionBar().setTitle(mSharedPreferences.getString(AppConstants.PREF_USER_NAME, ""));
        getSupportActionBar().setHomeButtonEnabled(true);

    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getUserProfile
     * Description : Fetch user profile data from  server
     * Date of Creation : 15/04/15
     *
     * @param socialId
     * @param socialTypes -------------------------------------------------------------------------------------
     *                    Update Log:
     *                    Date:		By:		Details:
     *                    15/04/15    Bhadresh       Created full Method
     *                    -----------------------------------------------------------------------------------
     */
    private void getUserProfile(String socialId, String socialTypes) {
        Log.d(LOG_TAG, "Social ID :" + socialId);
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("social_id", socialId);
        jsonParams.addProperty("social_type", socialTypes);
        Ion.with(this)
                .load(AppConstants.URL_GET_USER_PROFILE)
                .setJsonObjectBody(jsonParams)
                .asString()
                .withResponse()
                .setCallback(new FutureCallback<com.koushikdutta.ion.Response<String>>() {
                    @Override
                    public void onCompleted(Exception e, Response<String> result) {

                        if (e == null) {
                            Log.d(LOG_TAG, "Result Code : " + result.getHeaders().code() + "");
                            Log.d(LOG_TAG, "Result String : " + result.getResult());
                            if (result != null) {
                                String responseCode = String.valueOf(result.getHeaders().code());
                                if (responseCode.equals(AppConstants.STATUS_CODE_SUCCESS)) {
                                    Log.d(LOG_TAG, "Success : " + result.getResult());
                                    JsonParser parser = new JsonParser();
                                    JsonElement profileElement = parser.parse(result.getResult());
                                    JsonObject profileObject = profileElement.getAsJsonObject();

                                    String userName = profileObject.get("user_name").getAsString();
                                    String userImage = profileObject.get("user_image").getAsString();
                                    String userEmail = profileObject.get("user_email").getAsString();
                                    String userBDate = profileObject.get("user_bdate").getAsString();
                                    String userApps = profileObject.get("user_apps").getAsString();
                                    String userLikes = profileObject.get("user_likes").getAsString();
                                    String userComments = profileObject.get("user_comments").getAsString();

                                    txtUserProfileName.setText(userName);
                                    Picasso.with(UserProfileActivity.this).load(userImage).into(imgUserProfileImage);
                                  /*  Picasso.with(UserProfileActivity.this).load(userImage).into(new Target() {
                                        @Override
                                        public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                                            BitmapDrawable background = new BitmapDrawable(bitmap);
                                            llTop.setBackgroundDrawable(background);
                                        }

                                        @Override
                                        public void onBitmapFailed(Drawable errorDrawable) {

                                        }

                                        @Override
                                        public void onPrepareLoad(Drawable placeHolderDrawable) {

                                        }
                                    });*/
                                    txtAppsCount.setText(userApps);
                                    txtCommentsCount.setText(userComments);
                                    txtLikesCount.setText(userLikes);
                                    if (!userEmail.equals("")) {
                                        txtUserEmail.setText(userEmail);
                                    }
                                } else if (responseCode.equals(AppConstants.STATUS_CODE_FAILURE)) {
                                    Log.d(LOG_TAG, "Failure : " + result.getResult());
                                }
                            }
                        } else {
                            Log.d(LOG_TAG, "Exception : " + e.getMessage());
                        }
                    }
                });
    }

    private void loadUserData() {
        String SOCIAL_ID = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "");
        String SOCIAL_TYPE = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, "");
        Log.d(LOG_TAG, "Social ID :" + SOCIAL_ID);

        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("social_id", SOCIAL_ID);
        jsonParams.addProperty("social_type", SOCIAL_TYPE);
        Ion.with(this)
                .load(AppConstants.URL_GET_USER_PROFILE)
                .setJsonObjectBody(jsonParams)
                .asString()
                .withResponse()
                .setCallback(new FutureCallback<Response<String>>() {
                    @Override
                    public void onCompleted(Exception e, Response<String> result) {
                        if (result == null) {

                            String responseCode = String.valueOf(result.getHeaders().code());
                            if (responseCode.equals(AppConstants.STATUS_CODE_SUCCESS)) {

                            } else if (responseCode.equals(AppConstants.STATUS_CODE_FAILURE)) {
                                Toast.makeText(UserProfileActivity.this, "Fail to get User data!", Toast.LENGTH_LONG).show();
                            }
                        }
                    }
                });
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getFragments
     * Description : Add fragment in tab list
     * Date of Creation : 15/04/15
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:       By:            Details:
     * 15/04/15    Bhadresh       Created full Method
     * -----------------------------------------------------------------------------------
     */
    private List<Fragment> getFragments() {
        /*UserCommentsFragment fragment = new UserCommentsFragment();
        Bundle b = new Bundle();
        fragment.setArguments(b);*/
        // adb push /home/vrsuser/Desktop/Backup/Working Projects Resource/VOIP Sinch/
        List<Fragment> fList = new ArrayList<Fragment>();
        fList.add(new UserAppsFragment());
        fList.add(new UserCommentsFragment());
        fList.add(new UserLikesFragment());
        return fList;
    }

    // Tabs Creation
    private void initialiseTabHost() {
        mTabHost = (TabHost) findViewById(android.R.id.tabhost);
        mTabHost.setup();

        // UserProfileActivity.AddTab(this,this.mTabHost,this.mTabHost.newTabSpec("Tab0").setIndicator("Devs"));
        UserProfileActivity.AddTab(this, this.mTabHost, this.mTabHost.newTabSpec("Tab1").setIndicator("Apps"));
        UserProfileActivity.AddTab(this, this.mTabHost, this.mTabHost.newTabSpec("Tab2").setIndicator("Comments"));
        UserProfileActivity.AddTab(this, this.mTabHost, this.mTabHost.newTabSpec("Tab3").setIndicator("Likes"));
        mTabHost.setOnTabChangedListener(this);

        for (int i = 0; i < mTabHost.getTabWidget().getChildCount(); i++) {
            mTabHost.getTabWidget().getChildAt(i).setBackgroundColor(Color.parseColor("#ffffff")); // unselected
            TextView tv = (TextView) mTabHost.getTabWidget().getChildAt(i).findViewById(android.R.id.title); //Unselected Tabs
            tv.setTextColor(Color.parseColor("#993B398C"));
        }

        mTabHost.getTabWidget().getChildAt(mTabHost.getCurrentTab()).setBackgroundColor(Color.parseColor("#ffffff")); // selected
        TextView tv = (TextView) mTabHost.getCurrentTabView().findViewById(android.R.id.title); //for Selected Tab
        tv.setTextColor(Color.parseColor("#3B398C"));
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        int pos = this.viewPager.getCurrentItem();
        this.mTabHost.setCurrentTab(pos);
    }

    @Override
    public void onPageSelected(int position) {

    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }

    @Override
    public void onTabChanged(String s) {
        int pos = this.mTabHost.getCurrentTab();
        this.viewPager.setCurrentItem(pos);
        for (int i = 0; i < mTabHost.getTabWidget().getChildCount(); i++) {
            mTabHost.getTabWidget().getChildAt(i).setBackgroundColor(Color.parseColor("#ffffff")); // unselected
            TextView tv = (TextView) mTabHost.getTabWidget().getChildAt(i).findViewById(android.R.id.title); //Unselected Tabs
            tv.setTextColor(Color.parseColor("#993B398C"));
        }

        mTabHost.getTabWidget().getChildAt(mTabHost.getCurrentTab()).setBackgroundColor(Color.parseColor("#ffffff")); // selected
        TextView tv = (TextView) mTabHost.getCurrentTabView().findViewById(android.R.id.title); //for Selected Tab
        tv.setTextColor(Color.parseColor("#3B398C"));

    }

    /**
     * ---------------------------------------------------------------------------------
     * Interface Name : LogoutInterface
     * Description : LogoutInterface is listen when login out.
     * Date of Creation : 25/02/15
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 30/3/15    Bhadresh    Create new interface
     * -----------------------------------------------------------------------------------
     */
    public interface LogoutInterface {
        void onLogoutSuccess();

        void onLogoutFailure();
    }
}