package com.vrs.android.fyreon.widgets.emoji;

import android.content.Context;
import android.widget.GridView;

import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.EmojiAdapter;
import com.vrs.android.fyreon.dialogs.EmojIconsPopup;
import com.vrs.android.fyreon.interfaces.EmojiconRecents;
import com.vrs.android.fyreon.model.EmojiconRecentsManager;
import com.vrs.android.fyreon.utils.emoji.Emojicon;


/**
 * @author vrsuser
 */
public class EmojiconRecentsGridView extends EmojiconGridView implements EmojiconRecents {
    EmojiAdapter mAdapter;

    public EmojiconRecentsGridView(Context context, Emojicon[] emojicons,
                                   EmojiconRecents recents, EmojIconsPopup emojiconsPopup) {
        super(context, emojicons, recents, emojiconsPopup);
        EmojiconRecentsManager recents1 = EmojiconRecentsManager
                .getInstance(rootView.getContext());
        mAdapter = new EmojiAdapter(rootView.getContext(), recents1);
        mAdapter.setEmojiClickListener(new OnEmojiconClickedListener() {

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                if (mEmojiconPopup.onEmojiconClickedListener != null) {
                    mEmojiconPopup.onEmojiconClickedListener.onEmojiconClicked(emojicon);
                }
            }
        });
        GridView gridView = (GridView) rootView.findViewById(R.id.Emoji_GridView);
        gridView.setAdapter(mAdapter);
    }

    @Override
    public void addRecentEmoji(Context context, Emojicon emojicon) {
        EmojiconRecentsManager recents = EmojiconRecentsManager
                .getInstance(context);
        recents.push(emojicon);

        // notify dataset changed
        if (mAdapter != null)
            mAdapter.notifyDataSetChanged();
    }

}
