package com.vrs.android.fyreon.adapters;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;
import com.vrs.android.fyreon.widgets.VRSRobotoTextView;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Package Name : com.vrs.android.fyreon.adapters
 * Created by vrsuser on 15/4/15.
 * Time : 12:34 PM
 * Project : fyreon-library-android
 * Modified : 15 12 34
 */
public class CommentListAdapter extends ArrayAdapter<CommentListModel> {

    static final String LOG_TAG = CommentListAdapter.class.getSimpleName();
    private static final Logger logger = new Logger(true, LOG_TAG);
    List<CommentListModel> dataList = new ArrayList<CommentListModel>();
    Context mContext;
    LayoutInflater mInflater = null;
    SharedPreferences mSharedPref;
    DisplayImageOptions displayOptions;

    public CommentListAdapter(Context context, int resource, List<CommentListModel> objects) {
        super(context, resource, objects);
        this.mContext = context;
        this.dataList = objects;
        mSharedPref = context.getSharedPreferences(AppConstants.PREF_NAME, Context.MODE_PRIVATE);
        displayOptions = new DisplayImageOptions.Builder().showImageOnLoading(R.drawable.default_user_icon).showImageForEmptyUri(R.drawable.default_user_icon).showImageOnFail(R.drawable.default_user_icon).cacheInMemory(true).cacheOnDisk(true).build();
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        // TODO Auto-generated method stub
        ViewHolder holder = new ViewHolder();
        View layoutView = convertView;
        if (layoutView == null) {
            mInflater = (LayoutInflater) mContext
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            layoutView = mInflater.inflate(R.layout.list_item_activity_comment, null, false);
            holder.ivProfileIcon = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_profile);
            holder.txtName = (VRSRobotoTextView) layoutView.findViewById(R.id.comment_list_item_txt_name);
            holder.txtDate = (VRSRobotoTextView) layoutView
                    .findViewById(R.id.comment_list_item_txt_date);
            holder.txtComment = (VRSRobotoTextView) layoutView
                    .findViewById(R.id.comment_list_item_txt_comment);
            holder.ivFavoriteItem = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_favorite);
            holder.llFavoriteLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_favorite);
            holder.llCommentLayout = (LinearLayout) layoutView.findViewById(R.id.fragment_comment_ll_comment);
            holder.txtFavoriteCount = (VRSRobotoTextView) layoutView.findViewById(R.id.comment_list_item_txt_favorite_count);
            holder.txtCommentCount = (VRSRobotoTextView) layoutView.findViewById(R.id.comment_list_item_txt_comment_count);
            holder.ivSocialIcon = (ImageView) layoutView.findViewById(R.id.comment_list_item_iv_social_icon);
            layoutView.setTag(holder);
        } else {
            holder = (ViewHolder) layoutView.getTag();
        }

        final CommentListModel commentDataList = dataList.get(position);
        holder.txtName.setText(commentDataList.getName());
        holder.llFavoriteLayout.setTag(holder);


        if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
//            Picasso.with(mContext)
//                    .load("https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large")
//                    .placeholder(R.drawable.default_user_icon)
//                    .into(holder.ivProfileIcon);
            holder.ivSocialIcon.setImageResource(R.drawable.facebook);
            ImageLoader.getInstance().displayImage("https://graph.facebook.com/" +
                            commentDataList.getSocial_id() + "/picture?type=large", holder.ivProfileIcon,
                    displayOptions);

            logger.debug(LOG_TAG, "profile Image URL : " + "https://graph.facebook.com/" + commentDataList.getSocial_id() + "/picture?type=large");
        } else if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_TWITTER)) {
            if (commentDataList.getIcons().equalsIgnoreCase("")) {
            } else {
                logger.debug("Picasso", "Image Path " + commentDataList.getIcons());
                holder.ivSocialIcon.setImageResource(R.drawable.twitter_social_ic);
//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                        .ivProfileIcon, displayOptions);
                logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
            }
        } else if (commentDataList.getSocial_types().equals(AppConstants.SOCIAL_TYPES_GPLUS)) {
            if (commentDataList.getIcons().equalsIgnoreCase("")) {
            } else {
                logger.debug("Picasso", "Image Path " + commentDataList.getIcons());
                holder.ivSocialIcon.setImageResource(R.drawable.google_social_ic);
//                Picasso.with(mContext).load(commentDataList.getIcons()).placeholder(R.drawable.default_user_icon).into(holder.ivProfileIcon);
                ImageLoader.getInstance().displayImage(commentDataList.getIcons(), holder
                        .ivProfileIcon, displayOptions);
                logger.debug(LOG_TAG, "profile Image URL : " + commentDataList.getIcons());
            }
        }

        logger.debug(LOG_TAG, "Date :" + commentDataList.getTime());

        holder.txtDate.setText(AppConstants.getTimeTwitter(Long.parseLong(commentDataList.getTime())));

//        SimpleDateFormat gmtDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy a");
//        gmtDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
//        String timeStampDate = AppConstants.getDateCurrentTimeZone(Long.parseLong(feedItem.getTime()));

//        logger.debug(LOG_TAG, "Time Stamp Date :" + timeStampDate);

//        try {
//            Date date = gmtDateFormat.parse(timeStampDate);
//            commentListRowHolder.txtDate.setText(TimeUtils.getTWTimeString(date));
//        } catch (ParseException e) {
//            e.printStackTrace();
//        }

//        PrettyTime p = new PrettyTime(Locale.getDefault());
//        commentListRowHolder.txtDate.setText(p.format(new Date(feedItem.getTime())));

        //Current Date Time in GMT
//        System.out.println("Current Date and Time in GMT time zone: " + gmtDateFormat.format(new Date()));


        // This will convert timestamps to hours ago.
//        2015-03-25 05:01:55
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
//        Date date1, date2;
//        try {
//            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
//            long timeStamp = sdf.parse(feedItem.getTime()).getTime();
//            date1 = simpleDateFormat.parse(AppConstants.getDateCurrentTimeZone(timeStamp));
//            date2 = simpleDateFormat.parse(AppConstants.getDateCurrentTimeZone(System.currentTimeMillis() / 1000));
//
//            //in milliseconds
//            long diff = date2.getTime() - date1.getTime();
//
//            long diffSeconds = diff / 1000 % 60;
//            long diffMinutes = diff / (60 * 1000) % 60;
//            long diffHours = diff / (60 * 60 * 1000) % 24;
//            long diffDays = diff / (24 * 60 * 60 * 1000);
//
//            logger.debug("D", diffDays + " days, ");
//            logger.debug("D", diffHours + " hours, ");
//            logger.debug("D", diffMinutes + " minutes, ");
//            logger.debug("D", diffSeconds + " seconds.");
//
//            if (diffDays != 0) {
//                if (diffDays >= 30) {
//                    mDayCounter++;
//                    commentListRowHolder.txtDate.setText(mDayCounter + " Month ago");
//                } else {
//                    if (diffDays == 1) {
//                        commentListRowHolder.txtDate.setText(diffDays + " Day ago");
//                    } else {
//                        commentListRowHolder.txtDate.setText(diffDays + " Days ago");
//                    }
//                }
//            } else {
//                if (diffHours != 0) {
//                    commentListRowHolder.txtDate.setText(diffHours + " Hours ago");
//                } else {
//                    if (diffMinutes != 0) {
//                        commentListRowHolder.txtDate.setText(diffMinutes + " Min ago");
//                    } else {
//                        commentListRowHolder.txtDate.setText(diffSeconds + " Seconds ago");
//                    }
//                }
//            }
//
//        } catch (ParseException e) {
//            e.printStackTrace();
//            logger.error(LOG_TAG, e + "");
//        }


        // This will set Comments in listview
        holder.txtComment.setText(commentDataList.getComment());
        if (commentDataList.getLiked_by() != null) {
            holder.txtFavoriteCount.setText(String.valueOf(commentDataList.getLiked_by().size()));
        } else {
            holder.txtFavoriteCount.setText(commentDataList.getLikes_count());
        }
        if (commentDataList.getReplies() != null) {
            holder.txtCommentCount.setText(String.valueOf(commentDataList.getReplies()));
        } else {
            holder.txtCommentCount.setText("0");
        }


        if (commentDataList.getLiked_id() != null) {
            if (commentDataList.getLiked_id().equalsIgnoreCase(mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, ""))) {
                if (commentDataList.getLiked().equalsIgnoreCase("1")) {
                    holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                    holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                } else {
                    holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                    holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                }
            } else {
                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
            }
        }

//        logger.debug(LOG_TAG, "Json Comment Like ID :" +)
        logger.debug(LOG_TAG, "Social id Size is less then < 0 " + position);
        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));

        if (commentDataList.getLiked_by() != null) {
            if (commentDataList.getLiked_by().size() > 0) {
                for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                    logger.debug(LOG_TAG, "Current Checking ID :" + commentDataList.getLiked_by().get(j));
                    logger.debug(LOG_TAG, "Pref Social ID :" + mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, ""));
                    if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                        logger.debug(LOG_TAG, "Social id Matched on " + position);
                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                    } else {
                        logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                    }
                }
            }
        }

        holder.llFavoriteLayout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isLogin()) {
                    int liked = 0;
                    ViewHolder holder = (ViewHolder) v.getTag();
                    if (v.getId() == holder.llFavoriteLayout.getId()) {
                        CommentListModel feedItem = dataList.get(position);
                        logger.debug(LOG_TAG, position + "");
                        logger.debug(LOG_TAG, feedItem.getComment() + "");

                        if (commentDataList.getLiked_by() != null) {
                            if (commentDataList.getLiked_by().size() > 0) {
                                for (int j = 0; j < commentDataList.getLiked_by().size(); j++) {
                                    if (commentDataList.getLiked_by().get(j).trim().equalsIgnoreCase(mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, "").trim())) {
                                        logger.debug(LOG_TAG, "Social id Matched on " + position);
                                        liked = 0;
                                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                                    } else {
                                        liked = 1;
                                        logger.debug(LOG_TAG, "Social id Not Matched on " + position);
                                        holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                                        holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                                    }
                                }
                            } else {
                                holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                                holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                                liked = 1;
                            }
                        } else {
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
                            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
                            liked = 1;
                        }
                        logger.debug(LOG_TAG, "Liked : " + liked);
                        postLike(feedItem.getComment_id(), mSharedPref.getString(AppConstants.PREF_SOCIAL_ID, ""), mSharedPref.getString(AppConstants.PREF_SOCIAL_TYPE, ""), liked, position, v);
                    }
                } else {
                    Toast.makeText(mContext, "You need to be logged in order to favorite the comment!", Toast.LENGTH_LONG).show();
                }
            }
        });

        return layoutView;
    }

    private void postLike(String CommentID, final String SocialID, String Social_Type, final int like, final int position, View holderView) {

        final CommentListModel model = dataList.get(position);
        final ViewHolder holder = (ViewHolder) holderView.getTag();
        if (like == 1) {
            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_on_default));
            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.amber_color_primary));
        } else {
            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
        }
        final JsonObject commentRequestObject = new JsonObject();
        commentRequestObject.addProperty("comment_id", CommentID);
        commentRequestObject.addProperty("social_id", SocialID);
        commentRequestObject.addProperty("social_type", Social_Type);
        commentRequestObject.addProperty("like", like);
        logger.debug(LOG_TAG, "Json Request Body : " + commentRequestObject.toString());

        OkHttpClientUtil.getInstance().initialize(getContext());
        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_COMMENT_LIKE, commentRequestObject
                    .toString(), new Callback() {
                Handler mainHandler = new Handler(mContext.getMainLooper());

                @Override
                public void onFailure(Request request, IOException e) {
                    logger.error(LOG_TAG, "Failed to like Comment!");
                    mainHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(getContext(), getContext().getString(R.string
                                    .network_error), Toast.LENGTH_LONG).show();
                            holder.ivFavoriteItem.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_action_fave_off_default));
                            holder.txtFavoriteCount.setTextColor(mContext.getResources().getColor(R.color.background_floating_material_dark));
                        }
                    });

                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == 200) {
                        response.cacheResponse();

                        final String resBody = response.body().string();
                        mainHandler.post(new Runnable() {
                            @Override
                            public void run() {

                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(resBody);
                                JsonObject result = commentsElement.getAsJsonObject();
                                model.setLiked_id(result.get("comment_id").getAsString());
                                model.setLiked(result.get("like").getAsString());
                                holder.txtFavoriteCount.setText(String.valueOf(result.get("like_count").getAsInt()));

                                if (like == 1) {
//                        logger.debug(LOG_TAG, "Before new Comment ID :" + model.getLiked_by().get(position));
//                        logger.debug(LOG_TAG, "Before new Comment ID :" + model.getLiked_by().size());
                                    ArrayList<String> comment = model.getLiked_by();
                                    comment.add(SocialID);
                                    model.setLiked_by(comment);

//                        notifyDataSetChanged();
//                        logger.debug(LOG_TAG, "Added new Comment ID :" + model.getLiked_by().get(position));
//                        logger.debug(LOG_TAG, "Added new Comment ID :" + model.getLiked_by().size());
                                } else {
                                    ArrayList<String> comment = model.getLiked_by();
                                    comment.remove(SocialID);
                                    model.setLiked_by(comment);
                                }
                            }
                        });
                    } else {
                        logger.error(LOG_TAG, "Unidentified Response Code " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : isLogin
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     *
     * @return boolean isLoggedIn
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private boolean isLogin() {
        boolean isLoggedIn = mSharedPref.getBoolean(AppConstants.PREF_IS_LOGIN, false);
        return isLoggedIn;
    }

    private class ViewHolder {
        public VRSRobotoTextView txtName, txtDate, txtComment, txtFavoriteCount, txtCommentCount;
        public ImageView ivProfileIcon, ivFavoriteItem, ivSocialIcon;
        public LinearLayout llFavoriteLayout, llCommentLayout;
    }
}
