/**
 * ---------------------------------------------------------------------------------
 * File Name : CommentFragment.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */

package com.vrs.android.fyreon.fragments;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Base64;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.Toast;

import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.model.GraphObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.squareup.okhttp.Callback;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.CommentListAdapter;
import com.vrs.android.fyreon.database.DatabaseResult;
import com.vrs.android.fyreon.dialogs.EmojIconsPopup;
import com.vrs.android.fyreon.handlers.ExceptionHandler;
import com.vrs.android.fyreon.interfaces.RetryListener;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.model.ResultModel;
import com.vrs.android.fyreon.ui.CommentDetailActivity;
import com.vrs.android.fyreon.ui.SocialLoginActivity;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.emoji.Emojicon;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;
import com.vrs.android.fyreon.widgets.CircularImageView;
import com.vrs.android.fyreon.widgets.ErrorView;
import com.vrs.android.fyreon.widgets.emoji.EmojiconEditText;
import com.vrs.android.fyreon.widgets.emoji.EmojiconGridView;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;


/**
 * ---------------------------------------------------------------------------------
 * Class Name : CommentFragment
 * Description : CommentFragment class contain user comment list..
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 * @see android.support.v4.app.Fragment
 * @see android.view.View.OnClickListener
 * @see com.vrs.android.fyreon.fragments.MainFragment.pageChangeListener
 */
public class CommentFragment extends Fragment implements View.OnClickListener, MainFragment.pageChangeListener, TextWatcher, SwipeRefreshLayout.OnRefreshListener {

    private static final String LOG_TAG = CommentFragment.class.getSimpleName();
    private static final Logger logger = new Logger(false, LOG_TAG);
    private static final String PREF_IS_LOGIN = "is_login";
    private static String mCommentCategory = "";

    //Facebook
    private static SharedPreferences mSharedPreferences;
    private static CommentFragment mCommentObject;

    // XML Widget holders

    EmojIconsPopup popup;
    private ListView lvCommentList;
    private SwipeRefreshLayout swRefreshLayout;
    private CommentListAdapter mCommentListAdapter;
    private ImageButton ivComposeButton;
    private EmojiconEditText etMessageBox;
    private LinearLayout llMessageLayout;
    private LinearLayout llProgressLayout;
    private CircularImageView imgUserProfileImage;
    private ImageButton ivEmojiButton;
    private ErrorView mErrorView;

    // private FrameLayout flEmojiContainer;
    private LinearLayout mainView;
    private LinearLayout llMessageMainStrip;
    private LinearLayout llListViewLayout;
    private LinearLayout llErrorLayout;
    private LinearLayout llMainProgressLayout;


    // private member Variables
    private ArrayList<CommentListModel> mCommentArrayList;
    private DatabaseResult mDBManager;
    private HashKey mHaskGen;


    /**
     * ---------------------------------------------------------------------------------
     * Method Name : init
     * Description : This method is used to Initialize Fragment in ViewPager as we Don't use the dynamic Fragments.
     * Date of Creation : 25/02/15
     *
     * @param val This parameter takes position in pager
     * @return CommentFragment
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public static CommentFragment init(int val) {
        mCommentObject = new CommentFragment();
        // Supply val input as an argument.
        Bundle args = new Bundle();
        args.putInt("val", val);
        mCommentObject.setArguments(args);
        return mCommentObject;
    }


    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_comment, container, false);

        mSharedPreferences = getActivity().getSharedPreferences(AppConstants.PREF_NAME, 0);
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(
                getActivity()));
        AppConstants.isCreateDatabase = true;
        AppConstants.setData(getActivity(), true, this.getActivity().getPackageName());
        mDBManager = new DatabaseResult(getActivity());
        initView(rootView);

        // Enable global Ion logging
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            mCommentCategory = bundle.getString(AppConstants.WIDGET_CATEGORY, "");
            logger.debug(LOG_TAG, "Category : " + mCommentCategory);
        }

        llMainProgressLayout.setVisibility(View.VISIBLE);
        llListViewLayout.setVisibility(View.GONE);
        showCachedData();
        mHaskGen = HashKey.COMMENT_HASH;
        return rootView;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

    }

    @Override
    public void onPageChanged() {
        logger.debug(LOG_TAG, "Page Change Called");
    }

    @Override
    public void onClick(View view) {
        if (view == ivComposeButton) {
            if (isLogin()) {
                if (etMessageBox.length() > 140) {
                    Toast.makeText(getActivity(), "You can not post more than 140 Characters in comment.", Toast.LENGTH_LONG).show();
                } else {
                    if (etMessageBox.length() <= 0) {
                        Toast.makeText(getActivity(), "You can not post blank comment", Toast.LENGTH_LONG).show();
                    } else {

                        if (etMessageBox.getText().toString().trim().equalsIgnoreCase("")) {
                            Toast.makeText(getActivity(), "You can not post blank comment", Toast.LENGTH_LONG).show();
                        } else {
                            if (AppConstants.isNetworkAvailable(getActivity())) {
                                addComment();
                            } else {
                                Toast.makeText(getActivity(), "No Internet Connection Avaliable!",
                                        Toast.LENGTH_LONG).show();
                            }
                            logger.debug(LOG_TAG, "Message sended successfully");
                        }
                    }
                }
            } else {
                // Start Login Activity From Here.
                Intent loginIntent = new Intent(getActivity(), SocialLoginActivity.class);
                getActivity().startActivity(loginIntent);
            }
        } else if (view == ivEmojiButton) {
        }

    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : initView
     * Description : This method binds all Layout view to objects.
     * Date of Creation : 25/02/15
     *
     * @param rootView is layoutView / Parent View
     *                 <p/>
     *                 -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan       Create full class
     *                 24/3/15    Bhadresh    Refactor code as per coding standard.
     *                 -----------------------------------------------------------------------------------
     */
    private void initView(View rootView) {
        lvCommentList = (ListView) rootView.findViewById(R.id.fragment_comment_lv_comment);
        swRefreshLayout = (SwipeRefreshLayout) rootView.findViewById(R.id.fragment_comment_swipe_layout);
        ivComposeButton = (ImageButton) rootView.findViewById(R.id.fragment_comment_ibtn_compose);
        etMessageBox = (EmojiconEditText) rootView.findViewById(R.id.fragment_comment_et_message);
        llMessageLayout = (LinearLayout) rootView.findViewById(R.id.fragment_comment_ll_mesaage);
        llProgressLayout = (LinearLayout) rootView.findViewById(R.id.fragment_comment_ll_progress);
        ivEmojiButton = (ImageButton) rootView.findViewById(R.id.fragment_comment_ibtn_emoji);
        mErrorView = (ErrorView) rootView.findViewById(R.id.error_view);
        llListViewLayout = (LinearLayout) rootView.findViewById(R.id.fragment_comment_ll_bottom);
        llErrorLayout = (LinearLayout) rootView.findViewById(R.id.ll_main_error_layout);
        //  flEmojiContainer = (FrameLayout) rootView.findViewById(R.id.emojicons);
        mainView = (LinearLayout) rootView.findViewById(R.id.root_view);
        llMessageMainStrip = (LinearLayout) rootView.findViewById(R.id.fragment_ll_msg);
        llMainProgressLayout = (LinearLayout) rootView.findViewById(R.id.ll_main_progress_layout);

        mCommentArrayList = new ArrayList<CommentListModel>();

        mCommentListAdapter = new CommentListAdapter(getActivity(), R.layout.list_item_activity_comment, mCommentArrayList);
        lvCommentList.setAdapter(mCommentListAdapter);

        lvCommentList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {

                if (AppConstants.isNetworkAvailable(getActivity())) {
                    Intent startIntent = new Intent(getActivity(), CommentDetailActivity.class);
                    startIntent.putExtra(AppConstants.COMMENT_ID, mCommentArrayList.get(position).getComment_id());
                    startIntent.putExtra(AppConstants.COMMENT_PARENT_ID, mCommentArrayList.get(position).getParent_id());
                    startIntent.putExtra(AppConstants.COMMENT_SCREEN_KEY, mCommentArrayList.get(position).getScreen_id());
                    startIntent.putExtra(AppConstants.COMMENT_SOCIAL_ID, mCommentArrayList.get(position).getSocial_id());
                    startIntent.putExtra(AppConstants.COMMENT_SOCIAL_TYPE, mCommentArrayList.get(position).getSocial_types());
                    startIntent.putExtra(AppConstants.COMMENT_CREATED, mCommentArrayList.get(position).getTime());
                    startIntent.putExtra(AppConstants.COMMENT_CONTENT, mCommentArrayList.get(position).getComment());
                    startIntent.putStringArrayListExtra(AppConstants.COMMENT_LIKES, mCommentArrayList.get(position).getLiked_by());
                    startIntent.putExtra(AppConstants.COMMENT_USER_NAME, mCommentArrayList.get(position).getName());
                    startIntent.putExtra(AppConstants.COMMENT_USER_IMAGE, mCommentArrayList.get(position).getIcons());
                    startIntent.putExtra(AppConstants.COMMENT_COMMENT_LIKES, mCommentArrayList.get(position).getLikes_count());
                    startIntent.putExtra(AppConstants.COMMENT_REPLIES, mCommentArrayList.get(position).getReplies());
                    startIntent.putExtra(AppConstants.WIDGET_CATEGORY, mCommentCategory);
                    startIntent.putExtra(AppConstants.SCREEN_NAME, getActivity().getClass().getSimpleName());
                    getActivity().startActivity(startIntent);
                } else {
                    Toast.makeText(getActivity(), getString(R.string.network_error), Toast.LENGTH_LONG)
                            .show();
                }
            }
        });

        ivComposeButton.setOnClickListener(this);
        ivEmojiButton.setOnClickListener(this);
        etMessageBox.addTextChangedListener(this);
        swRefreshLayout.setColorSchemeColors(Color.GRAY, Color.GREEN, Color.BLUE,
                Color.RED, Color.CYAN);
        swRefreshLayout.setDistanceToTriggerSync(20);// in dips
        swRefreshLayout.setSize(SwipeRefreshLayout.DEFAULT);// LARGE also can be used
        swRefreshLayout.setOnRefreshListener(this);

        imgUserProfileImage = (CircularImageView) rootView.findViewById(R.id.layout_fyreon_widget_up_btn_user_profile_image);

        // Emoji Button
        popup = new EmojIconsPopup(mainView, getActivity());

        //Will automatically set size according to the soft keyboard size
        popup.setSizeForSoftKeyboard();

        //Set on emojicon click listener
        popup.setOnEmojiconClickedListener(new EmojiconGridView.OnEmojiconClickedListener() {

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                etMessageBox.append(emojicon.getEmoji());
            }
        });

        //Set on backspace click listener
        popup.setOnEmojiconBackspaceClickedListener(new EmojIconsPopup.OnEmojiconBackspaceClickedListener() {

            @Override
            public void onEmojiconBackspaceClicked(View v) {
                KeyEvent event = new KeyEvent(
                        0, 0, 0, KeyEvent.KEYCODE_DEL, 0, 0, 0, 0, KeyEvent.KEYCODE_ENDCALL);
                etMessageBox.dispatchKeyEvent(event);
            }
        });

        //If the emoji popup is dismissed, change emojiButton to smiley icon
        popup.setOnDismissListener(new PopupWindow.OnDismissListener() {

            @Override
            public void onDismiss() {
                changeEmojiKeyboardIcon(ivEmojiButton, R.drawable.smiley);
            }
        });

        //If the text keyboard closes, also dismiss the emoji popup
        popup.setOnSoftKeyboardOpenCloseListener(new EmojIconsPopup.OnSoftKeyboardOpenCloseListener() {

            @Override
            public void onKeyboardOpen(int keyBoardHeight) {

            }

            @Override
            public void onKeyboardClose() {
                if (popup.isShowing())
                    popup.dismiss();
            }
        });

        //On emoji clicked, add it to edittext
        popup.setOnEmojiconClickedListener(new EmojiconGridView.OnEmojiconClickedListener() {

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                etMessageBox.append(emojicon.getEmoji());
            }
        });

        //On backspace clicked, emulate the KEYCODE_DEL key event
        popup.setOnEmojiconBackspaceClickedListener(new EmojIconsPopup.OnEmojiconBackspaceClickedListener() {

            @Override
            public void onEmojiconBackspaceClicked(View v) {
                KeyEvent event = new KeyEvent(
                        0, 0, 0, KeyEvent.KEYCODE_DEL, 0, 0, 0, 0, KeyEvent.KEYCODE_ENDCALL);
                etMessageBox.dispatchKeyEvent(event);
            }
        });

        // To toggle between text keyboard and emoji keyboard keyboard(Popup)
        ivEmojiButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

                //If popup is not showing => emoji keyboard is not visible, we need to show it
                if (!popup.isShowing()) {

                    //If keyboard is visible, simply show the emoji popup
                    if (popup.isKeyBoardOpen()) {
                        popup.showAtBottom();
                        changeEmojiKeyboardIcon(ivEmojiButton, R.drawable.ic_action_keyboard);
                    }

                    //else, open the text keyboard first and immediately after that show the emoji popup
                    else {
                        etMessageBox.setFocusableInTouchMode(true);
                        etMessageBox.requestFocus();
                        popup.showAtBottomPending();
                        final InputMethodManager inputMethodManager = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
                        inputMethodManager.showSoftInput(etMessageBox, InputMethodManager.SHOW_IMPLICIT);
                        changeEmojiKeyboardIcon(ivEmojiButton, R.drawable.ic_action_keyboard);
                    }
                }

                //If popup is showing, simply dismiss it to show the underlying text keyboard
                else {
                    popup.dismiss();
                }
            }
        });

        mErrorView.setOnRetryListener(new RetryListener() {
            @Override
            public void onRetry() {
                if (AppConstants.isNetworkAvailable(getActivity())) {
                    llMainProgressLayout.setVisibility(View.VISIBLE);
                    llListViewLayout.setVisibility(View.GONE);
                    llErrorLayout.setVisibility(View.GONE);
                    fetchComments();
                } else {
                    mErrorView.setError(111);
                    mErrorView.setErrorTitle(getString(R.string.error_no_internet));
                }
            }
        });


    }

    private void changeEmojiKeyboardIcon(ImageButton iconToBeChanged, int drawableResourceId) {
        iconToBeChanged.setImageResource(drawableResourceId);
    }

    private void showCachedData() {
        mHaskGen = HashKey.COMMENT_HASH;

        if (!AppConstants.isNetworkAvailable(getActivity())) {
            if (new File(getActivity().getCacheDir() + "/" + mHaskGen.getCode() + ".dat").exists()) {
                JsonParser parser = new JsonParser();
                JsonElement commentsElement = null;
                try {
                    commentsElement = parser.parse(new FileReader(getActivity().getCacheDir() +
                            "/" + mHaskGen.getCode() + ".dat"));
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                JsonArray result = null;
                if (commentsElement != null) {
                    result = commentsElement.getAsJsonArray();
                }
                logger.debug(LOG_TAG, result + "");
                swRefreshLayout.setRefreshing(false);
                mCommentArrayList.clear();
                lvCommentList.setVisibility(View.VISIBLE);
                if (result != null && result.size() > 0) {
                    for (int i = 0; i < result.size(); i++) {
                        JsonObject commentObject = result.get(i).getAsJsonObject();
                        logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                        String userId = commentObject.get("id").getAsString();
                        String parentId = commentObject.get("parent_id").toString();
                        String screenId = commentObject.get("screen_key").getAsString();
                        String socialId = commentObject.get("social_id").getAsString();
                        String social_types = commentObject.get("social_type").getAsString();
                        String createdTime = commentObject.get("created").getAsString();
                        String content = commentObject.get("content").getAsString();
                        String likesCount = commentObject.get("likes").getAsString();
                        String userName = commentObject.get("user_name").getAsString();
                        String userImage = commentObject.get("user_image").getAsString();
                        String category = commentObject.get("category").getAsString();
                        JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                        JsonArray replies_by_users = commentObject.get("replies").getAsJsonArray();
                        ArrayList<String> liked_users = new ArrayList<String>();
                        if (liked_by_users.size() > 0) {
                            for (int j = 0; j < liked_by_users.size(); j++) {
                                JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                boolean isLiked = res.get("like").getAsBoolean();
                                if (isLiked) {
                                    String social_id = res.get("social_id").getAsString();
                                    liked_users.add(social_id);
                                }
                            }
                        }
                        String replies = null;
                        if (replies_by_users.size() > 0) {
                            for (int j = 0; j < replies_by_users.size(); j++) {
                                replies = String.valueOf(replies_by_users.size());
                            }
                        }
                        logger.debug(LOG_TAG, "Parent ID : " + parentId);
                        logger.debug(LOG_TAG, "Parent ID : " + parentId);
                        CommentListModel commentListItem = new CommentListModel(userId, parentId, socialId, screenId, userName, createdTime, content, userImage, social_types, likesCount, liked_users, "", replies, category);
                        if (social_types.equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                            mCommentArrayList.add(commentListItem);
                            getFacebookUserInformation(socialId, i);
                        } else {
                            mCommentArrayList.add(commentListItem);
                            try {
                                getProfileDetail(socialId, social_types, i);
                            } catch (UnsupportedEncodingException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
                llMainProgressLayout.setVisibility(View.GONE);
                llListViewLayout.setVisibility(View.VISIBLE);
                if (mCommentArrayList.size() > 0) {
                    mCommentListAdapter = new CommentListAdapter(getActivity(), R.layout.list_item_activity_comment, mCommentArrayList);
                    lvCommentList.setAdapter(mCommentListAdapter);
                }
            } else {
                llErrorLayout.setVisibility(View.VISIBLE);
                llListViewLayout.setVisibility(View.GONE);
                llMainProgressLayout.setVisibility(View.GONE);
                mErrorView.setOnRetryListener(new RetryListener() {
                    @Override
                    public void onRetry() {
                        if (AppConstants.isNetworkAvailable(getActivity())) {
                            llMainProgressLayout.setVisibility(View.VISIBLE);
                            llListViewLayout.setVisibility(View.GONE);
                            llErrorLayout.setVisibility(View.GONE);
                            fetchComments();
                        } else {
                            mErrorView.setError(111);
                            mErrorView.setErrorTitle(getString(R.string.error_no_internet));
                        }
                    }
                });
            }
        } else {

            fetchComments();
        }
    }


    /**
     * ----------------------------------------------------------------------------------
     * Method Name : isLogin
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     *
     * @return boolean isLoggedIn
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private boolean isLogin() {
        boolean isLoggedIn = mSharedPreferences.getBoolean(PREF_IS_LOGIN, false);

        return isLoggedIn;
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getFacebookUserInformation
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     *
     * @param facebookID pass Facbook User ID
     * @param pos        pass position of your adapter or list data.
     *                   -------------------------------------------------------------------------------------
     *                   Update Log:
     *                   Date:		By:		Details:
     *                   <p/>
     *                   25/2/15    Rajan       Created full Method
     *                   <p/>
     *                   -----------------------------------------------------------------------------------
     */

    private void getFacebookUserInformation(String facebookID, final int pos) {
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false)) {
            if (Session.getActiveSession() != null) {

            } else {
                Session.openActiveSessionFromCache(getActivity());
            }

            String[] path = {facebookID};

            RequestBatch requestBatch = new RequestBatch(Request.newGraphPathRequest(Session.getActiveSession(), path[0], new Request.Callback() {
                @Override
                public void onCompleted(Response response) {
                    parseResponseFaceBook(response, pos);
                }
            }));

            requestBatch.executeAsync();
        }
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : parseResponseFaceBook
     * Description : Parsing response that we get from GraphObject.
     * Date of Creation : 25/02/15
     *
     * @param response pass facebook graph api response.
     * @param pos      pass position of your adapter or list data.
     *                 -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan       Created full Method
     *                 <p/>
     *                 -----------------------------------------------------------------------------------
     */


    private void parseResponseFaceBook(Response response, int pos) {

        CommentListModel drList = mCommentArrayList.get(pos);
        GraphObject graphObject = response.getGraphObject();
        if (graphObject != null) {
            drList.setName(String.format("%s", graphObject.getProperty("name")));
            mCommentListAdapter.notifyDataSetChanged();
        }
    }

    /**
     * etMessageBox text change Listener
     *
     * @param charSequence
     * @param i
     * @param i2
     * @param i3
     * @see android.text.TextWatcher
     */
    @Override
    public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

    }

    /**
     * etMessageBox text change Listener
     *
     * @param charSequence
     * @param i
     * @param i2
     * @param i3
     * @see android.text.TextWatcher
     */
    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {

    }

    /**
     * etMessageBox text change Listener
     *
     * @param editable
     * @see android.text.TextWatcher
     */
    @SuppressLint("ResourceAsColor")
    @Override
    public void afterTextChanged(Editable editable) {
        int count = AppConstants.MAX_COUNT - editable.length();
        if (count < 0) {
            etMessageBox.setTextColor(getResources().getColor(R.color.red_color_primaryDark));
        } else if (count > 0) {
            etMessageBox.setTextColor(getResources().getColor(R.color.background_floating_material_dark));
        }
    }


    /**
     * @see android.support.v4.widget.SwipeRefreshLayout.OnRefreshListener
     */
    @Override
    public void onRefresh() {
        if (AppConstants.isNetworkAvailable(getActivity())) {
            fetchComments();
        } else {
            llListViewLayout.setVisibility(View.GONE);
            mErrorView.setVisibility(View.VISIBLE);
            mErrorView.setError(111);
            mErrorView.setErrorTitle(getString(R.string.error_no_internet));
        }
    }


    /**
     * ---------------------------------------------------------------------------------
     * Class Name : addComment
     * Description : This class is used to fetch all comment from web server in background
     * thread.
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */

    private void addComment() {
        logger.debug(LOG_TAG, "Comment Category : " + mCommentCategory);
        llMessageLayout.setVisibility(View.GONE);
        llProgressLayout.setVisibility(View.VISIBLE);
        ResultModel resultModel = new ResultModel();
        mDBManager.open();
        //  List<ResultModel> mResult = mDBManager.getResults(resultModel.mAppKey, null, null);
        List<ResultModel> mResult = mDBManager.getResults(resultModel.mAppKey, new String[]{getActivity().getClass().getSimpleName()}, null);
        mDBManager.close();
        String API_KEY = mResult.get(mResult.size() - 1).mAppKey;
        String SOCIAL_ID = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "");
        String SOCIAL_TYPE = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, "");
        logger.debug(LOG_TAG, "Social ID :" + SOCIAL_ID);
        String CONTENT = etMessageBox.getText().toString().trim();
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("screen_key", API_KEY);
        jsonParams.addProperty("social_id", SOCIAL_ID);
        jsonParams.addProperty("content", CONTENT);
        jsonParams.addProperty("social_type", SOCIAL_TYPE);
        jsonParams.addProperty("parent_id", "");
        jsonParams.addProperty("category", mCommentCategory);
        logger.debug(LOG_TAG, "Add Comment Jason Body : " + jsonParams.toString());

        OkHttpClientUtil.getInstance().initialize(getActivity());

        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_ADD_COMMENT, jsonParams.toString(), new Callback() {
                @Override
                public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                    logger.error(LOG_TAG, "Error posting comment!" + e);

                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == 200) {
                        response.cacheResponse();

                        String resBody = response.body().string();
                        if (resBody != null) {
                            JsonParser parser = new JsonParser();
                            JsonElement commentsElement = parser.parse(resBody);
                            JsonObject result = commentsElement.getAsJsonObject();
                            logger.debug(LOG_TAG, "JSON ARRAY : " + result.toString());
                            if (response.code() == 200) {
                                getActivity().runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        llMessageLayout.setVisibility(View.VISIBLE);
                                        llProgressLayout.setVisibility(View.GONE);
                                        etMessageBox.setText("");
                                        Toast.makeText(getActivity(), "Message Send Successfully!", Toast.LENGTH_LONG).show();
                                        fetchComments();
                                    }
                                });
                            } else {
                                getActivity().runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        llMessageLayout.setVisibility(View.VISIBLE);
                                        llProgressLayout.setVisibility(View.GONE);
                                        Toast.makeText(getActivity(), "Message Could not be " +
                                                "sent!", Toast.LENGTH_LONG).show();
                                    }
                                });
                            }
                        }

                    } else {
                        logger.error(LOG_TAG, "Unrecognized code detected! " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }


    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : fetchComments
     * Description : This class is used to fetch all comment from web server in background
     * thread.
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */
    public void fetchComments() {
        // recycleCommentList.setVisibility(View.GONE);
        String screenKey = null;
        ResultModel resultModel = new ResultModel();
        mDBManager.open();
        List<ResultModel> mResult = mDBManager.getResults(resultModel.mAppKey, new String[]{getActivity().getClass().getSimpleName()}, null);
        mDBManager.close();
        if (mResult.size() > 0) {
            screenKey = mResult.get(mResult.size() - 1).mAppKey;
        }
        logger.debug(LOG_TAG, "Screen Key :" + screenKey);
        final JsonObject commentRequestObject = new JsonObject();
        commentRequestObject.addProperty("screen_key", screenKey);
        commentRequestObject.addProperty("category", mCommentCategory);
        if (AppConstants.isNetworkAvailable(getActivity())) {
            OkHttpClientUtil.getInstance().initialize(getActivity());
            try {
                OkHttpClientUtil.doPostRequest(AppConstants.URL_DATA, commentRequestObject.toString(),
                        new Callback() {
                            @Override
                            public void onFailure(final com.squareup.okhttp.Request request, IOException e) {
                                logger.error(LOG_TAG, "Failed to load list data!");
                                getActivity().runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        swRefreshLayout.setRefreshing(false);
                                        llMainProgressLayout.setVisibility(View.GONE);
                                        if (AppConstants.isNetworkAvailable(getActivity())) {
                                            llErrorLayout.setVisibility(View.VISIBLE);
                                            llListViewLayout.setVisibility(View.GONE);
                                            mErrorView.setError(408);
                                            mErrorView.setErrorTitle("Failed to connect to server!");


                                        } else {
                                            llErrorLayout.setVisibility(View.VISIBLE);
                                            llListViewLayout.setVisibility(View.GONE);
                                            mErrorView.setError(111);
                                            mErrorView.setErrorTitle(getString(R.string.error_no_internet));
                                        }
                                    }
                                });

                            }

                            @Override
                            public void onResponse(final com.squareup.okhttp.Response response) throws IOException {

                                if (response.code() == 200) {

                                    response.cacheResponse();

                                    final String resBody = response.body().string();

                                    getActivity().runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            llListViewLayout.setVisibility(View.VISIBLE);
                                            llMainProgressLayout.setVisibility(View.GONE);
                                            swRefreshLayout.setRefreshing(false);
                                            logger.debug(LOG_TAG, "" + resBody);
                                            JsonParser parser = new JsonParser();
                                            JsonElement commentsElement = parser.parse(resBody);
                                            JsonArray result = commentsElement.getAsJsonArray();

                                            logger.debug(LOG_TAG, result + "");
                                            mCommentArrayList.clear();
                                            lvCommentList.setVisibility(View.VISIBLE);
                                            for (int i = 0; i < result.size(); i++) {
                                                JsonObject commentObject = result.get(i).getAsJsonObject();
                                                logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                                                String userId = commentObject.get("id").getAsString();
                                                String parentId = commentObject.get("parent_id").toString();
                                                String screenId = commentObject.get("screen_key").getAsString();
                                                String socialId = commentObject.get("social_id").getAsString();
                                                String social_types = commentObject.get("social_type").getAsString();
                                                String createdTime = commentObject.get("created").getAsString();
                                                String content = commentObject.get("content").getAsString();
                                                String likesCount = commentObject.get("likes").getAsString();
                                                String userName = commentObject.get("user_name").getAsString();
                                                String userImage = commentObject.get("user_image").getAsString();
                                                String category = commentObject.get("category").getAsString();
                                                JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                                                JsonArray replies_by_users = commentObject.get("replies").getAsJsonArray();
                                                ArrayList<String> liked_users = new ArrayList<String>();
                                                if (liked_by_users.size() > 0) {
                                                    for (int j = 0; j < liked_by_users.size(); j++) {
                                                        JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                                        boolean isLiked = res.get("like").getAsBoolean();
                                                        if (isLiked) {
                                                            String social_id = res.get("social_id").getAsString();
                                                            liked_users.add(social_id);
                                                        }
                                                    }
                                                }
                                                String replies = null;
                                                if (replies_by_users.size() > 0) {
                                                    for (int j = 0; j < replies_by_users.size(); j++) {
                                                        replies = String.valueOf(replies_by_users.size());
                                                    }
                                                }
                                                logger.debug(LOG_TAG, "Parent ID : " + parentId);
                                                logger.debug(LOG_TAG, "Parent ID : " + parentId);
                                                CommentListModel commentListItem = new CommentListModel(userId, parentId, socialId, screenId, userName, createdTime, content, userImage, social_types, likesCount, liked_users, "", replies, category);
                                                if (social_types.equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                                                    mCommentArrayList.add(commentListItem);
                                                    getFacebookUserInformation(socialId, i);
                                                } else {
                                                    mCommentArrayList.add(commentListItem);
                                                    try {
                                                        getProfileDetail(socialId, social_types, i);
                                                    } catch (UnsupportedEncodingException e1) {
                                                        e1.printStackTrace();
                                                    }
                                                }
                                            }

                                            if (mCommentArrayList.size() > 0) {
                                                mCommentListAdapter = new CommentListAdapter(getActivity(), R.layout.list_item_activity_comment, mCommentArrayList);
                                                lvCommentList.setAdapter(mCommentListAdapter);
                                            }

                                            mHaskGen = HashKey.COMMENT_HASH;

                                            if (new File(getActivity().getCacheDir() + "/" +
                                                    mHaskGen.getCode() + ".dat").exists()) {
                                                new File(getActivity().getCacheDir() + "/" +
                                                        mHaskGen.getCode() + ".dat").delete();
                                            }

                                            try {
                                                AppConstants.saveResponse(new File(getActivity().getCacheDir
                                                        () + "/" + mHaskGen.getCode() + ".dat"), resBody);
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });


                                } else {
                                    logger.error(LOG_TAG, "Unrecognized CODE :" + response.code());
                                    getActivity().runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            llMainProgressLayout.setVisibility(View.GONE);
                                            swRefreshLayout.setRefreshing(false);
                                            llErrorLayout.setVisibility(View.VISIBLE);
                                            llListViewLayout.setVisibility(View.GONE);
                                            mErrorView.setError(response.code());
                                            mErrorView.setErrorTitle(AppConstants.identifyCodes
                                                    (response.code()));
                                        }
                                    });

//                                    JsonParser parser = new JsonParser();
//                                    JsonElement commentsElement = parser.parse(response.body().string());
//                                    JsonObject result = commentsElement.getAsJsonObject();
//                                    logger.debug(LOG_TAG, "Message : " + result);
                                }
                            }
                        });
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            mHaskGen = HashKey.COMMENT_HASH;

            if (new File(getActivity().getCacheDir() + "/" + mHaskGen.getCode() + ".dat").exists()) {
                JsonParser parser = new JsonParser();
                JsonElement commentsElement = null;
                try {
                    commentsElement = parser.parse(new FileReader(getActivity().getCacheDir() +
                            "/" + mHaskGen.getCode() + ".dat"));
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                JsonArray result = null;
                if (commentsElement != null) {
                    result = commentsElement.getAsJsonArray();
                }
                logger.debug(LOG_TAG, result + "");
                swRefreshLayout.setRefreshing(false);
                mCommentArrayList.clear();
                lvCommentList.setVisibility(View.VISIBLE);
                if (result != null && result.size() > 0) {
                    for (int i = 0; i < result.size(); i++) {
                        JsonObject commentObject = result.get(i).getAsJsonObject();
                        logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                        String userId = commentObject.get("id").getAsString();
                        String parentId = commentObject.get("parent_id").toString();
                        String screenId = commentObject.get("screen_key").getAsString();
                        String socialId = commentObject.get("social_id").getAsString();
                        String social_types = commentObject.get("social_type").getAsString();
                        String createdTime = commentObject.get("created").getAsString();
                        String content = commentObject.get("content").getAsString();
                        String likesCount = commentObject.get("likes").getAsString();
                        String userName = commentObject.get("user_name").getAsString();
                        String userImage = commentObject.get("user_image").getAsString();
                        String category = commentObject.get("category").getAsString();
                        JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                        JsonArray replies_by_users = commentObject.get("replies").getAsJsonArray();
                        ArrayList<String> liked_users = new ArrayList<String>();
                        if (liked_by_users.size() > 0) {
                            for (int j = 0; j < liked_by_users.size(); j++) {
                                JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                boolean isLiked = res.get("like").getAsBoolean();
                                if (isLiked) {
                                    String social_id = res.get("social_id").getAsString();
                                    liked_users.add(social_id);
                                }
                            }
                        }
                        String replies = null;
                        if (replies_by_users.size() > 0) {
                            for (int j = 0; j < replies_by_users.size(); j++) {
                                replies = String.valueOf(replies_by_users.size());
                            }
                        }
                        logger.debug(LOG_TAG, "Parent ID : " + parentId);
                        logger.debug(LOG_TAG, "Parent ID : " + parentId);
                        CommentListModel commentListItem = new CommentListModel(userId, parentId, socialId, screenId, userName, createdTime, content, userImage, social_types, likesCount, liked_users, "", replies, category);
                        if (social_types.equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                            mCommentArrayList.add(commentListItem);
                            getFacebookUserInformation(socialId, i);
                        } else {
                            mCommentArrayList.add(commentListItem);
                            try {
                                getProfileDetail(socialId, social_types, i);
                            } catch (UnsupportedEncodingException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
                if (mCommentArrayList.size() > 0) {
                    mCommentListAdapter = new CommentListAdapter(getActivity(), R.layout.list_item_activity_comment, mCommentArrayList);
                    lvCommentList.setAdapter(mCommentListAdapter);
                }
            }
        }
    }


    /**
     * ---------------------------------------------------------------------------------
     * Class Name : getProfileDetail
     * Description : This class is used to fetch users social profile information.
     * Like : Profile Name, Profile Image
     * Date of Creation : 1/4/15
     *
     * @param position
     * @param social_types
     * @param socialID     <p/>
     *                     -------------------------------------------------------------------------------------
     *                     Update Log:
     *                     Date:		By:		    Details:
     *                     1/4/15    Rajan       Create full class
     *                     <p/>
     *                     -----------------------------------------------------------------------------------
     * @author Virtual Reality systems
     * @see com.squareup.okhttp
     */
    private void getProfileDetail(final String socialID, String social_types, final int position) throws UnsupportedEncodingException {
        String result;
        final CommentListModel commentListModel;
        String userSocialId = socialID;
        String socialTypes = social_types;

        commentListModel = mCommentArrayList.get(position);
        if (socialTypes.equals(AppConstants.SOCIAL_TYPES_GPLUS)) {
            //result = getTwitterStream(userSocialId);
            if (mSharedPreferences.getBoolean(AppConstants.IS_TWITTER_INTEGRATED, false)) {
                final String TWITTER_TOKEN_URL = "https://api.twitter.com/oauth2/token";
                final String TWITTER_STREAM_URL = "https://api.twitter.com/1.1/users/show.json?user_id=";
                String twitterConsumerKey = mSharedPreferences.getString(AppConstants.TWITTER_CONSUMER_KEY, "");
                String twitterConsumerSecret = mSharedPreferences.getString(AppConstants.TWITTER_CONSUMER_SECRET, "");

                String urlApiKey = URLEncoder.encode(twitterConsumerKey, "UTF-8");
                String urlApiSecret = URLEncoder.encode(twitterConsumerSecret, "UTF-8");

                // Concatenate the encoded consumer key, a colon character, and the
                // encoded consumer secret
                String combined = urlApiKey + ":" + urlApiSecret;

                // Base64 encode the string
                String base64Encoded = Base64.encodeToString(combined.getBytes(), Base64.NO_WRAP);
                JsonObject jsonParams = new JsonObject();
                jsonParams.addProperty("grant_type", "client_credentials");
                OkHttpClientUtil.getInstance().initialize(getActivity());
                try {
                    OkHttpClientUtil.doPostRequest(TWITTER_TOKEN_URL, new String[]{"Authorization",
                            "Content-Type"}, new String[]{"Basic " + base64Encoded,
                            "application/x-www-form-urlencoded;charset=UTF-8"}, jsonParams.toString(), new
                            Callback() {
                                @Override
                                public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                                    logger.debug(LOG_TAG, "Client Response Failure Twitter");
                                }

                                @Override
                                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                                    if (response.code() == 200) {
                                        response.cacheResponse();
                                        String res = response.body().string();
                                        if (res != null) {
                                            JsonParser parser = new JsonParser();
                                            JsonElement commentsElement = parser.parse(res);
                                            JsonObject result = commentsElement.getAsJsonObject();
                                            loadTwitterData(result, socialID, TWITTER_STREAM_URL,
                                                    commentListModel, position);
                                        }
                                    }
                                }
                            });
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        } else {
            //result = getGPlusStream(userSocialId);
            OkHttpClientUtil.getInstance().initialize(getActivity());
            try {
                OkHttpClientUtil.doPostRequest("http://picasaweb.google.com/data/entry/api/user/" +
                        userSocialId + "?alt=json", new Callback() {
                    @Override
                    public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                        logger.error(LOG_TAG, "Failed to load Google+ Data");
                    }

                    @Override
                    public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                        if (response.code() == 200) {
                            response.cacheResponse();
                            String res = response.body().string();
                            if (res != null) {
                                JsonParser parser = new JsonParser();
                                JsonElement commentsElement = parser.parse(res);
                                JsonObject result = commentsElement.getAsJsonObject();
                                JsonObject entry = result.getAsJsonObject("entry");
                                JsonObject urlJsonObject = entry.getAsJsonObject("gphoto$thumbnail");
                                JsonObject nameJsonObject = entry.getAsJsonObject("gphoto$nickname");
                                String profileUrl = urlJsonObject.get("$t").getAsString();
                                String profileName = nameJsonObject.get("$t").getAsString();
                                commentListModel.setIcons(profileUrl);
                                commentListModel.setName(profileName);
                                mCommentListAdapter.notifyDataSetChanged();
                            }
                        }
                    }
                });
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    /**
     * ---------------------------------------------------------------------------------
     * Class Name : loadTwitterData
     * Description : This class is used to fetch users social profile information.
     * Like : Profile Name, Profile Image
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */
    private void loadTwitterData(JsonObject result, String socialID, String URL, CommentListModel model, int position) {
        model = mCommentArrayList.get(position);

        String token_type = result.get("token_type").getAsString();
        String access_token = result.get("access_token").getAsString();

        if (result != null && result.get("token_type").getAsString().equals("bearer")) {


            OkHttpClientUtil.getInstance().initialize(getActivity());

            final CommentListModel finalModel = model;
            try {
                OkHttpClientUtil.doPostRequest(URL + socialID, new String[]{"Authorization", "Content-Type"},
                        new String[]{"Bearer" + access_token, "application/json"}, null, new Callback() {
                            @Override
                            public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                                logger.error(LOG_TAG, "Twitter get user data Failed!");
                            }

                            @Override
                            public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                                if (response.code() == 200) {
                                    response.cacheResponse();

                                    String res = response.body().string();
                                    if (res != null) {
                                        JsonParser parser = new JsonParser();
                                        JsonElement commentsElement = parser.parse(res);
                                        JsonObject result = commentsElement.getAsJsonObject();
                                        if (!result.toString().contains("errors")) {
                                            String profileUlr = result.get("profile_image_url").getAsString();
                                            String profileName = result.get("name").getAsString();
                                            String profileId = result.get("id_str").getAsString();
                                            finalModel.setIcons(profileUlr);
                                            finalModel.setName(profileName);
                                            mCommentListAdapter.notifyDataSetChanged();
                                        }
                                    }
                                }
                            }
                        });
            } catch (IOException e) {
                e.printStackTrace();
            }

        }
    }

    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    private void hideViews() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) llMessageMainStrip.getLayoutParams();
        int fabBottomMargin = lp.bottomMargin;
        llMessageMainStrip.animate().translationY(llMessageMainStrip.getHeight() + fabBottomMargin).setInterpolator(new AccelerateInterpolator(2)).start();
    }

    @TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
    private void showViews() {
        llMessageMainStrip.animate().translationY(0).setInterpolator(new DecelerateInterpolator(2)).start();
    }

    private enum HashKey {
        COMMENT_HASH(0x0CCAD00),
        POST_COMMENT_HASH(0xEEEEAA);

        private int code;

        HashKey(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }
    }
}
