/**---------------------------------------------------------------------------------
 File Name : MainFragment.java
 Version Information : Version 1.1
 Date of Creation : 25/2/15
 Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/

package com.vrs.android.fyreon.fragments;


import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Fragment;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.vrs.android.fyreon.R;


/**
 * ---------------------------------------------------------------------------------
 * Class Name : MainFragment
 * Description : MainFragment is parent fragment of both[Comment , Profile].
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 * @see android.support.v4.app.Fragment
 */
@TargetApi(Build.VERSION_CODES.HONEYCOMB)
public class MainFragment extends Fragment {

    private static final String LOG_TAG = MainFragment.class.getSimpleName();
    private static final int NUM_PAGES = 2;

    private static FragmentActivity mFragment;
    private ViewPager mPager;

    // Widget Referances
    private PagerAdapter mPagerAdapter;

    public MainFragment() {
    }

    @SuppressLint("ValidFragment")
    public MainFragment(FragmentActivity activity) {
        mFragment = activity;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_main, container, false);
        mPager = (ViewPager) rootView.findViewById(R.id.fragment_main_pager);
        mPagerAdapter = new MainFragmentPagerAdapter(mFragment.getSupportFragmentManager());
        mPager.setAdapter(mPagerAdapter);
        mPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                if (position == 0) {
                    CommentFragment fragment = new CommentFragment();
                    fragment.onPageChanged();

                } else if (position == 1) {
                    ProfileFragment fragment = new ProfileFragment();
                    fragment.onPageChanged();
                } else {
                    Log.d(LOG_TAG, "Pager cannot Determine Fragment.");
                }

            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        return rootView;
    }


    /**
     * ---------------------------------------------------------------------------------
     * Interface Name : pageChangeListener
     * Description : Listen event on page change in main fragment.
     * Date of Creation : 25/2/15
     *
     * @author Virtual Reality systems
     *         <p/>
     *         -------------------------------------------------------------------------------------
     *         Update Log:
     *         Date:		By:		    Details:
     *         25/2/15    Rajan       Create full class
     *         24/3/15    Bhadresh    Refactor code as per coding standard.
     *         -----------------------------------------------------------------------------------
     */
    public interface pageChangeListener {
        public void onPageChanged();
    }


    /**
     * ---------------------------------------------------------------------------------
     * Class Name : MainFragmentPagerAdapter
     * Description : A simple pager adapter that represents 5 ScreenSlidePageFragment objects, in
     * sequence.
     * Date of Creation : 25/2/15
     *
     * @author Virtual Reality systems
     *         <p/>
     *         -------------------------------------------------------------------------------------
     *         Update Log:
     *         Date:		By:		    Details:
     *         25/2/15    Rajan       Create full class
     *         24/3/15    Bhadresh    Refactor code as per coding standard.
     *         -----------------------------------------------------------------------------------
     * @see android.support.v4.app.FragmentStatePagerAdapter
     */
    private class MainFragmentPagerAdapter extends FragmentStatePagerAdapter {
        public MainFragmentPagerAdapter(FragmentManager fm) {
            super(fm);
        }


        @Override
        public android.support.v4.app.Fragment getItem(int position) {
            switch (position) {
                case 0:
                    return CommentFragment.init(position);
                case 1:
                    return ProfileFragment.init(position);
                default:
                    return null;
            }
        }

        @Override
        public int getCount() {
            return NUM_PAGES;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            switch (position) {
                case 0:
                    return "Comments";
                case 1:
                    return "Profile";
            }

            return null;
        }
    }
}
