/**
 * ---------------------------------------------------------------------------------
 * File Name : TutorialWizard.java
 * Version Information : Version 1.1
 * Date of Creation : 07/04/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */

package com.vrs.android.fyreon.tutorials;

import android.content.SharedPreferences;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;

import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.fragments.CommentFragment;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;

import org.codepond.wizardroid.WizardFlow;
import org.codepond.wizardroid.layouts.BasicWizardLayout;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : TutorialWizard
 * Description : User guide tutorial wizard
 * Date of Creation : 07/04/14
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -----------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         07/04/14     Bhadresh    Full class created
 *         -----------------------------------------------------------------------------------
 */
public class TutorialWizard extends BasicWizardLayout {

    private static final Logger logger = new Logger(true, TutorialWizard.class.getSimpleName());
    private WizardFlow flow;

    public TutorialWizard() {
        super();
    }

    /*
        You must override this method and create a wizard flow by
        using WizardFlow.Builder as shown in this example
     */
    @Override
    public WizardFlow onSetup() {
        flow = new WizardFlow.Builder()
                .addStep(TutorialStep1.class)           //Add your steps in the order you want them
                .addStep(TutorialStep2.class)
                .addStep(TutorialStep3.class).create();
        int stepCount = flow.getStepsCount();
        logger.debug("Wizard", "Step : " + stepCount);
        return flow;

    }

    /*
        You'd normally override onWizardComplete to access the wizard context and/or close the wizard
     */
    @Override
    public void onWizardComplete() {
        super.onWizardComplete();
        SharedPreferences mSharedPreferences = getActivity().getSharedPreferences(AppConstants.PREF_NAME, 0);
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putBoolean(AppConstants.PREF_IS_FIRST_LAUNCH, false).commit();
        // Replace tutorial wizard with comment fragment
        ((FragmentActivity) getActivity()).getSupportFragmentManager().beginTransaction()
                .setTransition(FragmentTransaction.TRANSIT_FRAGMENT_CLOSE)
                .setCustomAnimations(R.anim.fadein, R.anim.fadeout)
                .replace(R.id.layout_fyreon_widget_down_container, new CommentFragment())
                .commit();
    }
}