/**
 * ---------------------------------------------------------------------------------
 * File Name : AppConstants.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */
package com.vrs.android.fyreon.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.http.AndroidHttpClient;
import android.util.Log;

import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : AppConstants
 * Description : Contains all required constants for application.
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 */
public class AppConstants {
    // This is Second change by Bhadresh after clone repo
    // Twitter Constants
    public static final String TWITTER_CONSUMER_KEY = "twitter_consumer_key";
    public static final String TWITTER_CONSUMER_SECRET = "twitter_consumer_secrete";
    public static final String IS_TWITTER_INTEGRATED = "is_twitter_integrated";
    public static final String IS_FACEBOOK_INTEGRATED = "is_facebook_integrated";
    public static final String IS_GPLUS_INTEGRATED = "is_gplus_integrated";
    public static final String PREF_KEY_OAUTH_TOKEN = "oauth_token";
    public static final String PREF_KEY_OAUTH_SECRET = "oauth_token_secret";
    public static final String PREFS_NAME_CATEGORY = "CrashData";
    public static final String PREFS_VALUE_CATEGORY = "isDatabase";
    //  public static final String URL_DATA = "http://vrsweb.in/fyreon/api/get_comments.php";
    //  public static final String URL_KEY_VERIFICATION = "http://vrsweb.in/fyreon/api/get_screen_key.php";
    //  public static final String URL_API = "http://vrsweb.in/apps/api.php";
    // Web Service Constants
    public static final String BASE_URL = "http://192.168.1.9:8000/api/";
    public static final String URL_DATA = BASE_URL + "get_comments/";
    public static final String URL_KEY_VERIFICATION = BASE_URL + "get_screen_key/";
    public static final String URL_ADD_COMMENT = BASE_URL + "add_comment/";
    public static final String URL_COMMENT_COUNT = BASE_URL + "get_comments_meta/";
    public static final String URL_COMMENT_LIKE = BASE_URL + "set_comment_like/";
    public static final String URL_GET_USER_PROFILE = BASE_URL + "get_user_profile/";
    public static final String URL_GET_USER_COMMENTS = BASE_URL + "get_user_comments/";
    public static final String URL_GET_USER_LIKES = BASE_URL + "get_user_likes/";
    public static final String URL_GET_USER_APPS = BASE_URL + "get_user_apps/";
    public static final String URL_ADD_USER_PROFILE = BASE_URL + "add_profile/";
    public static final String URL_UPDATE_USER_PROFILE = BASE_URL + "edit_profile/";
    public static final String URL_GET_APP_DETAIL = BASE_URL + "get_app_details/";
    public static final String URL_GET_LIKED_COMMENT_DETAIL = BASE_URL + "get_comment_likes/";
    public static final String URL_GET_REPLIED_COMMENT_DETAIL = BASE_URL + "get_comment_replies/";
    public static final String URL_SEND_CRASH_REPORT = BASE_URL + "submit_crash_report/";
    public static final String URL_LOGIN_WITH_FYREON =BASE_URL + "fyreon_login/" ;

    public static final int STATUS_CODE_SUCCESS = 200;
    public static final int STATUS_CODE_FAILURE = 400;
    public static final int STATUS_CODE_FAILURE_AUTH = 401;
    // public static final String URL_ADD_COMMENT = "http://vrsweb.in/fyreon/api/add_comment.php";
    // public static final String URL_COMMENT_COUNT = "http://vrsweb.in/fyreon/api/get_comments_meta.php";
    public static final String APPID = "appid";

    // SharedPreferences Constants
    public static final String PREF_APP_FIRST_LAUNCH = "is_first_launch";
    public static final String PREF_NAME = "FireOnPrefs";
    public static final String PREF_IS_LOGIN = "is_login";
    public static final String PREF_SOCIAL_ID = "social_id";
    public static final String PREF_SOCIAL_TYPE = "social_type";
    public static final String PREF_USER_NAME = "user_name";
    public static final String PREF_USER_PROFILE_IMAGE = "user_profile_image";
    public static final String PREF_USER_BDATE = "user_bdate";
    public static final String PREF_USER_EMAIL = "user_email";
    public static final String PREF_HAS_APP_ICON_SENDED = "has_app_icon_sended";

    public static final int MAX_COUNT = 140;
    public static final String COMMENT_ID = "id";
    public static final String COMMENT_PARENT_ID = "parent_id";
    public static final String COMMENT_SCREEN_KEY = "screen_key";

    // Intent Data from List to Composer Activity.
    public static final String COMMENT_SOCIAL_ID = "social_id";
    public static final String COMMENT_SOCIAL_TYPE = "social_type";
    public static final String COMMENT_CREATED = "created";
    public static final String COMMENT_CONTENT = "content";
    public static final String COMMENT_LIKES = "likes";
    public static final String COMMENT_USER_NAME = "user_name";
    public static final String COMMENT_USER_IMAGE = "user_image";
    public static final String COMMENT_COMMENT_LIKES = "comment_likes";
    public static final String COMMENT_REPLIES = "replies";
    public static final String COMMENT_APP_NAME = "app_name";
    public static final String WIDGET_CATEGORY = "widget_category";
    public static final String SCREEN_NAME = "screen_name";
    public static final String SOCIAL_TYPES_FACEBOOK = "facebook"; //facebook
    public static final String SOCIAL_TYPES_TWITTER = "twitter";  //twitter
    public static final String SOCIAL_TYPES_GPLUS = "google";      //google
    public static final String PREF_IS_FIRST_LAUNCH = "is_first_launch";

    public static boolean isCreateDatabase = true;
    public static String dataBaseName;
    public static String APP_KEY = "";

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : downloadBitmap
     * Description : Download image from provided url.
     * Date of Creation : 25/02/15
     *
     * @param url
     * @return Bitmap image
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    static Bitmap downloadBitmap(String url) {
        final AndroidHttpClient client = AndroidHttpClient.newInstance("Android");
        final HttpGet getRequest = new HttpGet(url);
        try {
            HttpResponse response = client.execute(getRequest);
            final int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                Log.w("ImageDownloader", "Error " + statusCode
                        + " while retrieving bitmap from " + url);
                return null;
            }

            final HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream inputStream = null;
                try {
                    inputStream = entity.getContent();
                    final Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                    return bitmap;
                } finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    entity.consumeContent();
                }
            }
        } catch (Exception e) {
            getRequest.abort();
            Log.w("ImageDownloader", "Error while retrieving bitmap from " + url);
        } finally {
            if (client != null) {
                client.close();
            }
        }
        return null;
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getDateCurrentTimeZone
     * Description : This method will accept time stamp and it will return date in format
     * "MM/dd/yyyy HH:mm:ss"
     * Date of Creation : 25/02/15
     *
     * @param timestamp
     * @return String currentTimeZone
     * @throws Exception -------------------------------------------------------------------------------------
     *                   Update Log:
     *                   Date:		By:		Details:
     *                   <p/>
     *                   25/2/15    Rajan       Create full class
     *                   24/3/15    Bhadresh    Refactor code as per coding standard.
     *                   -----------------------------------------------------------------------------------
     */
    public static String getDateCurrentTimeZone(long timestamp) {
        Date timeDate = new Date(timestamp);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm a dd-MMM-yyyy");
        String time = formatter.format(timeDate);
        return time;
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getYearCurrentTimeZone
     * Description : This method will accept time stamp and it will return date in format
     * "MM/dd/yyyy HH:mm:ss"
     * Date of Creation : 25/02/15
     *
     * @param timestamp
     * @return String currentTimeZone
     * @throws Exception -------------------------------------------------------------------------------------
     *                   Update Log:
     *                   Date:		By:		Details:
     *                   <p/>
     *                   25/2/15    Rajan       Create full class
     *                   24/3/15    Bhadresh    Refactor code as per coding standard.
     *                   -----------------------------------------------------------------------------------
     */
    public static String getYearCurrentTimeZone(String timestamp) {
        try {
            Calendar calendar = Calendar.getInstance();
            TimeZone tz = TimeZone.getDefault();
            //calendar.setTimeInMillis(timestamp * 1000);
            calendar.add(Calendar.MILLISECOND, tz.getOffset(calendar.getTimeInMillis()));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date currentTimeZone = calendar.getTime();
            String finalString = String.valueOf(currentTimeZone.getDate() + currentTimeZone.getMonth() + currentTimeZone.getHours() + currentTimeZone.getMinutes() + currentTimeZone.getSeconds());
            return finalString;
//            return sdf.format(currentTimeZone);
        } catch (Exception e) {
        }
        return "";
    }

    public static void setData(Context context, Boolean storeData, String packageName) {
        SharedPreferences.Editor editor = context.getSharedPreferences(
                PREFS_NAME_CATEGORY + packageName,
                Context.MODE_PRIVATE).edit();
        editor.putBoolean(PREFS_VALUE_CATEGORY + packageName,
                storeData);
        editor.commit();
    }

    public static Boolean getData(Context context, String packageName) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(
                PREFS_NAME_CATEGORY + packageName,
                Context.MODE_PRIVATE);
        return sharedPreferences.getBoolean(PREFS_VALUE_CATEGORY + packageName, false);
    }

    // For Checking the Internet
    public static boolean isNetworkAvailable(Context context) {
        // Get Connectivity Manager class object from Systems Service
        ConnectivityManager cm = (ConnectivityManager) context
                .getSystemService(Context.CONNECTIVITY_SERVICE);

        // Get Network Info from connectivity Manager
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();

        // if no network is available networkInfo will be null
        // otherwise check if we are connected
        return networkInfo != null && networkInfo.isConnected();
    }

    public static String getTimeTwitter(long timestamp) {
        DateTimeZone.setDefault(DateTimeZone.forID("GMT"));
        DateTime myBirthDate = new DateTime(timestamp);
        DateTime now = new DateTime();
        Period period = new Period(myBirthDate, now);
        Log.d("period", period.toString());

        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        if (period.getYears() != 0) {
            builder.appendYears().appendSuffix(" y");
        } else if (period.getMonths() != 0) {
            builder.appendMonths().appendSuffix(" m");
        } else if (period.getDays() != 0) {
            builder.appendDays().appendSuffix(" d");
        } else if (period.getHours() != 0) {
            builder.appendHours().appendSuffix(" h");
        } else if (period.getMinutes() != 0) {
            builder.appendMinutes().appendSuffix(" m");
        } else if (period.getSeconds() != 0) {
            builder.appendSeconds().appendSuffix(" s");
        } else if (period.getMillis() != 0) {
            builder.appendSeconds().appendSuffix(" now");
        }
        PeriodFormatter formatter = builder.printZeroNever().toFormatter();
        String elapsed = formatter.print(period);
        return elapsed;
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : Save network Response to file
     * Description : Save network Response to file
     * Date of Creation : 25/02/15
     *
     * @param mFile
     * @param mContent -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan       Create full class
     *                 24/3/15    Bhadresh    Refactor code as per coding standard.
     *                 -----------------------------------------------------------------------------------
     */
    public static void saveResponse(File mFile, String mContent) throws Exception {
        FileUtils.fileWrite(mFile.getAbsolutePath(), mContent);
    }

    public static String identifyCodes(int code) {
        String result = null;
        if (code == ErrorViewStatusCodes.CODE_111) {
            result = "Connection Failed";
        } else if (code == ErrorViewStatusCodes.CODE_400) {
            result = "Bad Request";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_401) {
            result = "Unauthorized";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_402) {
            result = "Payment Required";
        } else if (code == ErrorViewStatusCodes.CODE_403) {
            result = "Forbidden";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_404) {
            result = "Not Found";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_405) {
            result = "Method Not Allowed";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_406) {
            result = "Not Acceptable";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_407) {
            result = "Proxy Authentication Required";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_408) {
            result = "Request Timeout";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_409) {
            result = "Conflict";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_410) {
            result = "Gone";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_411) {
            result = "Length Required";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_412) {
            result = "Precondition Failed";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_413) {
            result = "Request Entity Too Large";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_414) {
            result = "Request-URI Too Long";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_415) {
            result = "Unsupported Media Type";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_416) {
            result = "Requested Range Not Satisfiable";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_417) {
            result = "Expectation Failed";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_500) {
            result = "Internal Server Error";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_501) {
            result = "Not Implemented";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_502) {
            result = "Bad Gateway";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_503) {
            result = "Service Unavailable";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_504) {
            result = "Gateway Timeout";
        } else if (code == com.vrs.android.fyreon.utils.ErrorViewStatusCodes.CODE_505) {
            result = "HTTP Version Not Supported";
        }
        return result;
    }
}
