/**---------------------------------------------------------------------------------
 File Name : TimeUnit.java
 Version Information : Version 1.1
 Date of Creation : 25/2/15
 Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/
package com.vrs.android.fyreon.utils;

import android.text.format.DateUtils;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;


/**
 * ---------------------------------------------------------------------------------
 * Class Name : TimeUnit
 * Description : Format Date-time string.
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 */
public class TimeUtils {

    public final static long ONE_SECOND = 1000;
    public final static long ONE_MINUTE = ONE_SECOND * 60;
    public final static long ONE_HOUR = ONE_MINUTE * 60;
    public final static long ONE_DAY = ONE_HOUR * 24;
    public final static long SECONDS = 60;
    public final static long MINUTES = 60;
    public final static long HOURS = 24;
    public static final List<Long> mTimes = Arrays.asList(
            TimeUnit.DAYS.toMillis(365),
            TimeUnit.DAYS.toMillis(30),
            TimeUnit.DAYS.toMillis(1),
            TimeUnit.HOURS.toMillis(1),
            TimeUnit.MINUTES.toMillis(1),
            TimeUnit.SECONDS.toMillis(1));
    public static final List<String> mTimesString = Arrays.asList("year", "month", "day", "hour", "minute", "second");

    private TimeUtils() {
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : milliseconds
     * Description : This function converts time (in milliseconds) to human-readable format
     * <w> days, <x> hours, <y> minutes and (z) seconds"
     * Date of Creation : 25/02/15
     *
     * @param duration
     * @return String time
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public static String millisToLongDHMS(long duration) {
        StringBuffer res = new StringBuffer();
        long temp = 0;
        if (duration >= ONE_SECOND) {
            temp = duration / ONE_DAY;
            if (temp > 0) {
                duration -= temp * ONE_DAY;
                res.append(temp).append(" day").append(temp > 1 ? "s" : "")
                        .append(duration >= ONE_MINUTE ? ", " : "");
            }

            temp = duration / ONE_HOUR;
            if (temp > 0) {
                duration -= temp * ONE_HOUR;
                res.append(temp).append(" hour").append(temp > 1 ? "s" : "")
                        .append(duration >= ONE_MINUTE ? ", " : "");
            }

            temp = duration / ONE_MINUTE;
            if (temp > 0) {
                duration -= temp * ONE_MINUTE;
                res.append(temp).append(" minute").append(temp > 1 ? "s" : "");
            }

            if (!res.toString().equals("") && duration >= ONE_SECOND) {
                res.append(" and ");
            }

            temp = duration / ONE_SECOND;
            if (temp > 0) {
                res.append(temp).append(" second").append(temp > 1 ? "s" : "");
            }
            return res.toString();
        } else {
            return "0 second";
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : toDuration
     * Description : Convert to given duration.
     * Date of Creation : 25/02/15
     *
     * @param duration
     * @return String time
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public static String toDuration(long duration) {

        StringBuffer res = new StringBuffer();
        for (int i = 0; i < mTimes.size(); i++) {
            Long current = mTimes.get(i);
            long temp = duration / current;
            if (temp > 0) {
                res.append(temp).append(" ").append(mTimesString.get(i)).append(temp > 1 ? "s" : "").append(" ago");
                break;
            }
        }
        if ("".equals(res.toString()))
            return "0 second ago";
        else
            return res.toString();
    }

    public static String getTWTimeString(Date fromdate) {

        SimpleDateFormat twtimeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        twtimeformat.setTimeZone(TimeZone.getTimeZone("GMT"));

        long then;
        then = fromdate.getTime();
        Date date = new Date(then);

        StringBuffer dateStr = new StringBuffer();

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar now = Calendar.getInstance();

        int days = daysBetween(calendar.getTime(), now.getTime());
        int minutes = hoursBetween(calendar.getTime(), now.getTime());
        int hours = minutes / 60;
        if (days == 0) {

            int second = minuteBetween(calendar.getTime(), now.getTime());
            if (minutes > 60) {

                // dateStr.append(hours).append(hours > 1 ? "h" : "h");

                if (hours >= 1 && hours <= 24) {
                    dateStr.append(hours).append("h");
                }

            } else {

                if (second <= 10) {
                    dateStr.append("Now");
                } else if (second > 10 && second <= 30) {
                    dateStr.append("few seconds ago");
                } else if (second > 30 && second <= 60) {
                    dateStr.append(second).append("s");
                } else if (second >= 60 && minutes <= 60) {
                    dateStr.append(minutes).append("m");
                }
            }
        } else if (hours > 24 && days <= 7) {
            dateStr.append(days).append("d");
        } else {
            dateStr.append(twtimeformat.format(date));
        }

        return dateStr.toString();
    }

    public static int minuteBetween(Date d1, Date d2) {
        return (int) ((d2.getTime() - d1.getTime()) / DateUtils.SECOND_IN_MILLIS);
    }

    public static int hoursBetween(Date d1, Date d2) {
        return (int) ((d2.getTime() - d1.getTime()) / DateUtils.MINUTE_IN_MILLIS);
    }

    public static int daysBetween(Date d1, Date d2) {
        return (int) ((d2.getTime() - d1.getTime()) / DateUtils.DAY_IN_MILLIS);
    }


}