package com.vrs.android.fyreon.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class TrafficUtils {

    public static final String TRAFFIC_INFO_PATH = "/proc/uid_stat/";

    public static final String TCP_SND = "/tcp_snd";

    public static final String TCP_RCV = "/tcp_rcv";

    private TrafficUtils() {

    }

    /**
     * get total network traffic, which is the sum of upload and download
     * traffic
     *
     * @return total traffic include received and send traffic
     */
    public static long getTrafficInfo(String uid) {
        final String rcvPath = TRAFFIC_INFO_PATH + uid + TCP_RCV;
        final String sndPath = TRAFFIC_INFO_PATH + uid + TCP_SND;
        long rcvTraffic = -1;
        long sndTraffic = -1;
        try {
            RandomAccessFile rafRcv = new RandomAccessFile(rcvPath, "r");
            rcvTraffic = Long.parseLong(rafRcv.readLine());
            rafRcv.close();

            RandomAccessFile rafSnd = new RandomAccessFile(sndPath, "r");
            sndTraffic = Long.parseLong(rafSnd.readLine());
            rafSnd.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        if (rcvTraffic == -1 || sndTraffic == -1) {
            return -1;
        } else {
            return (rcvTraffic + sndTraffic);
        }
    }
}
