/**---------------------------------------------------------------------------------
 File Name : CommentFragment.java
 Version Information : Version 1.1
 Date of Creation : 25/2/15
 Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/
package com.vrs.android.fyreon.fragments;


import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.vrs.android.fyreon.R;


/**
 * ---------------------------------------------------------------------------------
 * Class Name : ProfileFragment
 * Description : ProfileFragment class contain user profile information.
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 * @see android.support.v4.app.Fragment
 * @see com.vrs.android.fyreon.fragments.MainFragment.pageChangeListener
 */
public class ProfileFragment extends Fragment implements MainFragment.pageChangeListener {

    private static final String LOG_TAG = ProfileFragment.class.getSimpleName();

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : init
     * Description : This method is used to Initialize Fragment in ViewPager as we Don't use the dynamic Fragments.
     * Date of Creation : 25/02/15
     *
     * @param val This parameter takes position in pager
     * @return CommentFragment
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    static ProfileFragment init(int val) {
        ProfileFragment profileFragment = new ProfileFragment();
        Bundle args = new Bundle();
        args.putInt("val", val);
        profileFragment.setArguments(args);
        return profileFragment;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View containerView = inflater.inflate(R.layout.fragment_user_profile, container, false);
        return containerView;
    }

    @Override
    public void onPageChanged() {
        Log.d(LOG_TAG, "Page Change Called");
    }
}
