/**
 * ---------------------------------------------------------------------------------
 * File Name : TwitterLoginActivity.java
 * Version Information : Version 1.1
 * Date of Creation : 25/2/15
 * Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 * -----------------------------------------------------------------------------------
 */
package com.vrs.android.fyreon.ui;


import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.model.SetupTwitter;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.logger.Logger;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : TwitterLoginActivity
 * Description : TwitterLoginActivity class user login module for twitter.
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         30/3/15    Bhadresh    Remove Login Interface.
 *         -----------------------------------------------------------------------------------
 * @see android.app.Activity
 */
public class TwitterLoginActivity extends Activity {

    private static final Logger logger = new Logger(true, TwitterLoginActivity.class.getSimpleName());
    private static final String VERIFIER = "verifier";
    public static String EXTRA_URL = "extra_url";

    public static SetupTwitter mSetupTwitter;

    private SharedPreferences mSharedPreferences;
    private WebView wvTwitterLogin;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_twitter_login);
        mSharedPreferences = getSharedPreferences(AppConstants.PREF_NAME, 0);
        setTitle("Login");

        final String url = this.getIntent().getStringExtra(EXTRA_URL);
        if (null == url) {
            logger.error("Twitter", "URL cannot be null");
            finish();
        }

        wvTwitterLogin = (WebView) findViewById(R.id.activity_twitter_login_webView);
        WebSettings mWebSettings = wvTwitterLogin.getSettings();
        mWebSettings.setSavePassword(false);
        mWebSettings.setSaveFormData(false);
        wvTwitterLogin.setWebViewClient(new TwitterLoginWebViewClient());
        wvTwitterLogin.loadUrl(url);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : TwitterLoginWebViewClient
     * Description : This class contain login module for twitter
     * Date of Creation : 25/2/15
     *
     * @author Virtual Reality systems
     *         <p/>
     *         -------------------------------------------------------------------------------------
     *         Update Log:
     *         Date:		By:		    Details:
     *         25/2/15    Rajan       Create full class
     *         24/3/15    Bhadresh    Refactor code as per coding standard.
     *         -----------------------------------------------------------------------------------
     * @see android.webkit.WebViewClient
     */
    class TwitterLoginWebViewClient extends WebViewClient {

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {

            if (url.contains(mSetupTwitter.getCallbackUrl())) {
                Uri uri = Uri.parse(url);
                String verifier = uri.getQueryParameter(mSetupTwitter.getoAuthVerifier());
                logger.debug("WebView", "Values : " + verifier.toString());
                SharedPreferences.Editor e = mSharedPreferences.edit();
                e.putString(VERIFIER, verifier);
                e.commit();
                Intent result = new Intent();
                result.putExtra(mSetupTwitter.getoAuthVerifier(), verifier);
                setResult(RESULT_OK, result);
                finish();
                return true;
            }
            return false;
        }

    }


}
