package com.vrs.android.fyreon.utils;

import android.content.res.Resources;
import android.util.TypedValue;
import android.view.View;

/**
 * Package Name : com.vrs.android.fyreon.utils
 * Created by vrsuser on 8/5/15.
 * Time : 10:36 AM
 * Project : FyreonTest
 * Modified : 08 10 36
 */
public class Utils {
    /**
     * Convert Dp to Pixel
     */
    public static int dpToPx(float dp, Resources resources) {
        float px = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, resources.getDisplayMetrics());
        return (int) px;
    }

    public static int getRelativeTop(View myView) {
// if (myView.getParent() == myView.getRootView())
        if (myView.getId() == android.R.id.content)
            return myView.getTop();
        else
            return myView.getTop() + getRelativeTop((View) myView.getParent());
    }

    public static int getRelativeLeft(View myView) {
// if (myView.getParent() == myView.getRootView())
        if (myView.getId() == android.R.id.content)
            return myView.getLeft();
        else
            return myView.getLeft() + getRelativeLeft((View) myView.getParent());
    }
}
