/**---------------------------------------------------------------------------------
 File Name : Parser.java
 Version Information : Version 1.1
 Date of Creation : 25/2/15
 Copyright Notice : This file is created by Virtual Reality Systems and all right reserve by VRS.
 -----------------------------------------------------------------------------------*/
package com.vrs.android.fyreon.json;

import android.util.Log;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;

/**
 * ---------------------------------------------------------------------------------
 * Class Name : Parser
 * Description : Parser class contain user comment list..
 * Date of Creation : 25/2/15
 *
 * @author Virtual Reality systems
 *         <p/>
 *         -------------------------------------------------------------------------------------
 *         Update Log:
 *         Date:		By:		    Details:
 *         25/2/15    Rajan       Create full class
 *         24/3/15    Bhadresh    Refactor code as per coding standard.
 *         -----------------------------------------------------------------------------------
 */
public class Parser {

    static InputStream mInputStream = null;
    static JSONObject mJsonObject = null;
    static String mJsonString = "";
    static int TIMEOUT = 10000;

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : init
     * Description : This method is used to post request with json parameter.
     * Date of Creation : 25/02/15
     *
     * @param url        Request Url
     * @param jsonObject request parameter
     * @return String response
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public String postDataWithParams(String url, JSONObject jsonObject) {
        String responseString = "";
        try {
            HttpParams httpParameters = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout(httpParameters, TIMEOUT);
            HttpConnectionParams.setSoTimeout(httpParameters, TIMEOUT);
            HttpClient httpClient = new DefaultHttpClient(httpParameters);
            HttpPost putConnection = new HttpPost(url);
            putConnection.setHeader("json", jsonObject.toString());
            StringEntity se = new StringEntity(jsonObject.toString(), "UTF-8");
            se.setContentEncoding(new BasicHeader("Content-type",
                    "application/json"));
            putConnection.setEntity(se);
            try {
                HttpResponse response = httpClient.execute(putConnection);
                responseString = EntityUtils.toString(response.getEntity(),
                        "UTF-8");
            } catch (ClientProtocolException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return responseString;
    }

    /**
     * ---------------------------------------------------------------------------------
     * Method Name : getJSONData
     * Description : This method is used to get request from url
     * Date of Creation : 25/02/15
     *
     * @param url            Request Url
     * @param nameValuePairs request parameter
     * @return JSONObject mJsonObject
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    public JSONObject getJSONData(String url, List<NameValuePair> nameValuePairs) {
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpPost post = new HttpPost(url);
            if (nameValuePairs != null)
                post.setEntity(new UrlEncodedFormEntity(nameValuePairs));
            HttpResponse response = client.execute(post);
            HttpEntity entity = response.getEntity();
            mInputStream = entity.getContent();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    mInputStream, "iso-8859-1"), 8);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            mInputStream.close();
            mJsonString = sb.toString();
        } catch (Exception e) {
            Log.e("Buffer Error", "Error converting result " + e.toString());
        }
        try {
            mJsonObject = new JSONObject(mJsonString);
        } catch (JSONException e) {
            Log.e("JSON Parser", "Error parsing data " + e.toString());
        }
        return mJsonObject;
    }
}