package com.vrs.android.fyreon.ui;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.internal.widget.TintCheckBox;
import android.support.v7.internal.widget.TintCheckedTextView;
import android.support.v7.internal.widget.TintEditText;
import android.support.v7.internal.widget.TintRadioButton;
import android.support.v7.internal.widget.TintSpinner;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.Toast;

import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Session;
import com.facebook.model.GraphObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.squareup.okhttp.Callback;
import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.adapters.CommentDetailListAdapter;
import com.vrs.android.fyreon.database.DatabaseResult;
import com.vrs.android.fyreon.dialogs.EmojIconsPopup;
import com.vrs.android.fyreon.handlers.ExceptionHandler;
import com.vrs.android.fyreon.interfaces.RetryListener;
import com.vrs.android.fyreon.model.CommentListModel;
import com.vrs.android.fyreon.model.ResultModel;
import com.vrs.android.fyreon.utils.AppConstants;
import com.vrs.android.fyreon.utils.emoji.Emojicon;
import com.vrs.android.fyreon.utils.logger.Logger;
import com.vrs.android.fyreon.utils.net.OkHttpClientUtil;
import com.vrs.android.fyreon.widgets.ErrorView;
import com.vrs.android.fyreon.widgets.emoji.EmojiconEditText;
import com.vrs.android.fyreon.widgets.emoji.EmojiconGridView;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * Package Name : com.vrs.android.fyreon.ui
 * Created by vrsuser on 16/4/15.
 * Time : 3:43 PM
 * Project : fyreon-library-android
 * Modified : 16 15 43
 */

public class CommentDetailActivity extends ActionBarActivity implements View.OnClickListener, CommentDetailListAdapter.adapterInterfaceBridge, TextWatcher {

    private static final String LOG_TAG = CommentDetailActivity.class.getSimpleName();
    private static final Logger logger = new Logger(true, LOG_TAG);
    private static String mCommentCategory = "";
    private static String mScreenName = "";
    private static SharedPreferences mSharedPreferences;

    String comment_id;
    String comment_user_name;
    private ArrayList<CommentListModel> mCommentArrayList;
    private DatabaseResult mDBManager;
    private ListView lvCommentList;
    private CommentDetailListAdapter mListAdapter;
    private Toolbar mToolBar;
    private EmojiconEditText etMessageBox;
    private ImageButton ibtnMessage;
    private HashKey mHaskGen;
    private LinearLayout llErrorLayout;
    private LinearLayout llMainProgressLayout;
    private ErrorView mErrorView;
    private EmojIconsPopup popup;
    private ImageButton ivEmojiButton;
    private LinearLayout mainView;

    public CommentDetailActivity() {
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_comment_detail);

        mToolBar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(mToolBar);
        mHaskGen = HashKey.COMMENT_DETAIL_HASH;

    }

    @Override
    protected void onResume() {
        super.onResume();
        mSharedPreferences = getApplicationContext().getSharedPreferences(AppConstants.PREF_NAME, 0);
        mDBManager = new DatabaseResult(getApplicationContext());
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(
                getApplicationContext()));
        AppConstants.isCreateDatabase = true;
        AppConstants.setData(getApplicationContext(), true, this.getApplicationContext().getPackageName());


        initView();
        setupView();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle item selection
        int i = item.getItemId();
        if (i == android.R.id.home) {
            finish();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    @Nullable
    @Override
    public View onCreateView(String name, Context context, AttributeSet attrs) {
        final View result = super.onCreateView(name, context, attrs);
        if (result != null) {
            return result;
        }
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            // If we're running pre-L, we need to 'inject' our tint aware Views in place of the
            // standard framework versions
            if (name.equals("EditText")) {
                return new TintEditText(this, attrs);
            } else if (name.equals("Spinner")) {
                return new TintSpinner(this, attrs);
            } else if (name.equals("CheckBox")) {
                return new TintCheckBox(this, attrs);
            } else if (name.equals("RadioButton")) {
                return new TintRadioButton(this, attrs);
            } else if (name.equals("CheckedTextView")) {
                return new TintCheckedTextView(this, attrs);
            }
        }

        return null;
    }

    private void initView() {
        lvCommentList = (ListView) findViewById(R.id.activity_lv_comment_list);
        etMessageBox = (EmojiconEditText) findViewById(R.id.fragment_comment_et_message);
        ibtnMessage = (ImageButton) findViewById(R.id.fragment_comment_ibtn_compose);
        llErrorLayout = (LinearLayout) findViewById(R.id.ll_main_error_layout);
        llMainProgressLayout = (LinearLayout) findViewById(R.id.ll_main_progress_layout);
        mErrorView = (ErrorView) findViewById(R.id.error_view);
        ivEmojiButton = (ImageButton) findViewById(R.id.fragment_comment_ibtn_emoji);
        mainView = (LinearLayout) findViewById(R.id.root_view);

        mErrorView.setOnRetryListener(new RetryListener() {
            @Override
            public void onRetry() {
                if (AppConstants.isNetworkAvailable(getApplicationContext())) {
                    llMainProgressLayout.setVisibility(View.VISIBLE);
                    lvCommentList.setVisibility(View.GONE);
                    llErrorLayout.setVisibility(View.GONE);
                    fetchComments();
                } else {
                    mErrorView.setError(111);
                    mErrorView.setErrorTitle(getString(R.string.error_no_internet));
                }
            }
        });
        ibtnMessage.setOnClickListener(this);
        ivEmojiButton.setOnClickListener(this);
        etMessageBox.addTextChangedListener(this);

        // Emoji Button
        popup = new EmojIconsPopup(mainView, getApplicationContext());

        //Will automatically set size according to the soft keyboard size
        popup.setSizeForSoftKeyboard();
        //Set on emojicon click listener
        popup.setOnEmojiconClickedListener(new EmojiconGridView.OnEmojiconClickedListener() {

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                etMessageBox.append(emojicon.getEmoji());
            }
        });

        //Set on backspace click listener
        popup.setOnEmojiconBackspaceClickedListener(new EmojIconsPopup.OnEmojiconBackspaceClickedListener() {

            @Override
            public void onEmojiconBackspaceClicked(View v) {
                KeyEvent event = new KeyEvent(
                        0, 0, 0, KeyEvent.KEYCODE_DEL, 0, 0, 0, 0, KeyEvent.KEYCODE_ENDCALL);
                etMessageBox.dispatchKeyEvent(event);
            }
        });
        //If the emoji popup is dismissed, change emojiButton to smiley icon
        popup.setOnDismissListener(new PopupWindow.OnDismissListener() {

            @Override
            public void onDismiss() {
                changeEmojiKeyboardIcon(ivEmojiButton, R.drawable.smiley);
            }
        });

        //If the text keyboard closes, also dismiss the emoji popup
        popup.setOnSoftKeyboardOpenCloseListener(new EmojIconsPopup.OnSoftKeyboardOpenCloseListener() {

            @Override
            public void onKeyboardOpen(int keyBoardHeight) {

            }

            @Override
            public void onKeyboardClose() {
                if (popup.isShowing())
                    popup.dismiss();
            }
        });

        //On emoji clicked, add it to edittext
        popup.setOnEmojiconClickedListener(new EmojiconGridView.OnEmojiconClickedListener() {

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                etMessageBox.append(emojicon.getEmoji());
            }
        });

        //On backspace clicked, emulate the KEYCODE_DEL key event
        popup.setOnEmojiconBackspaceClickedListener(new EmojIconsPopup.OnEmojiconBackspaceClickedListener() {

            @Override
            public void onEmojiconBackspaceClicked(View v) {
                KeyEvent event = new KeyEvent(
                        0, 0, 0, KeyEvent.KEYCODE_DEL, 0, 0, 0, 0, KeyEvent.KEYCODE_ENDCALL);
                etMessageBox.dispatchKeyEvent(event);
            }
        });

        // To toggle between text keyboard and emoji keyboard keyboard(Popup)
        ivEmojiButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

                //If popup is not showing => emoji keyboard is not visible, we need to show it
                if (!popup.isShowing()) {

                    //If keyboard is visible, simply show the emoji popup
                    if (popup.isKeyBoardOpen()) {
                        popup.showAtBottom();
                        changeEmojiKeyboardIcon(ivEmojiButton, R.drawable.ic_action_keyboard);
                    }

                    //else, open the text keyboard first and immediately after that show the emoji popup
                    else {
                        etMessageBox.setFocusableInTouchMode(true);
                        etMessageBox.requestFocus();
                        popup.showAtBottomPending();
                        final InputMethodManager inputMethodManager = (InputMethodManager) getApplicationContext()
                                .getSystemService(Context.INPUT_METHOD_SERVICE);
                        inputMethodManager.showSoftInput(etMessageBox, InputMethodManager.SHOW_IMPLICIT);
                        changeEmojiKeyboardIcon(ivEmojiButton, R.drawable.ic_action_keyboard);
                    }
                }

                //If popup is showing, simply dismiss it to show the underlying text keyboard
                else {
                    popup.dismiss();
                }
            }
        });

    }

    private void changeEmojiKeyboardIcon(ImageButton iconToBeChanged, int drawableResourceId) {
        iconToBeChanged.setImageResource(drawableResourceId);
    }


    private void setupView() {
        mCommentArrayList = new ArrayList<CommentListModel>();
        comment_id = getIntent().getStringExtra(AppConstants.COMMENT_ID);
        String comment_parent_id = getIntent().getStringExtra(AppConstants.COMMENT_PARENT_ID);
        String comment_screen_key = getIntent().getStringExtra(AppConstants.COMMENT_SCREEN_KEY);
        String comment_social_id = getIntent().getStringExtra(AppConstants.COMMENT_SOCIAL_ID);
        String comment_social_type = getIntent().getStringExtra(AppConstants.COMMENT_SOCIAL_TYPE);
        String comment_time = getIntent().getStringExtra(AppConstants.COMMENT_CREATED);
        String comment_content = getIntent().getStringExtra(AppConstants.COMMENT_CONTENT);
        ArrayList<String> comment_likes = getIntent().getStringArrayListExtra(AppConstants.COMMENT_LIKES);
        comment_user_name = getIntent().getStringExtra(AppConstants.COMMENT_USER_NAME);
        String comment_user_image = getIntent().getStringExtra(AppConstants.COMMENT_USER_IMAGE);
        String comment_like = getIntent().getStringExtra(AppConstants.COMMENT_COMMENT_LIKES);
        String comment_replies = getIntent().getStringExtra(AppConstants.COMMENT_REPLIES);
        mCommentCategory = getIntent().getStringExtra(AppConstants.WIDGET_CATEGORY);
        mScreenName = getIntent().getStringExtra(AppConstants.SCREEN_NAME);
       /* if (mScreenName == null) {
            mScreenName = comment_screen_key.substring(0, comment_screen_key.length() - 10);
        }*/
        llMainProgressLayout.setVisibility(View.VISIBLE);
        lvCommentList.setVisibility(View.GONE);
        logger.debug(LOG_TAG, "Screen Name :: " + mScreenName);
        CommentListModel model = new CommentListModel(comment_id, comment_parent_id, comment_social_id, comment_screen_key, comment_user_name, comment_time, comment_content, comment_user_image, comment_social_type, comment_like, comment_likes, "", comment_replies, mCommentCategory);

        mCommentArrayList.add(model);

        getSupportActionBar().setTitle(comment_user_name + "'s comment");
        getSupportActionBar().setHomeButtonEnabled(true);

        mListAdapter = new CommentDetailListAdapter(getApplicationContext(), R.layout.list_item_activity_comment, mCommentArrayList, this);
        lvCommentList.setAdapter(mListAdapter);

        fetchComments();
        lvCommentList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (position == 0) {

                } else {
                    if (AppConstants.isNetworkAvailable(getApplicationContext())) {
                        Intent startIntent = new Intent(getApplicationContext(), CommentDetailActivity.class);
                        startIntent.putExtra(AppConstants.COMMENT_ID, mCommentArrayList.get(position).getComment_id());
                        startIntent.putExtra(AppConstants.COMMENT_PARENT_ID, mCommentArrayList.get(position).getParent_id());
                        startIntent.putExtra(AppConstants.COMMENT_SCREEN_KEY, mCommentArrayList.get(position).getScreen_id());
                        startIntent.putExtra(AppConstants.COMMENT_SOCIAL_ID, mCommentArrayList.get(position).getSocial_id());
                        startIntent.putExtra(AppConstants.COMMENT_SOCIAL_TYPE, mCommentArrayList.get(position).getSocial_types());
                        startIntent.putExtra(AppConstants.COMMENT_CREATED, mCommentArrayList.get(position).getTime());
                        startIntent.putExtra(AppConstants.COMMENT_CONTENT, mCommentArrayList.get(position).getComment());
                        startIntent.putStringArrayListExtra(AppConstants.COMMENT_LIKES, mCommentArrayList.get(position).getLiked_by());
                        startIntent.putExtra(AppConstants.COMMENT_USER_NAME, mCommentArrayList.get(position).getName());
                        startIntent.putExtra(AppConstants.COMMENT_USER_IMAGE, mCommentArrayList.get(position).getIcons());
                        startIntent.putExtra(AppConstants.COMMENT_COMMENT_LIKES, mCommentArrayList.get(position).getLikes_count());
                        startIntent.putExtra(AppConstants.COMMENT_REPLIES, mCommentArrayList.get(position).getReplies());
                        startIntent.putExtra(AppConstants.WIDGET_CATEGORY, mCommentCategory);
                        startIntent.putExtra(AppConstants.SCREEN_NAME, mScreenName);
                        startActivity(startIntent);
                    } else {
                        Toast.makeText(getApplicationContext(), getString(R.string.network_error),
                                Toast.LENGTH_LONG).show();
                    }
                }
            }
        });

    }

    public void requestFocusKeyBoard() {
        etMessageBox.requestFocus();
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(etMessageBox, InputMethodManager.SHOW_IMPLICIT);
    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : fetchComments
     * Description : This class is used to fetch all comment from web server in background
     * thread.
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */
    public void fetchComments() {
        // recycleCommentList.setVisibility(View.GONE);
        String screenKey = null;
        ResultModel resultModel = new ResultModel();
        mDBManager.open();
        //List<ResultModel> mResult = mDBManager.getResults(resultModel.mAppKey, null, null);
        List<ResultModel> mResult = mDBManager.getResults(resultModel.mAppKey, new String[]{mScreenName}, null);
        mDBManager.close();
        if (mResult.size() > 0) {
            screenKey = mResult.get(mResult.size() - 1).mAppKey;
        }
        logger.debug(LOG_TAG, "Screen Key :" + screenKey);
        final JsonObject commentRequestObject = new JsonObject();
        commentRequestObject.addProperty("screen_key", screenKey);
        commentRequestObject.addProperty("parent_id", comment_id);
        commentRequestObject.addProperty("category", mCommentCategory);
        if (AppConstants.isNetworkAvailable(getApplicationContext())) {
            OkHttpClientUtil.getInstance().initialize(getApplicationContext());
            try {
                OkHttpClientUtil.doPostRequest(AppConstants.URL_DATA, commentRequestObject.toString(),
                        new Callback() {
                            @Override
                            public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                                logger.error(LOG_TAG, "Failed to Load List detail data!");
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        llMainProgressLayout.setVisibility(View.GONE);
                                        if (AppConstants.isNetworkAvailable(getApplicationContext())) {
                                            llErrorLayout.setVisibility(View.VISIBLE);
                                            lvCommentList.setVisibility(View.GONE);
                                            mErrorView.setError(408);
                                            mErrorView.setErrorTitle("Failed to connect to server!");


                                        } else {
                                            llErrorLayout.setVisibility(View.VISIBLE);
                                            lvCommentList.setVisibility(View.GONE);
                                            mErrorView.setError(111);
                                            mErrorView.setErrorTitle(getString(R.string.error_no_internet));
                                        }
                                    }
                                });

                            }

                            @Override
                            public void onResponse(final com.squareup.okhttp.Response response) throws IOException {
                                if (response.code() == 200) {
                                    response.cacheResponse();

                                    final String resBody = response.body().string();

                                    runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            JsonParser parser = new JsonParser();
                                            JsonElement commentsElement = parser.parse(resBody);
                                            JsonArray result = commentsElement.getAsJsonArray();
                                            logger.debug(LOG_TAG, result + "");
                                            mCommentArrayList.clear();
                                            lvCommentList.setVisibility(View.VISIBLE);
                                            JsonArray replied_array = null;
                                            for (int i = 0; i < result.size(); i++) {
                                                JsonObject commentObject = result.get(i).getAsJsonObject();
                                                logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                                                String userId = commentObject.get("id").getAsString();
                                                String parentId = commentObject.get("parent_id").toString();
                                                String screenId = commentObject.get("screen_key").getAsString();
                                                String socialId = commentObject.get("social_id").getAsString();
                                                String social_types = commentObject.get("social_type").getAsString();
                                                String createdTime = commentObject.get("created").getAsString();
                                                String content = commentObject.get("content").getAsString();
                                                String likesCount = commentObject.get("likes").getAsString();
                                                String userName = commentObject.get("user_name").getAsString();
                                                String userImage = commentObject.get("user_image").getAsString();
                                                JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                                                JsonArray replies_by_users = commentObject.get("replies").getAsJsonArray();
                                                ArrayList<String> liked_users = new ArrayList<String>();
                                                if (liked_by_users.size() > 0) {
                                                    for (int j = 0; j < liked_by_users.size(); j++) {
                                                        JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                                        boolean isLiked = res.get("like").getAsBoolean();
                                                        if (isLiked) {
                                                            String social_id = res.get("social_id").getAsString();
                                                            liked_users.add(social_id);
                                                        }
                                                    }
                                                }
                                                String replies = null;
                                                if (replies_by_users.size() > 0) {
                                                    for (int j = 0; j < replies_by_users.size(); j++) {
                                                        replies = String.valueOf(replies_by_users.size());
                                                    }
                                                }

                                                replied_array = replies_by_users;

                                                logger.debug(LOG_TAG, "Parent ID : " + parentId);
                                                logger.debug(LOG_TAG, "Parent ID : " + parentId);
                                                CommentListModel commentListItem = new CommentListModel(userId, parentId, socialId, screenId, userName, createdTime, content, userImage, social_types, likesCount, liked_users, "", replies, mCommentCategory);
                                                if (social_types.equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                                                    mCommentArrayList.add(commentListItem);
                                                    getFacebookUserInformation(socialId, i);
                                                } else {
                                                    mCommentArrayList.add(commentListItem);
                                                    try {
                                                        getProfileDetail(socialId, social_types, i);
                                                    } catch (UnsupportedEncodingException e1) {
                                                        e1.printStackTrace();
                                                    }
                                                }
                                            }

                                            if (replied_array != null) {
                                                if (replied_array.size() > 0) {
                                                    for (int i = 0; i < replied_array.size(); i++) {
                                                        JsonObject commentObject = replied_array.get(i).getAsJsonObject();
                                                        String userId = commentObject.get("id").getAsString();
                                                        String parentId = commentObject.get("parent_id").toString();
                                                        String userName = commentObject.get("user_name").getAsString();
                                                        String userImage = commentObject.get("user_image").getAsString();
                                                        String socialId = commentObject.get("social_id").getAsString();
                                                        String social_types = commentObject.get("social_type").getAsString();
                                                        String createdTime = commentObject.get("created").getAsString();
                                                        String content = commentObject.get("content").getAsString();
                                                        String likesCount = commentObject.get("likes").getAsString();
                                                        String replies = commentObject.get("replies").getAsString();
                                                        JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                                                        ArrayList<String> liked_users = new ArrayList<String>();
                                                        if (liked_by_users.size() > 0) {
                                                            for (int j = 0; j < liked_by_users.size(); j++) {
                                                                JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                                                boolean isLiked = res.get("like").getAsBoolean();
                                                                if (isLiked) {
                                                                    String social_id = res.get("social_id").getAsString();
                                                                    liked_users.add(social_id);
                                                                }
                                                            }
                                                        }

                                                        CommentListModel commentListItem = new CommentListModel(userId, parentId, socialId, "", userName, createdTime, content, userImage, social_types, likesCount, liked_users, "", replies, mCommentCategory);
                                                        if (social_types.equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                                                            mCommentArrayList.add((i + 1), commentListItem);
                                                            getFacebookUserInformation(socialId, i + 1);
                                                        } else {
                                                            mCommentArrayList.add((i + 1), commentListItem);
                                                            try {
                                                                getProfileDetail(socialId, social_types, i + 1);
                                                            } catch (UnsupportedEncodingException e1) {
                                                                e1.printStackTrace();
                                                            }
                                                        }
                                                    }
                                                }

                                            }
                                            llMainProgressLayout.setVisibility(View.GONE);
                                            lvCommentList.setVisibility(View.VISIBLE);
                                            if (mCommentArrayList.size() > 0) {
                                                mListAdapter = new CommentDetailListAdapter(getApplicationContext(), R.layout.list_item_activity_comment, mCommentArrayList, new CommentDetailListAdapter.adapterInterfaceBridge() {
                                                    @Override
                                                    public void onClicked() {
                                                        requestFocusKeyBoard();
                                                    }
                                                });
                                                lvCommentList.setAdapter(mListAdapter);
                                            }

                                            mHaskGen = HashKey.COMMENT_DETAIL_HASH;

                                            if (new File(getApplicationContext().getCacheDir() +
                                                    "/" + mHaskGen.getCode() + ".dat").exists()) {
                                                new File(getApplicationContext().getCacheDir() +
                                                        "/" + mHaskGen.getCode() + ".dat").delete();
                                            }

                                            try {
                                                AppConstants.saveResponse(new File(getApplicationContext().getCacheDir() +
                                                        "/" + mHaskGen.getCode() + ".dat"), resBody);
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                } else {
                                    logger.error(LOG_TAG, "Unrecognized CODE :" + response.code());
                                    runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            llErrorLayout.setVisibility(View.VISIBLE);
                                            lvCommentList.setVisibility(View.GONE);
                                            mErrorView.setError(response.code());
                                            mErrorView.setErrorTitle(AppConstants.identifyCodes
                                                    (response.code()));
                                        }
                                    });
                                }
                            }
                        }

                );
            } catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            mHaskGen = HashKey.COMMENT_DETAIL_HASH;
            llMainProgressLayout.setVisibility(View.GONE);
            lvCommentList.setVisibility(View.VISIBLE);
            if (new File(getApplicationContext().getCacheDir() + "/" + mHaskGen.getCode() + ".dat").exists
                    ()) {
                JsonParser parser = new JsonParser();
                JsonElement commentsElement = null;
                try {
                    commentsElement = parser.parse(new FileReader(getApplicationContext().getCacheDir() + "/" + mHaskGen.getCode() + ".dat"));
                } catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                JsonArray result = null;
                if (commentsElement != null) {
                    result = commentsElement.getAsJsonArray();
                }
                logger.debug(LOG_TAG, result + "");
                mCommentArrayList.clear();
                JsonArray replied_array = null;
                lvCommentList.setVisibility(View.VISIBLE);
                if (result != null) {
                    for (int i = 0; i < result.size(); i++) {
                        JsonObject commentObject = result.get(i).getAsJsonObject();
                        logger.debug(LOG_TAG, "Comment JSON Object : " + commentObject.toString());
                        String userId = commentObject.get("id").getAsString();
                        String parentId = commentObject.get("parent_id").toString();
                        String screenId = commentObject.get("screen_key").getAsString();
                        String socialId = commentObject.get("social_id").getAsString();
                        String social_types = commentObject.get("social_type").getAsString();
                        String createdTime = commentObject.get("created").getAsString();
                        String content = commentObject.get("content").getAsString();
                        String likesCount = commentObject.get("likes").getAsString();
                        String userName = commentObject.get("user_name").getAsString();
                        String userImage = commentObject.get("user_image").getAsString();
                        JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                        JsonArray replies_by_users = commentObject.get("replies").getAsJsonArray();
                        ArrayList<String> liked_users = new ArrayList<String>();
                        if (liked_by_users.size() > 0) {
                            for (int j = 0; j < liked_by_users.size(); j++) {
                                JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                boolean isLiked = res.get("like").getAsBoolean();
                                if (isLiked) {
                                    String social_id = res.get("social_id").getAsString();
                                    liked_users.add(social_id);
                                }
                            }
                        }
                        String replies = null;
                        if (replies_by_users.size() > 0) {
                            for (int j = 0; j < replies_by_users.size(); j++) {
                                replies = String.valueOf(replies_by_users.size());
                            }
                        }

                        replied_array = replies_by_users;

                        logger.debug(LOG_TAG, "Parent ID : " + parentId);
                        logger.debug(LOG_TAG, "Parent ID : " + parentId);
                        CommentListModel commentListItem = new CommentListModel(userId, parentId, socialId, screenId, userName, createdTime, content, userImage, social_types, likesCount, liked_users, "", replies, mCommentCategory);
                        if (social_types.equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                            mCommentArrayList.add(commentListItem);
                            getFacebookUserInformation(socialId, i);
                        } else {
                            mCommentArrayList.add(commentListItem);
                            try {
                                getProfileDetail(socialId, social_types, i);
                            } catch (UnsupportedEncodingException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }

                if (replied_array != null) {
                    if (replied_array.size() > 0) {
                        for (int i = 0; i < replied_array.size(); i++) {
                            JsonObject commentObject = replied_array.get(i).getAsJsonObject();
                            String userId = commentObject.get("id").getAsString();
                            String parentId = commentObject.get("parent_id").toString();
                            String socialId = commentObject.get("social_id").getAsString();
                            String social_types = commentObject.get("social_type").getAsString();
                            String createdTime = commentObject.get("created").getAsString();
                            String content = commentObject.get("content").getAsString();
                            String likesCount = commentObject.get("likes").getAsString();
                            String userName = commentObject.get("user_name").getAsString();
                            String userImage = commentObject.get("user_image").getAsString();
                            JsonArray liked_by_users = commentObject.get("comment_likes").getAsJsonArray();
                            ArrayList<String> liked_users = new ArrayList<String>();
                            if (liked_by_users.size() > 0) {
                                for (int j = 0; j < liked_by_users.size(); j++) {
                                    JsonObject res = liked_by_users.get(j).getAsJsonObject();
                                    boolean isLiked = res.get("like").getAsBoolean();
                                    if (isLiked) {
                                        String social_id = res.get("social_id").getAsString();
                                        liked_users.add(social_id);
                                    }
                                }
                            }

                            CommentListModel commentListItem = new CommentListModel(userId, parentId, socialId, "", userName, createdTime, content, userImage, social_types, likesCount, liked_users, "", "", "");
                            if (social_types.equals(AppConstants.SOCIAL_TYPES_FACEBOOK)) {
                                mCommentArrayList.add((i + 1), commentListItem);
                                getFacebookUserInformation(socialId, i + 1);
                            } else {
                                mCommentArrayList.add((i + 1), commentListItem);
                                try {
                                    getProfileDetail(socialId, social_types, i + 1);
                                } catch (UnsupportedEncodingException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    }

                }

                if (mCommentArrayList.size() > 0) {
                    mListAdapter = new CommentDetailListAdapter(getApplicationContext(), R.layout.list_item_activity_comment, mCommentArrayList, this);
                    lvCommentList.setAdapter(mListAdapter);
                }
            }
        }

    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : getProfileDetail
     * Description : This class is used to fetch users social profile information.
     * Like : Profile Name, Profile Image
     * Date of Creation : 1/4/15
     *
     * @param position
     * @param social_types
     * @param socialID     <p/>
     *                     -------------------------------------------------------------------------------------
     *                     Update Log:
     *                     Date:		By:		    Details:
     *                     1/4/15    Rajan       Create full class
     *                     <p/>
     *                     -----------------------------------------------------------------------------------
     * @author Virtual Reality systems
     * @see com.squareup.okhttp
     */
    private void getProfileDetail(final String socialID, String social_types, final int position) throws UnsupportedEncodingException {
        String result;
        final CommentListModel commentListModel;
        String userSocialId = socialID;
        String socialTypes = social_types;

        commentListModel = mCommentArrayList.get(position);
        if (socialTypes.equals(AppConstants.SOCIAL_TYPES_TWITTER)) {
            //result = getTwitterStream(userSocialId);
            if (mSharedPreferences.getBoolean(AppConstants.IS_TWITTER_INTEGRATED, false)) {
                final String TWITTER_TOKEN_URL = "https://api.twitter.com/oauth2/token";
                final String TWITTER_STREAM_URL = "https://api.twitter.com/1.1/users/show.json?user_id=";
                String twitterConsumerKey = mSharedPreferences.getString(AppConstants.TWITTER_CONSUMER_KEY, "");
                String twitterConsumerSecret = mSharedPreferences.getString(AppConstants.TWITTER_CONSUMER_SECRET, "");

                String urlApiKey = URLEncoder.encode(twitterConsumerKey, "UTF-8");
                String urlApiSecret = URLEncoder.encode(twitterConsumerSecret, "UTF-8");

                // Concatenate the encoded consumer key, a colon character, and the
                // encoded consumer secret
                String combined = urlApiKey + ":" + urlApiSecret;

                // Base64 encode the string
                String base64Encoded = Base64.encodeToString(combined.getBytes(), Base64.NO_WRAP);
                JsonObject jsonParams = new JsonObject();
                jsonParams.addProperty("grant_type", "client_credentials");
                OkHttpClientUtil.getInstance().initialize(getApplicationContext());
                try {
                    OkHttpClientUtil.doPostRequest(TWITTER_TOKEN_URL, new String[]{"Authorization",
                            "Content-Type"}, new String[]{"Basic " + base64Encoded,
                            "application/x-www-form-urlencoded;charset=UTF-8"}, jsonParams.toString(), new
                            Callback() {
                                @Override
                                public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                                    logger.debug(LOG_TAG, "Client Response Failure Twitter");
                                }

                                @Override
                                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                                    if (response.code() == 200) {
                                        response.cacheResponse();
                                        final String res = response.body().string();
                                        runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                if (res != null) {
                                                    JsonParser parser = new JsonParser();
                                                    JsonElement commentsElement = parser.parse(res);
                                                    JsonObject result = commentsElement.getAsJsonObject();
                                                    loadTwitterData(result, socialID, TWITTER_STREAM_URL,
                                                            commentListModel, position);
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            //result = getGPlusStream(userSocialId);
            OkHttpClientUtil.getInstance().initialize(getApplicationContext());
            try {
                OkHttpClientUtil.doPostRequest("http://picasaweb.google.com/data/entry/api/user/" +
                        userSocialId + "?alt=json", new Callback() {
                    @Override
                    public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                        logger.error(LOG_TAG, "Failed to load Google+ Data");
                    }

                    @Override
                    public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                        if (response.code() == 200) {
                            response.cacheResponse();
                            final String res = response.body().string();
                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    if (res != null) {
                                        JsonParser parser = new JsonParser();
                                        JsonElement commentsElement = parser.parse(res);
                                        JsonObject result = commentsElement.getAsJsonObject();
                                        JsonObject entry = result.getAsJsonObject("entry");
                                        JsonObject urlJsonObject = entry.getAsJsonObject("gphoto$thumbnail");
                                        JsonObject nameJsonObject = entry.getAsJsonObject("gphoto$nickname");
                                        String profileUrl = urlJsonObject.get("$t").getAsString();
                                        String profileName = nameJsonObject.get("$t").getAsString();
                                        commentListModel.setIcons(profileUrl);
                                        commentListModel.setName(profileName);
                                        mListAdapter.notifyDataSetChanged();
                                    }
                                }
                            });
                        }
                    }
                });
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    /**
     * ---------------------------------------------------------------------------------
     * Class Name : loadTwitterData
     * Description : This class is used to fetch users social profile information.
     * Like : Profile Name, Profile Image
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */
    private void loadTwitterData(JsonObject result, String socialID, String URL, CommentListModel model, int position) {
        model = mCommentArrayList.get(position);

        String token_type = result.get("token_type").getAsString();
        String access_token = result.get("access_token").getAsString();

        if (result != null && result.get("token_type").getAsString().equals("bearer")) {

            final CommentListModel finalModel = model;
            OkHttpClientUtil.getInstance().initialize(getApplicationContext());
            try {
                OkHttpClientUtil.doPostRequest(URL + socialID, new String[]{"Authorization", "Content-Type"},
                        new String[]{"Bearer" + access_token, "application/json"}, null, new Callback() {
                            @Override
                            public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                                logger.error(LOG_TAG, "Twitter get user data Failed!");
                            }

                            @Override
                            public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                                if (response.code() == 200) {
                                    response.cacheResponse();

                                    final String res = response.body().string();
                                    runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            if (res != null) {
                                                JsonParser parser = new JsonParser();
                                                JsonElement commentsElement = parser.parse(res);
                                                JsonObject result = commentsElement.getAsJsonObject();
                                                if (!result.toString().contains("errors")) {
                                                    String profileUlr = result.get("profile_image_url").getAsString();
                                                    String profileName = result.get("name").getAsString();
                                                    String profileId = result.get("id_str").getAsString();
                                                    finalModel.setIcons(profileUlr);
                                                    finalModel.setName(profileName);
                                                    mListAdapter.notifyDataSetChanged();
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        });
            } catch (IOException e) {
                e.printStackTrace();
            }

        }
    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : getFacebookUserInformation
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     *
     * @param facebookID pass Facbook User ID
     * @param pos        pass position of your adapter or list data.
     *                   -------------------------------------------------------------------------------------
     *                   Update Log:
     *                   Date:		By:		Details:
     *                   <p/>
     *                   25/2/15    Rajan       Created full Method
     *                   <p/>
     *                   -----------------------------------------------------------------------------------
     */

    private void getFacebookUserInformation(String facebookID, final int pos) {
        if (mSharedPreferences.getBoolean(AppConstants.IS_FACEBOOK_INTEGRATED, false)) {

            if (Session.getActiveSession() != null) {

            } else {
                Session.openActiveSessionFromCache(getApplicationContext());
            }

            String[] path = {facebookID};

            RequestBatch requestBatch = new RequestBatch(Request.newGraphPathRequest(Session.getActiveSession(), path[0], new Request.Callback() {
                @Override
                public void onCompleted(com.facebook.Response response) {
                    parseResponseFaceBook(response, pos);
                }
            }));

            requestBatch.executeAsync();
        }

    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : parseResponseFaceBook
     * Description : Parsing response that we get from GraphObject.
     * Date of Creation : 25/02/15
     *
     * @param response pass facebook graph api response.
     * @param pos      pass position of your adapter or list data.
     *                 -------------------------------------------------------------------------------------
     *                 Update Log:
     *                 Date:		By:		Details:
     *                 <p/>
     *                 25/2/15    Rajan       Created full Method
     *                 <p/>
     *                 -----------------------------------------------------------------------------------
     */


    private void parseResponseFaceBook(com.facebook.Response response, int pos) {

        CommentListModel drList = mCommentArrayList.get(pos);
        GraphObject graphObject = response.getGraphObject();
        if (graphObject != null) {
            drList.setName(String.format("%s", graphObject.getProperty("name")));
            mListAdapter.notifyDataSetChanged();
        }
    }

    /**
     * ---------------------------------------------------------------------------------
     * Class Name : addComment
     * Description : This class is used to fetch all comment from web server in background
     * thread.
     * Date of Creation : 1/4/15
     *
     * @author Virtual Reality systems
     * <p/>
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		    Details:
     * 25/2/15    Rajan       Create full class
     * <p/>
     * -----------------------------------------------------------------------------------
     * @see com.squareup.okhttp
     */

    private void addComment() {
        ResultModel resultModel = new ResultModel();
        mDBManager.open();
        //    List<ResultModel> mResult = mDBManager.getResults(resultModel.mAppKey, null, null);
        List<ResultModel> mResult = mDBManager.getResults(resultModel.mAppKey, new String[]{mScreenName}, null);
        mDBManager.close();
        String API_KEY = mResult.get(mResult.size() - 1).mAppKey;
        String SOCIAL_ID = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_ID, "");
        String SOCIAL_TYPE = mSharedPreferences.getString(AppConstants.PREF_SOCIAL_TYPE, "");
        logger.debug(LOG_TAG, "Social ID :" + SOCIAL_ID);
        logger.debug(LOG_TAG, "Comment Category : " + mCommentCategory);
        String CONTENT = etMessageBox.getText().toString().trim();
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("screen_key", API_KEY);
        jsonParams.addProperty("social_id", SOCIAL_ID);
        jsonParams.addProperty("content", CONTENT);
        jsonParams.addProperty("social_type", SOCIAL_TYPE);
        jsonParams.addProperty("parent_id", comment_id);
        jsonParams.addProperty("category", mCommentCategory);
        logger.debug(LOG_TAG, "Add Comment Jason Body : " + jsonParams.toString());

        OkHttpClientUtil.getInstance().initialize(getApplicationContext());


        try {
            OkHttpClientUtil.doPostRequest(AppConstants.URL_ADD_COMMENT, jsonParams.toString(), new Callback() {
                @Override
                public void onFailure(com.squareup.okhttp.Request request, IOException e) {
                    logger.error(LOG_TAG, "Error posting comment!" + e);

                }

                @Override
                public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                    if (response.code() == 200) {
                        response.cacheResponse();

                        String resBody = response.body().string();
                        if (resBody != null) {
                            JsonParser parser = new JsonParser();
                            JsonElement commentsElement = parser.parse(resBody);
                            JsonObject result = commentsElement.getAsJsonObject();
                            logger.debug(LOG_TAG, "JSON ARRAY : " + result.toString());
                            if (response.code() == 200) {
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
//                                        llMessageLayout.setVisibility(View.VISIBLE);
//                                        llProgressLayout.setVisibility(View.GONE);
                                        etMessageBox.setText("");
                                        Toast.makeText(getApplicationContext(), "Message Send Successfully!", Toast
                                                .LENGTH_LONG).show();
                                        fetchComments();
                                    }
                                });
                            } else {
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
//                                        llMessageLayout.setVisibility(View.VISIBLE);
//                                        llProgressLayout.setVisibility(View.GONE);
                                        Toast.makeText(getApplicationContext(), "Message Could not be " +
                                                "sent!", Toast.LENGTH_LONG).show();
                                    }
                                });
                            }
                        }

                    } else {
                        logger.error(LOG_TAG, "Unrecognized code detected! " + response.code());
                    }
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onClick(View v) {
        if (v == ibtnMessage) {
            if (isLogin()) {
                if (etMessageBox.length() > 140) {
                    Toast.makeText(getApplicationContext(), "You can not post more than 140 Characters in comment.", Toast.LENGTH_LONG).show();
                } else {
                    if (etMessageBox.length() <= 0) {
                        Toast.makeText(getApplicationContext(), "You can not post blank comment", Toast.LENGTH_LONG).show();
                    } else {

                        if (etMessageBox.getText().toString().trim().equalsIgnoreCase("")) {
                            Toast.makeText(getApplicationContext(), "You can not post blank comment", Toast.LENGTH_LONG).show();
                        } else {
                            addComment();
                        }
                    }
                }
            } else {
                Toast.makeText(getApplicationContext(), "You need to be logged in order to reply to the comment!", Toast.LENGTH_LONG).show();
            }
        }

    }

    /**
     * ----------------------------------------------------------------------------------
     * Method Name : isLogin
     * Description : Used to check user login status
     * Date of Creation : 25/02/15
     *
     * @return boolean isLoggedIn
     * -------------------------------------------------------------------------------------
     * Update Log:
     * Date:		By:		Details:
     * <p/>
     * 25/2/15    Rajan       Create full class
     * 24/3/15    Bhadresh    Refactor code as per coding standard.
     * -----------------------------------------------------------------------------------
     */
    private boolean isLogin() {
        boolean isLoggedIn = mSharedPreferences.getBoolean(AppConstants.PREF_IS_LOGIN, false);

        return isLoggedIn;
    }

    @Override
    public void onClicked() {
        requestFocusKeyBoard();
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {

    }

    @Override
    public void afterTextChanged(Editable editable) {
        int count = AppConstants.MAX_COUNT - editable.length();
        if (count < 0) {
            etMessageBox.setTextColor(getResources().getColor(R.color.red_color_primaryDark));
        } else if (count > 0) {
            etMessageBox.setTextColor(getResources().getColor(R.color.background_floating_material_dark));
        }
    }


    private enum HashKey {
        COMMENT_DETAIL_HASH(0x0FFCACA1A),
        POST_COMMENT_HASH(0xEEEEAA);

        private int code;

        HashKey(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }
    }
}
