package com.vrs.android.fyreon.utils.logger;

import android.util.Log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * Package Name : com.vrs.android.fyreon.utils.logger
 * Created by vrsuser on 7/5/15.
 * Time : 12:41 PM
 * Project : FyreonTest
 * Modified : 07 12 41
 */
public class Logger {
    private static String DEFAULT_TAG = "";
    private boolean isDebugEnabled = false;

    public Logger() {
    }

    public Logger(boolean isDebug, String TAG) {
        this.isDebugEnabled = isDebug;
        DEFAULT_TAG = TAG;
    }

    public boolean isDebug() {
        return isDebugEnabled;
    }


    public void error(String tag, String message) {
        if (isDebug()) Log.e(tag, message);
    }

    public void warn(String tag, String message) {
        if (isDebug()) Log.w(tag, message);
    }

    public void info(String tag, String message) {
        if (isDebug()) Log.i(tag, message);
    }

    public void debug(String tag, String message) {
        if (isDebug()) Log.d(tag, message);
    }

    public void trace(String tag, String message) {
        if (isDebug()) Log.v(tag, message);
    }

    public void error(String tag, String message, Object args) {
        if (isDebug()) Log.e(tag, message + "\n" + args);
    }

    public void warn(String tag, String message, Object args) {
        if (isDebug()) Log.w(tag, message + "\n" + args);
    }

    public void info(String tag, String message, Object args) {
        if (isDebug()) Log.i(tag, message + "\n" + args);
    }

    public void debug(String tag, String message, Object args) {
        if (isDebug()) Log.d(tag, message + "\n" + args);
    }

    public void trace(String tag, String message, Object args) {
        if (isDebug()) Log.v(tag, message + "\n" + args);
    }

    public void error(String msg, Throwable t) {
        if (isDebug()) error(DEFAULT_TAG, msg, stackToString(t));
    }

    public void warn(String msg, Throwable t) {
        if (isDebug()) warn(DEFAULT_TAG, msg, stackToString(t));
    }

    public void info(String msg, Throwable t) {
        if (isDebug()) info(DEFAULT_TAG, msg, stackToString(t));
    }

    public void debug(String msg, Throwable t) {
        if (isDebug()) debug(DEFAULT_TAG, msg, stackToString(t));
    }

    public void trace(String msg, Throwable t) {
        if (isDebug()) trace(DEFAULT_TAG, msg, stackToString(t));
    }


    private String stackToString(Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(500);
        baos.toString();
        t.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }
}
