package com.vrs.android.fyreon.adapters;

import android.app.Activity;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.vrs.android.fyreon.R;
import com.vrs.android.fyreon.fragments.WizardFragment;
import com.vrs.android.fyreon.model.WizardModel;

import java.util.List;

public class ImageSlideAdapter extends PagerAdapter {

    FragmentActivity activity;
    List<WizardModel> products;
    WizardFragment homeFragment;

    public ImageSlideAdapter(FragmentActivity activity, List<WizardModel> products,
                             WizardFragment homeFragment) {
        this.activity = activity;
        this.homeFragment = homeFragment;
        this.products = products;

    }

    @Override
    public int getCount() {
        return products.size();
    }

    @Override
    public View instantiateItem(ViewGroup container, final int position) {
        LayoutInflater inflater = (LayoutInflater) activity
                .getSystemService(Activity.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.list_item_wizard, container, false);

        ImageView mImageView = (ImageView) view
                .findViewById(R.id.image_display);
        mImageView.setImageResource(products.get(position).getImageId());
        container.addView(view);
        return view;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View) object);
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

}